BEGIN;

-- vytvor prazdne struktury tabulek, aby mohly byt spusteny obecne SQL dotazy pro naplneni
-- i pro vykres s jednim prvkem
CREATE TABLE IF NOT EXISTS Tech_B   ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), ID VarChar(12), pozn_ID VarChar(255), stav VarChar(3), pres VarChar(3), spol_mer VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), jzm_popis VarChar(255), jzm_popis2 VarChar(80), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_cislo VarChar(20), jzm_delka VarChar(20), jzm_vyska VarChar(20), jzm_koty VarChar(20), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), Jzm_Var1 Integer, Jzm_Var2 Integer, OCID Integer, SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('Tech_B','geometry',102067,'POINT',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='Tech_B' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);

CREATE TABLE IF NOT EXISTS Tech_L   ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), ID VarChar(12), pozn_ID VarChar(255), stav VarChar(3), pres VarChar(3), spol_mer VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), jzm_popis VarChar(255), jzm_popis2 VarChar(80), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_cislo VarChar(20), jzm_delka VarChar(20), jzm_vyska VarChar(20), jzm_koty VarChar(20), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), Jzm_Var1 Integer, Jzm_Var2 Integer, OCID Integer, SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('Tech_L','geometry',102067,'LINESTRING',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='Tech_L' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);

CREATE TABLE IF NOT EXISTS Tech_P   ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), ID VarChar(12), pozn_ID VarChar(255), stav VarChar(3), pres VarChar(3), spol_mer VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), jzm_popis VarChar(255), jzm_popis2 VarChar(80), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_cislo VarChar(20), jzm_delka VarChar(20), jzm_vyska VarChar(20), jzm_koty VarChar(20), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), Jzm_Var1 Integer, Jzm_Var2 Integer, OCID Integer, SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('Tech_P','geometry',102067,'POLYGON',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='Tech_P' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);


CREATE TABLE IF NOT EXISTS Kolej_B  ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), ID VarChar(12), pozn_ID VarChar(255), stav VarChar(3), pres VarChar(3), spol_mer VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), trakce VarChar(1), jr VarChar(3), KCD VarChar(1), poznamka VarChar(255), SPR VarChar(2), TUDU VarChar(6), rozchod VarChar(1), VLA VarChar(255), KM VarChar(10), CKV VarChar(5), KV VarChar(1), plocha VarChar(3), jzm_popis VarChar(255), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_cislo VarChar(20), jzm_delka VarChar(20), jzm_k_vzos VarChar(20), jzm_k_r VarChar(10), jzm_k_di VarChar(5), jzm_k_hi VarChar(5), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), Jzm_Var1 Integer, Jzm_Var2 Integer, OCID Integer, SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('Kolej_B','geometry',102067,'POINT',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='Kolej_B' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);

CREATE TABLE IF NOT EXISTS Kolej_L  ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), ID VarChar(12), pozn_ID VarChar(255), stav VarChar(3), pres VarChar(3), spol_mer VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), trakce VarChar(1), jr VarChar(3), KCD VarChar(1), poznamka VarChar(255), SPR VarChar(2), TUDU VarChar(6), rozchod VarChar(1), VLA VarChar(255), KM VarChar(10), CKV VarChar(5), KV VarChar(1), plocha VarChar(3), jzm_popis VarChar(255), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_cislo VarChar(20), jzm_delka VarChar(20), jzm_k_vzos VarChar(20), jzm_k_r VarChar(10), jzm_k_di VarChar(5), jzm_k_hi VarChar(5), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), Jzm_Var1 Integer, Jzm_Var2 Integer, OCID Integer, SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('Kolej_L','geometry',102067,'LINESTRING',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='Kolej_L' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);

CREATE TABLE IF NOT EXISTS Kolej_P  ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), ID VarChar(12), pozn_ID VarChar(255), stav VarChar(3), pres VarChar(3), spol_mer VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), trakce VarChar(1), jr VarChar(3), KCD VarChar(1), poznamka VarChar(255), SPR VarChar(2), TUDU VarChar(6), rozchod VarChar(1), VLA VarChar(255), KM VarChar(10), CKV VarChar(5), KV VarChar(1), plocha VarChar(3), jzm_popis VarChar(255), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_cislo VarChar(20), jzm_delka VarChar(20), jzm_k_vzos VarChar(20), jzm_k_r VarChar(10), jzm_k_di VarChar(5), jzm_k_hi VarChar(5), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), Jzm_Var1 Integer, Jzm_Var2 Integer, OCID Integer, SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('Kolej_P','geometry',102067,'POLYGON',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='Kolej_P' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);


CREATE TABLE IF NOT EXISTS NavestidB  ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), ID VarChar(12), pozn_ID VarChar(255), stav VarChar(3), pres VarChar(3), spol_mer VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), ISPD_hl VarChar(3), ispd_fid Integer, Oznaceni VarChar(20), Vybava01 VarChar(2), Vybava02 VarChar(2), Vybava03 VarChar(2), Vybava04 VarChar(2), Vybava05 VarChar(2), Vybava06 VarChar(2), Vybava07 VarChar(2), Vybava08 VarChar(2), Vybava09 VarChar(2), Vybava10 VarChar(2), Vybava11 VarChar(2), Vybava12 VarChar(2), jzm_popis VarChar(255), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), ObjCode VarChar(32), jzm_var1 Integer, OCID Integer, SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('NavestidB','geometry',102067,'POINT',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='NavestidB' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);

CREATE TABLE IF NOT EXISTS NavestidL  ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), ID VarChar(12), pozn_ID VarChar(255), stav VarChar(3), pres VarChar(3), spol_mer VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), ISPD_hl VarChar(3), ispd_fid Integer, Oznaceni VarChar(20), Vybava01 VarChar(2), Vybava02 VarChar(2), Vybava03 VarChar(2), Vybava04 VarChar(2), Vybava05 VarChar(2), Vybava06 VarChar(2), Vybava07 VarChar(2), Vybava08 VarChar(2), Vybava09 VarChar(2), Vybava10 VarChar(2), Vybava11 VarChar(2), Vybava12 VarChar(2), jzm_popis VarChar(255), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), ObjCode VarChar(32), jzm_var1 Integer, OCID Integer, SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('NavestidL','geometry',102067,'LINESTRING',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='NavestidL' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);


CREATE TABLE IF NOT EXISTS JZM_B      ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), stav VarChar(3), pres VarChar(3), jev VarChar(3), popis VarChar(3), jzm_popis VarChar(255), jzm_popis2 VarChar(80), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_cislo VarChar(20), jzm_delka VarChar(20), jzm_vyska VarChar(20), jzm_koty VarChar(20), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), jzm_var1 Integer, OCID Integer, tepar VarChar(255), Pusobnost VarChar(10), SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('JZM_B','geometry',102067,'POINT',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='JZM_B' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);

CREATE TABLE IF NOT EXISTS JZM_L      ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), stav VarChar(3), pres VarChar(3), jev VarChar(3), popis VarChar(3), jzm_popis VarChar(255), jzm_popis2 VarChar(80), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_cislo VarChar(20), jzm_delka VarChar(20), jzm_vyska VarChar(20), jzm_koty VarChar(20), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), jzm_var1 Integer, OCID Integer, tepar VarChar(255), Pusobnost VarChar(10), SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('JZM_L','geometry',102067,'LINESTRING',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='JZM_L' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);

CREATE TABLE IF NOT EXISTS JZM_P      ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), stav VarChar(3), pres VarChar(3), jev VarChar(3), popis VarChar(3), jzm_popis VarChar(255), jzm_popis2 VarChar(80), jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_cislo VarChar(20), jzm_delka VarChar(20), jzm_vyska VarChar(20), jzm_koty VarChar(20), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), jzm_var1 Integer, OCID Integer, tepar VarChar(255), Pusobnost VarChar(10), SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('JZM_P','geometry',102067,'POLYGON',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='JZM_P' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);


CREATE TABLE IF NOT EXISTS Rychlostniky   (edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), stav VarChar(3), pres VarChar(3), jev VarChar(3), popis VarChar(3), udaje SMALLINT, udajeD SMALLINT, jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_var1 Integer, jzm_varD Integer, ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), OCID Integer, tepar VarChar(255), Pusobnost VarChar(10), SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('Rychlostniky','geometry',102067,'POINT',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='Rychlostniky' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);


CREATE TABLE IF NOT EXISTS Sklonik       ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), stav VarChar(3), pres VarChar(3), jev VarChar(3), popis VarChar(3), jzm_d1 Real, jzm_s1 Real, jzm_d2 Real, jzm_s2 Real, jzm_km VarChar(20), jzm_kmev VarChar(1), jzm_neu VarChar(20), jzm_r Integer, jzm_popis VarChar(255), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), OCID Integer, tepar VarChar(255), Pusobnost VarChar(10), SourceID Integer, GG Integer, MSLink Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
SELECT AddGeometryColumn ('Sklonik','geometry',102067,'POINT',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='Sklonik' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);


-- Pidat tabulky pro Ostatn prvky pokud se data kt, vynecch ar a popis v exportu nevyskytuj
CREATE TABLE IF NOT EXISTS DO_Ostatni_Grp ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), stav VarChar(3), pres VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), jzm_popis VarChar(255), jzm_popis2 VarChar(80), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), SourceID Integer, GG Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
ALTER TABLE                DO_Ostatni_Grp ADD COLUMN DruhInfr VarChar(10);
SELECT AddGeometryColumn ('DO_Ostatni_Grp','geometry',102067,'GEOMETRYCOLLECTION',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='DO_Ostatni_Grp' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);

CREATE TABLE IF NOT EXISTS DO_Ostatni_Lin ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), stav VarChar(3), pres VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), jzm_popis VarChar(255), jzm_popis2 VarChar(80), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), SourceID Integer, GG Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
ALTER TABLE                DO_Ostatni_Lin ADD COLUMN DruhInfr VarChar(10);

SELECT AddGeometryColumn ('DO_Ostatni_Lin','geometry',102067,'LINESTRING',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='DO_Ostatni_Lin' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);

CREATE TABLE IF NOT EXISTS DO_Ostatni_Sym ( edit_kdo VarChar(50), edit_kdy VarChar(10), over_kdo VarChar(50), over_kdy VarChar(10), cert_typ VarChar(10), cert_kdo VarChar(50), cert_kdy VarChar(10), znep_kdo VarChar(50), znep_kdy VarChar(10), cis_sta_ob VarChar(32), naz_sta_ob VarChar(255), zdroj VarChar(255), nazev VarChar(255), nazev1 VarChar(255), stav VarChar(3), pres VarChar(3), jev VarChar(3), popis VarChar(3), tepar VarChar(255), Pusobnost VarChar(10), jzm_popis VarChar(255), jzm_popis2 VarChar(80), ISPD_hl VarChar(3), ispd_fid Integer, ObjCode VarChar(32), SourceID Integer, GG Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
ALTER TABLE                DO_Ostatni_Sym ADD COLUMN DruhInfr VarChar(10);

SELECT AddGeometryColumn ('DO_Ostatni_Sym','geometry',102067,'POINT',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='DO_Ostatni_Sym' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);


-- Popisy objekt jsou uloeny v DO_Ostatni_Txt. Hodnoty jsou u rodi. obj. a DO_Ostatni_Txt slou pro uloen polohy a symbologie popisu.
-- Metadata ISPD jsou uloena u rodiovskho objektu. U popisu jsou nutn metadata pro vizualizace GSM, DUG, WMS
CREATE TABLE IF NOT EXISTS DO_Ostatni_Txt  ( ObjCode VarChar(32), TextString TEXT,     SourceID Integer, GG Integer, FID Integer PRIMARY KEY, GI_Style BLOB);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN edit_kdo VarChar(50);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN edit_kdy VarChar(10);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN over_kdo VarChar(50);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN over_kdy VarChar(10);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN cert_typ VarChar(10);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN cert_kdo VarChar(50);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN cert_kdy VarChar(10);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN znep_kdo VarChar(50);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN znep_kdy VarChar(10);
ALTER TABLE                DO_Ostatni_Txt ADD COLUMN cis_sta_ob VarChar(32);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN naz_sta_ob VarChar(255);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN zdroj VarChar(255);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN nazev VarChar(255);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN nazev1 VarChar(255);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN stav VarChar(3);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN pres VarChar(3);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN jev VarChar(3);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN popis VarChar(3);
-- ALTER TABLE                DO_Ostatni_Txt ADD COLUMN tepar VarChar(255);
ALTER TABLE                DO_Ostatni_Txt ADD COLUMN Pusobnost VarChar(10);
ALTER TABLE                DO_Ostatni_Txt ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE                DO_Ostatni_Txt ADD COLUMN ISPD_hl VarChar(3);

SELECT AddGeometryColumn ('DO_Ostatni_Txt','geometry',102067,'POINT',3) WHERE NOT (SELECT 1 FROM sqlite_master WHERE type='table' AND name='DO_Ostatni_Txt' AND sql LIKE '%geometry%' UNION ALL SELECT 0 LIMIT 1);

COMMIT;


-- Nerozpoznanm objektm pidej dal sloupce "charakteru metadat" nutn pro vizualizace GSM, DUG, WMS
-- Sprvn by tato data nemla vbec bt, jsou vsledkem ignorovn ervenho dku pi exportu

ALTER TABLE DO_Nerozpoznane_Grp ADD COLUMN Pusobnost VarChar(10);
ALTER TABLE DO_Nerozpoznane_Lin ADD COLUMN Pusobnost VarChar(10);
ALTER TABLE DO_Nerozpoznane_Plg ADD COLUMN Pusobnost VarChar(10);
ALTER TABLE DO_Nerozpoznane_Sym ADD COLUMN Pusobnost VarChar(10);
ALTER TABLE DO_Nerozpoznane_Txt ADD COLUMN Pusobnost VarChar(10);

ALTER TABLE DO_Nerozpoznane_Grp ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE DO_Nerozpoznane_Lin ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE DO_Nerozpoznane_Plg ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE DO_Nerozpoznane_Sym ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE DO_Nerozpoznane_Txt ADD COLUMN DruhInfr VarChar(10);

ALTER TABLE DO_Nerozpoznane_Grp ADD COLUMN ISPD_Hl VarChar(3);
ALTER TABLE DO_Nerozpoznane_Lin ADD COLUMN ISPD_Hl VarChar(3);
ALTER TABLE DO_Nerozpoznane_Plg ADD COLUMN ISPD_Hl VarChar(3);
ALTER TABLE DO_Nerozpoznane_Sym ADD COLUMN ISPD_Hl VarChar(3);
ALTER TABLE DO_Nerozpoznane_Txt ADD COLUMN ISPD_Hl VarChar(3);

UPDATE      DO_Nerozpoznane_Grp SET ISPD_Hl='N.0', DruhInfr='OST', Pusobnost='NIKDO';
UPDATE      DO_Nerozpoznane_Lin SET ISPD_Hl='N.0', DruhInfr='OST', Pusobnost='NIKDO';
UPDATE      DO_Nerozpoznane_Plg SET ISPD_Hl='N.0', DruhInfr='OST', Pusobnost='NIKDO';
UPDATE      DO_Nerozpoznane_Sym SET ISPD_Hl='N.0', DruhInfr='OST', Pusobnost='NIKDO';
UPDATE      DO_Nerozpoznane_Txt SET ISPD_Hl='N.0', DruhInfr='OST', Pusobnost='NIKDO';

BEGIN;

CREATE UNIQUE INDEX CodeToISPDidx ON CodeToISPD (ObjCode);

ALTER TABLE JZM_B        ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE JZM_L        ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE JZM_P        ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE Kolej_B      ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE Kolej_L      ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE Kolej_P      ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE Tech_B       ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE Tech_L       ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE Tech_P       ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE NavestidB    ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE NavestidL    ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE Rychlostniky ADD COLUMN DruhInfr VarChar(10);
ALTER TABLE Sklonik      ADD COLUMN DruhInfr VarChar(10);

-- vypln vychozi hodnoty pokud nejsou u objektu vyplneny
-- cert_typ (oprav star selnk s diakritikou)
UPDATE JZM_B           SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE JZM_L           SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE JZM_P           SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE Kolej_B         SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE Kolej_L         SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE Kolej_P         SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE Tech_B          SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE Tech_L          SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE Tech_P          SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE NavestidB       SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE NavestidL       SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE Rychlostniky    SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE Sklonik         SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE DO_Ostatni_Sym  SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE DO_Ostatni_Lin  SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
UPDATE DO_Ostatni_Grp  SET cert_typ = (CASE TRIM(cert_typ) WHEN 'O' THEN 'OR' WHEN 'SG' THEN 'SZG' WHEN 'TDC' THEN 'TUDC' ELSE cert_typ END) WHERE TRIM(cert_typ) IN('O','TDC','SG');
-- DO_Ostatni_Txt nema sloupec cert_typ.


-- JEV
UPDATE Tech_B       SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Tech_B.ObjCode    = C.ObjCode) WHERE Tech_B.jev IS NULL OR LENGTH(TRIM(Tech_B.jev))=0;
UPDATE Tech_L       SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Tech_L.ObjCode    = C.ObjCode) WHERE Tech_L.jev IS NULL OR LENGTH(TRIM(Tech_L.jev))=0;
UPDATE Tech_P       SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Tech_P.ObjCode    = C.ObjCode) WHERE Tech_P.jev IS NULL OR LENGTH(TRIM(Tech_P.jev))=0;

UPDATE Kolej_B      SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.jev IS NULL OR LENGTH(TRIM(Kolej_B.jev))=0;
UPDATE Kolej_L      SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.jev IS NULL OR LENGTH(TRIM(Kolej_L.jev))=0;
UPDATE Kolej_P      SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.jev IS NULL OR LENGTH(TRIM(Kolej_P.jev))=0;

UPDATE JZM_B        SET jev = (SELECT jev FROM CodeToISPD AS C WHERE JZM_B.ObjCode     = C.ObjCode) WHERE JZM_B.jev IS NULL OR LENGTH(TRIM(JZM_B.jev))=0;
UPDATE JZM_L        SET jev = (SELECT jev FROM CodeToISPD AS C WHERE JZM_L.ObjCode     = C.ObjCode) WHERE JZM_L.jev IS NULL OR LENGTH(TRIM(JZM_L.jev))=0;
UPDATE JZM_P        SET jev = (SELECT jev FROM CodeToISPD AS C WHERE JZM_P.ObjCode     = C.ObjCode) WHERE JZM_P.jev IS NULL OR LENGTH(TRIM(JZM_P.jev))=0;

UPDATE DO_Ostatni_Grp SET jev = (SELECT jev FROM CodeToISPD AS C WHERE DO_Ostatni_Grp.ObjCode = C.ObjCode) WHERE DO_Ostatni_Grp.jev IS NULL OR LENGTH(TRIM(DO_Ostatni_Grp.jev))=0;
UPDATE DO_Ostatni_Lin SET jev = (SELECT jev FROM CodeToISPD AS C WHERE DO_Ostatni_Lin.ObjCode = C.ObjCode) WHERE DO_Ostatni_Lin.jev IS NULL OR LENGTH(TRIM(DO_Ostatni_Lin.jev))=0;
UPDATE DO_Ostatni_Sym SET jev = (SELECT jev FROM CodeToISPD AS C WHERE DO_Ostatni_Sym.ObjCode = C.ObjCode) WHERE DO_Ostatni_Sym.jev IS NULL OR LENGTH(TRIM(DO_Ostatni_Sym.jev))=0;

-- UPDATE DO_Ostatni_Txt SET jev = (SELECT jev FROM CodeToISPD AS C WHERE DO_Ostatni_Txt.ObjCode = C.ObjCode) WHERE DO_Ostatni_Txt.jev IS NULL OR LENGTH(TRIM(DO_Ostatni_Txt.jev))=0;
UPDATE NavestidB    SET jev = (SELECT jev FROM CodeToISPD AS C WHERE NavestidB.ObjCode = C.ObjCode)    WHERE NavestidB.jev IS NULL OR LENGTH(TRIM(NavestidB.jev))=0;
UPDATE NavestidL    SET jev = (SELECT jev FROM CodeToISPD AS C WHERE NavestidL.ObjCode = C.ObjCode)    WHERE NavestidL.jev IS NULL OR LENGTH(TRIM(NavestidL.jev))=0;
UPDATE Sklonik      SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Sklonik.ObjCode   = C.ObjCode)    WHERE Sklonik.jev IS NULL  OR LENGTH(TRIM(Sklonik.jev))=0;
UPDATE Rychlostniky SET jev = (SELECT jev FROM CodeToISPD AS C WHERE Rychlostniky.ObjCode = C.ObjCode) WHERE Rychlostniky.jev IS NULL OR LENGTH(TRIM(Rychlostniky.jev))=0;

-- ISPD_hl & Pusobnost & DruhInfr
UPDATE Tech_B    SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Tech_B.ObjCode    = C.ObjCode) WHERE Tech_B.ISPD_hl IS NULL OR LENGTH(TRIM(Tech_B.ISPD_hl))=0;
UPDATE Tech_L    SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Tech_L.ObjCode    = C.ObjCode) WHERE Tech_L.ISPD_hl IS NULL OR LENGTH(TRIM(Tech_L.ISPD_hl))=0;
UPDATE Tech_P    SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Tech_P.ObjCode    = C.ObjCode) WHERE Tech_P.ISPD_hl IS NULL OR LENGTH(TRIM(Tech_P.ISPD_hl))=0;

UPDATE Tech_B    SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE Tech_B.ObjCode    = C.ObjCode) WHERE Tech_B.Pusobnost IS NULL OR LENGTH(TRIM(Tech_B.Pusobnost))=0;
UPDATE Tech_L    SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE Tech_L.ObjCode    = C.ObjCode) WHERE Tech_L.Pusobnost IS NULL OR LENGTH(TRIM(Tech_L.Pusobnost))=0;
UPDATE Tech_P    SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE Tech_P.ObjCode    = C.ObjCode) WHERE Tech_P.Pusobnost IS NULL OR LENGTH(TRIM(Tech_P.Pusobnost))=0;
UPDATE Tech_B    SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE Tech_L    SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE Tech_P    SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;

UPDATE Tech_B    SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE Tech_B.ObjCode    = C.ObjCode) WHERE Tech_B.DruhInfr IS NULL OR LENGTH(TRIM(Tech_B.DruhInfr))=0;
UPDATE Tech_L    SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE Tech_L.ObjCode    = C.ObjCode) WHERE Tech_L.DruhInfr IS NULL OR LENGTH(TRIM(Tech_L.DruhInfr))=0;
UPDATE Tech_P    SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE Tech_P.ObjCode    = C.ObjCode) WHERE Tech_P.DruhInfr IS NULL OR LENGTH(TRIM(Tech_P.DruhInfr))=0;


UPDATE Kolej_B   SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.ISPD_hl IS NULL OR LENGTH(TRIM(Kolej_B.ISPD_hl))=0;
UPDATE Kolej_L   SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.ISPD_hl IS NULL OR LENGTH(TRIM(Kolej_L.ISPD_hl))=0;
UPDATE Kolej_P   SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.ISPD_hl IS NULL OR LENGTH(TRIM(Kolej_P.ISPD_hl))=0;

UPDATE Kolej_B   SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.Pusobnost IS NULL OR LENGTH(TRIM(Kolej_B.Pusobnost))=0;
UPDATE Kolej_L   SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.Pusobnost IS NULL OR LENGTH(TRIM(Kolej_L.Pusobnost))=0;
UPDATE Kolej_P   SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.Pusobnost IS NULL OR LENGTH(TRIM(Kolej_P.Pusobnost))=0;
UPDATE Kolej_B   SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE Kolej_L   SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE Kolej_P   SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;

UPDATE Kolej_B   SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.DruhInfr IS NULL OR LENGTH(TRIM(Kolej_B.DruhInfr))=0;
UPDATE Kolej_L   SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.DruhInfr IS NULL OR LENGTH(TRIM(Kolej_L.DruhInfr))=0;
UPDATE Kolej_P   SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.DruhInfr IS NULL OR LENGTH(TRIM(Kolej_P.DruhInfr))=0;


UPDATE JZM_B     SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE JZM_B.ObjCode = C.ObjCode)     WHERE JZM_B.ISPD_hl IS NULL OR LENGTH(TRIM(JZM_B.ISPD_hl))=0;
UPDATE JZM_L     SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE JZM_L.ObjCode = C.ObjCode)     WHERE JZM_L.ISPD_hl IS NULL OR LENGTH(TRIM(JZM_L.ISPD_hl))=0;
UPDATE JZM_P     SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE JZM_P.ObjCode = C.ObjCode)     WHERE JZM_P.ISPD_hl IS NULL OR LENGTH(TRIM(JZM_P.ISPD_hl))=0;

UPDATE JZM_B     SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE JZM_B.ObjCode = C.ObjCode)     WHERE JZM_B.Pusobnost IS NULL OR LENGTH(TRIM(JZM_B.Pusobnost))=0;
UPDATE JZM_L     SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE JZM_L.ObjCode = C.ObjCode)     WHERE JZM_L.Pusobnost IS NULL OR LENGTH(TRIM(JZM_L.Pusobnost))=0;
UPDATE JZM_P     SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE JZM_P.ObjCode = C.ObjCode)     WHERE JZM_P.Pusobnost IS NULL OR LENGTH(TRIM(JZM_P.Pusobnost))=0;
UPDATE JZM_B     SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE JZM_L     SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE JZM_P     SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;

UPDATE JZM_B     SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE JZM_B.ObjCode = C.ObjCode)     WHERE JZM_B.DruhInfr IS NULL OR LENGTH(TRIM(JZM_B.DruhInfr))=0;
UPDATE JZM_L     SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE JZM_L.ObjCode = C.ObjCode)     WHERE JZM_L.DruhInfr IS NULL OR LENGTH(TRIM(JZM_L.DruhInfr))=0;
UPDATE JZM_P     SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE JZM_P.ObjCode = C.ObjCode)     WHERE JZM_P.DruhInfr IS NULL OR LENGTH(TRIM(JZM_P.DruhInfr))=0;


UPDATE NavestidB    SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE NavestidB.ObjCode = C.ObjCode) WHERE NavestidB.ISPD_hl IS NULL OR LENGTH(TRIM(NavestidB.ISPD_hl))=0;
UPDATE NavestidL    SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE NavestidL.ObjCode = C.ObjCode) WHERE NavestidL.ISPD_hl IS NULL OR LENGTH(TRIM(NavestidL.ISPD_hl))=0;
UPDATE Sklonik      SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Sklonik.ObjCode   = C.ObjCode) WHERE Sklonik.ISPD_hl IS NULL OR LENGTH(TRIM(Sklonik.ISPD_hl))=0;
UPDATE Rychlostniky SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE Rychlostniky.ObjCode = C.ObjCode) WHERE Rychlostniky.ISPD_hl IS NULL OR LENGTH(TRIM(Rychlostniky.ISPD_hl))=0;

UPDATE NavestidB    SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE NavestidB.ObjCode = C.ObjCode) WHERE NavestidB.Pusobnost IS NULL OR LENGTH(TRIM(NavestidB.Pusobnost))=0;
UPDATE NavestidL    SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE NavestidL.ObjCode = C.ObjCode) WHERE NavestidL.Pusobnost IS NULL OR LENGTH(TRIM(NavestidL.Pusobnost))=0;
UPDATE Sklonik      SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE Sklonik.ObjCode   = C.ObjCode) WHERE Sklonik.Pusobnost IS NULL OR LENGTH(TRIM(Sklonik.Pusobnost))=0;
UPDATE Rychlostniky SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE Rychlostniky.ObjCode = C.ObjCode) WHERE Rychlostniky.Pusobnost IS NULL OR LENGTH(TRIM(Rychlostniky.Pusobnost))=0;
UPDATE NavestidB    SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE NavestidL    SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE Sklonik      SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE Rychlostniky SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;

UPDATE NavestidB    SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE NavestidB.ObjCode = C.ObjCode) WHERE NavestidB.DruhInfr IS NULL OR LENGTH(TRIM(NavestidB.DruhInfr))=0;
UPDATE NavestidL    SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE NavestidL.ObjCode = C.ObjCode) WHERE NavestidL.DruhInfr IS NULL OR LENGTH(TRIM(NavestidL.DruhInfr))=0;
UPDATE Sklonik      SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE Sklonik.ObjCode   = C.ObjCode) WHERE Sklonik.DruhInfr IS NULL OR LENGTH(TRIM(Sklonik.DruhInfr))=0;
UPDATE Rychlostniky SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE Rychlostniky.ObjCode = C.ObjCode) WHERE Rychlostniky.DruhInfr IS NULL OR LENGTH(TRIM(Rychlostniky.DruhInfr))=0;
UPDATE NavestidB    SET DruhInfr = 'OST' WHERE DruhInfr IS NULL;
UPDATE NavestidL    SET DruhInfr = 'OST' WHERE DruhInfr IS NULL;
UPDATE Sklonik      SET DruhInfr = 'OST' WHERE DruhInfr IS NULL;
UPDATE Rychlostniky SET DruhInfr = 'OST' WHERE DruhInfr IS NULL;



UPDATE DO_Ostatni_Grp SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE DO_Ostatni_Grp.ObjCode = C.ObjCode) WHERE DO_Ostatni_Grp.ISPD_hl IS NULL OR LENGTH(TRIM(DO_Ostatni_Grp.ISPD_hl))=0;
UPDATE DO_Ostatni_Lin SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE DO_Ostatni_Lin.ObjCode = C.ObjCode) WHERE DO_Ostatni_Lin.ISPD_hl IS NULL OR LENGTH(TRIM(DO_Ostatni_Lin.ISPD_hl))=0;
UPDATE DO_Ostatni_Sym SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE DO_Ostatni_Sym.ObjCode = C.ObjCode) WHERE DO_Ostatni_Sym.ISPD_hl IS NULL OR LENGTH(TRIM(DO_Ostatni_Sym.ISPD_hl))=0;
UPDATE DO_Ostatni_Txt SET ISPD_hl = (SELECT ISPD_HL_Def FROM CodeToISPD AS C WHERE DO_Ostatni_Txt.ObjCode = C.ObjCode) WHERE DO_Ostatni_Txt.ISPD_hl IS NULL OR LENGTH(TRIM(DO_Ostatni_Txt.ISPD_hl))=0;

UPDATE DO_Ostatni_Grp SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE DO_Ostatni_Grp.ObjCode = C.ObjCode) WHERE DO_Ostatni_Grp.Pusobnost IS NULL OR LENGTH(TRIM(DO_Ostatni_Grp.Pusobnost))=0;
UPDATE DO_Ostatni_Lin SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE DO_Ostatni_Lin.ObjCode = C.ObjCode) WHERE DO_Ostatni_Lin.Pusobnost IS NULL OR LENGTH(TRIM(DO_Ostatni_Lin.Pusobnost))=0;
UPDATE DO_Ostatni_Sym SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE DO_Ostatni_Sym.ObjCode = C.ObjCode) WHERE DO_Ostatni_Sym.Pusobnost IS NULL OR LENGTH(TRIM(DO_Ostatni_Sym.Pusobnost))=0;
UPDATE DO_Ostatni_Txt SET Pusobnost = (SELECT Pusobnost FROM CodeToISPD AS C WHERE DO_Ostatni_Txt.ObjCode = C.ObjCode) WHERE DO_Ostatni_Txt.Pusobnost IS NULL OR LENGTH(TRIM(DO_Ostatni_Txt.Pusobnost))=0;
UPDATE DO_Ostatni_Grp SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE DO_Ostatni_Lin SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE DO_Ostatni_Sym SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;
UPDATE DO_Ostatni_Txt SET Pusobnost = 'NIKDO' WHERE Pusobnost IS NULL;

UPDATE DO_Ostatni_Grp SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE DO_Ostatni_Grp.ObjCode = C.ObjCode) WHERE DO_Ostatni_Grp.DruhInfr IS NULL OR LENGTH(TRIM(DO_Ostatni_Grp.DruhInfr))=0;
UPDATE DO_Ostatni_Lin SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE DO_Ostatni_Lin.ObjCode = C.ObjCode) WHERE DO_Ostatni_Lin.DruhInfr IS NULL OR LENGTH(TRIM(DO_Ostatni_Lin.DruhInfr))=0;
UPDATE DO_Ostatni_Sym SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE DO_Ostatni_Sym.ObjCode = C.ObjCode) WHERE DO_Ostatni_Sym.DruhInfr IS NULL OR LENGTH(TRIM(DO_Ostatni_Sym.DruhInfr))=0;
UPDATE DO_Ostatni_Txt SET DruhInfr = (SELECT DruhInfr FROM CodeToISPD AS C WHERE DO_Ostatni_Txt.ObjCode = C.ObjCode) WHERE DO_Ostatni_Txt.DruhInfr IS NULL OR LENGTH(TRIM(DO_Ostatni_Txt.DruhInfr))=0;
UPDATE DO_Ostatni_Grp SET DruhInfr = 'OST' WHERE DruhInfr IS NULL;
UPDATE DO_Ostatni_Lin SET DruhInfr = 'OST' WHERE DruhInfr IS NULL;
UPDATE DO_Ostatni_Sym SET DruhInfr = 'OST' WHERE DruhInfr IS NULL;
UPDATE DO_Ostatni_Txt SET DruhInfr = 'OST' WHERE DruhInfr IS NULL;

--  OR LENGTH(TRIM())=0
-- popis
UPDATE Tech_B    SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Tech_B.ObjCode    = C.ObjCode) WHERE Tech_B.popis IS NULL OR LENGTH(TRIM(Tech_B.popis))=0;
UPDATE Tech_L    SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Tech_L.ObjCode    = C.ObjCode) WHERE Tech_L.popis IS NULL OR LENGTH(TRIM(Tech_L.popis))=0;
UPDATE Tech_P    SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Tech_P.ObjCode    = C.ObjCode) WHERE Tech_P.popis IS NULL OR LENGTH(TRIM(Tech_P.popis))=0;

UPDATE Kolej_B   SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.popis IS NULL OR LENGTH(TRIM(Kolej_B.popis))=0;
UPDATE Kolej_L   SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.popis IS NULL OR LENGTH(TRIM(Kolej_L.popis))=0;
UPDATE Kolej_P   SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.popis IS NULL OR LENGTH(TRIM(Kolej_P.popis))=0;

UPDATE JZM_B     SET popis = (SELECT popis FROM CodeToISPD AS C WHERE JZM_B.ObjCode     = C.ObjCode) WHERE JZM_B.popis IS NULL OR LENGTH(TRIM(JZM_B.popis))=0;
UPDATE JZM_L     SET popis = (SELECT popis FROM CodeToISPD AS C WHERE JZM_L.ObjCode     = C.ObjCode) WHERE JZM_L.popis IS NULL OR LENGTH(TRIM(JZM_L.popis))=0;
UPDATE JZM_P     SET popis = (SELECT popis FROM CodeToISPD AS C WHERE JZM_P.ObjCode     = C.ObjCode) WHERE JZM_P.popis IS NULL OR LENGTH(TRIM(JZM_P.popis))=0;

UPDATE DO_Ostatni_Grp SET popis = (SELECT popis FROM CodeToISPD AS C WHERE DO_Ostatni_Grp.ObjCode = C.ObjCode) WHERE DO_Ostatni_Grp.popis IS NULL OR LENGTH(TRIM(DO_Ostatni_Grp.popis))=0;
UPDATE DO_Ostatni_Lin SET popis = (SELECT popis FROM CodeToISPD AS C WHERE DO_Ostatni_Lin.ObjCode = C.ObjCode) WHERE DO_Ostatni_Lin.popis IS NULL OR LENGTH(TRIM(DO_Ostatni_Lin.popis))=0;
UPDATE DO_Ostatni_Sym SET popis = (SELECT popis FROM CodeToISPD AS C WHERE DO_Ostatni_Sym.ObjCode = C.ObjCode) WHERE DO_Ostatni_Sym.popis IS NULL OR LENGTH(TRIM(DO_Ostatni_Sym.popis))=0;
-- UPDATE DO_Ostatni_Txt SET popis = (SELECT popis FROM CodeToISPD AS C WHERE DO_Ostatni_Txt.ObjCode = C.ObjCode) WHERE DO_Ostatni_Txt.popis IS NULL OR LENGTH(TRIM(DO_Ostatni_Txt.popis))=0;

UPDATE NavestidB SET popis = (SELECT popis FROM CodeToISPD AS C WHERE NavestidB.ObjCode = C.ObjCode) WHERE NavestidB.popis IS NULL OR LENGTH(TRIM(NavestidB.popis))=0;
UPDATE NavestidL SET popis = (SELECT popis FROM CodeToISPD AS C WHERE NavestidL.ObjCode = C.ObjCode) WHERE NavestidL.popis IS NULL OR LENGTH(TRIM(NavestidL.popis))=0;
UPDATE Sklonik   SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Sklonik.ObjCode   = C.ObjCode) WHERE Sklonik.popis IS NULL OR LENGTH(TRIM(Sklonik.popis))=0;
UPDATE Rychlostniky SET popis = (SELECT popis FROM CodeToISPD AS C WHERE Rychlostniky.ObjCode = C.ObjCode) WHERE Rychlostniky.popis IS NULL OR LENGTH(TRIM(Rychlostniky.popis))=0;

-- rozchod
UPDATE Kolej_B   SET rozchod = (SELECT rozchod FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.rozchod IS NULL OR LENGTH(TRIM(Kolej_B.rozchod))=0;
UPDATE Kolej_L   SET rozchod = (SELECT rozchod FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.rozchod IS NULL OR LENGTH(TRIM(Kolej_L.rozchod))=0;
UPDATE Kolej_P   SET rozchod = (SELECT rozchod FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.rozchod IS NULL OR LENGTH(TRIM(Kolej_P.rozchod))=0;

-- KV
UPDATE Kolej_B   SET KV = (SELECT KV FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.KV IS NULL OR LENGTH(TRIM(Kolej_B.KV))=0;
UPDATE Kolej_L   SET KV = (SELECT KV FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.KV IS NULL OR LENGTH(TRIM(Kolej_L.KV))=0;
UPDATE Kolej_P   SET KV = (SELECT KV FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.KV IS NULL OR LENGTH(TRIM(Kolej_P.KV))=0;

-- plocha
UPDATE Kolej_B   SET plocha = (SELECT plocha FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.plocha IS NULL OR LENGTH(TRIM(Kolej_B.plocha))=0;
UPDATE Kolej_L   SET plocha = (SELECT plocha FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.plocha IS NULL OR LENGTH(TRIM(Kolej_L.plocha))=0;
UPDATE Kolej_P   SET plocha = (SELECT plocha FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.plocha IS NULL OR LENGTH(TRIM(Kolej_P.plocha))=0;

-- nazev
UPDATE Tech_B    SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Tech_B.ObjCode    = C.ObjCode) WHERE Tech_B.nazev IS NULL OR LENGTH(TRIM(Tech_B.nazev))=0;
UPDATE Tech_L    SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Tech_L.ObjCode    = C.ObjCode) WHERE Tech_L.nazev IS NULL OR LENGTH(TRIM(Tech_L.nazev))=0;
UPDATE Tech_P    SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Tech_P.ObjCode    = C.ObjCode) WHERE Tech_P.nazev IS NULL OR LENGTH(TRIM(Tech_P.nazev))=0;

UPDATE Kolej_B   SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Kolej_B.ObjCode   = C.ObjCode) WHERE Kolej_B.nazev IS NULL OR LENGTH(TRIM(Kolej_B.nazev))=0;
UPDATE Kolej_L   SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Kolej_L.ObjCode   = C.ObjCode) WHERE Kolej_L.nazev IS NULL OR LENGTH(TRIM(Kolej_L.nazev))=0;
UPDATE Kolej_P   SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Kolej_P.ObjCode   = C.ObjCode) WHERE Kolej_P.nazev IS NULL OR LENGTH(TRIM(Kolej_P.nazev))=0;

UPDATE JZM_B     SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE JZM_B.ObjCode     = C.ObjCode) WHERE JZM_B.nazev IS NULL OR LENGTH(TRIM(JZM_B.nazev))=0;
UPDATE JZM_L     SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE JZM_L.ObjCode     = C.ObjCode) WHERE JZM_L.nazev IS NULL OR LENGTH(TRIM(JZM_L.nazev))=0;
UPDATE JZM_P     SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE JZM_P.ObjCode     = C.ObjCode) WHERE JZM_P.nazev IS NULL OR LENGTH(TRIM(JZM_P.nazev))=0;

UPDATE DO_Ostatni_Grp SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE DO_Ostatni_Grp.ObjCode = C.ObjCode) WHERE DO_Ostatni_Grp.nazev IS NULL OR LENGTH(TRIM(DO_Ostatni_Grp.nazev))=0;
UPDATE DO_Ostatni_Lin SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE DO_Ostatni_Lin.ObjCode = C.ObjCode) WHERE DO_Ostatni_Lin.nazev IS NULL OR LENGTH(TRIM(DO_Ostatni_Lin.nazev))=0;
UPDATE DO_Ostatni_Sym SET Nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE DO_Ostatni_Sym.ObjCode = C.ObjCode) WHERE DO_Ostatni_Sym.nazev IS NULL OR LENGTH(TRIM(DO_Ostatni_Sym.nazev))=0;
-- UPDATE DO_Ostatni_Txt SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE DO_Ostatni_Txt.ObjCode = C.ObjCode) WHERE DO_Ostatni_Txt.nazev IS NULL OR LENGTH(TRIM(DO_Ostatni_Txt.nazev))=0;

UPDATE NavestidB SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE NavestidB.ObjCode = C.ObjCode) WHERE NavestidB.nazev IS NULL OR LENGTH(TRIM(NavestidB.nazev))=0;
UPDATE NavestidL SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE NavestidL.ObjCode = C.ObjCode) WHERE NavestidL.nazev IS NULL OR LENGTH(TRIM(NavestidL.nazev))=0;
UPDATE Sklonik   SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Sklonik.ObjCode   = C.ObjCode) WHERE Sklonik.nazev IS NULL OR LENGTH(TRIM(Sklonik.nazev))=0;
UPDATE Rychlostniky SET nazev = (SELECT Nazev FROM CodeToISPD AS C WHERE Rychlostniky.ObjCode = C.ObjCode) WHERE Rychlostniky.nazev IS NULL OR LENGTH(TRIM(Rychlostniky.nazev))=0;


-- set Tepar
UPDATE Kolej_B   SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_km    IS NULL THEN '' ELSE jzm_km || '; ' END || CASE WHEN jzm_cislo IS NULL THEN '' ELSE jzm_cislo || '; ' END || CASE WHEN jzm_delka IS NULL THEN '' ELSE jzm_delka || '; ' END || CASE WHEN jzm_k_vzos IS NULL THEN '' ELSE jzm_k_vzos || '; ' END || CASE WHEN jzm_k_r IS NULL THEN '' ELSE 'r=' || jzm_k_r || ';' END) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
UPDATE Kolej_L   SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_km    IS NULL THEN '' ELSE jzm_km || '; ' END || CASE WHEN jzm_cislo IS NULL THEN '' ELSE jzm_cislo || '; ' END || CASE WHEN jzm_delka IS NULL THEN '' ELSE jzm_delka || '; ' END || CASE WHEN jzm_k_vzos IS NULL THEN '' ELSE jzm_k_vzos || '; ' END || CASE WHEN jzm_k_r IS NULL THEN '' ELSE 'r=' || jzm_k_r || ';' END) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
UPDATE Kolej_P   SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_km    IS NULL THEN '' ELSE jzm_km || '; ' END || CASE WHEN jzm_cislo IS NULL THEN '' ELSE jzm_cislo || '; ' END || CASE WHEN jzm_delka IS NULL THEN '' ELSE jzm_delka || '; ' END || CASE WHEN jzm_k_vzos IS NULL THEN '' ELSE jzm_k_vzos || '; ' END || CASE WHEN jzm_k_r IS NULL THEN '' ELSE 'r=' || jzm_k_r || ';' END) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;

UPDATE Tech_B    SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_popis2 IS NULL THEN '' ELSE jzm_popis2 || '; ' END || CASE WHEN jzm_km IS NULL THEN '' ELSE jzm_km || ';' END || CASE WHEN jzm_cislo IS NULL THEN '' ELSE jzm_cislo || '; ' END || CASE WHEN jzm_delka IS NULL THEN '' ELSE jzm_delka || '; ' END || CASE WHEN jzm_vyska IS NULL THEN '' ELSE jzm_vyska || '; ' END || CASE WHEN jzm_koty IS NULL THEN '' ELSE jzm_koty || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
UPDATE Tech_L    SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_popis2 IS NULL THEN '' ELSE jzm_popis2 || '; ' END || CASE WHEN jzm_km IS NULL THEN '' ELSE jzm_km || ';' END || CASE WHEN jzm_cislo IS NULL THEN '' ELSE jzm_cislo || '; ' END || CASE WHEN jzm_delka IS NULL THEN '' ELSE jzm_delka || '; ' END || CASE WHEN jzm_vyska IS NULL THEN '' ELSE jzm_vyska || '; ' END || CASE WHEN jzm_koty IS NULL THEN '' ELSE jzm_koty || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
UPDATE Tech_P    SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_popis2 IS NULL THEN '' ELSE jzm_popis2 || '; ' END || CASE WHEN jzm_km IS NULL THEN '' ELSE jzm_km || ';' END || CASE WHEN jzm_cislo IS NULL THEN '' ELSE jzm_cislo || '; ' END || CASE WHEN jzm_delka IS NULL THEN '' ELSE jzm_delka || '; ' END || CASE WHEN jzm_vyska IS NULL THEN '' ELSE jzm_vyska || '; ' END || CASE WHEN jzm_koty IS NULL THEN '' ELSE jzm_koty || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;

UPDATE JZM_B     SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_popis2 IS NULL THEN '' ELSE jzm_popis2 || '; ' END || CASE WHEN jzm_km IS NULL THEN '' ELSE jzm_km || ';' END || CASE WHEN jzm_cislo IS NULL THEN '' ELSE jzm_cislo || '; ' END || CASE WHEN jzm_delka IS NULL THEN '' ELSE jzm_delka || '; ' END || CASE WHEN jzm_vyska IS NULL THEN '' ELSE jzm_vyska || '; ' END || CASE WHEN jzm_koty IS NULL THEN '' ELSE jzm_koty || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
UPDATE JZM_L     SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_popis2 IS NULL THEN '' ELSE jzm_popis2 || '; ' END || CASE WHEN jzm_km IS NULL THEN '' ELSE jzm_km || ';' END || CASE WHEN jzm_cislo IS NULL THEN '' ELSE jzm_cislo || '; ' END || CASE WHEN jzm_delka IS NULL THEN '' ELSE jzm_delka || '; ' END || CASE WHEN jzm_vyska IS NULL THEN '' ELSE jzm_vyska || '; ' END || CASE WHEN jzm_koty IS NULL THEN '' ELSE jzm_koty || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
UPDATE JZM_P     SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_popis2 IS NULL THEN '' ELSE jzm_popis2 || '; ' END || CASE WHEN jzm_km IS NULL THEN '' ELSE jzm_km || ';' END || CASE WHEN jzm_cislo IS NULL THEN '' ELSE jzm_cislo || '; ' END || CASE WHEN jzm_delka IS NULL THEN '' ELSE jzm_delka || '; ' END || CASE WHEN jzm_vyska IS NULL THEN '' ELSE jzm_vyska || '; ' END || CASE WHEN jzm_koty IS NULL THEN '' ELSE jzm_koty || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;

UPDATE DO_Ostatni_Grp SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_popis2 IS NULL THEN '' ELSE jzm_popis2 || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
UPDATE DO_Ostatni_Lin SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_popis2 IS NULL THEN '' ELSE jzm_popis2 || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
UPDATE DO_Ostatni_Sym SET Tepar = ( CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_popis2 IS NULL THEN '' ELSE jzm_popis2 || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
-- UPDATE DO_Ostatni_Txt Tepar nem vznam, hodnota textu je ve sloupci TextString(byl by to popis sm k sob)

UPDATE NavestidB SET Tepar = ( CASE WHEN Oznaceni  IS NULL THEN '' ELSE Oznaceni ||  '; ' END || CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_km IS NULL THEN '' ELSE jzm_km || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
UPDATE NavestidL SET Tepar = ( CASE WHEN Oznaceni  IS NULL THEN '' ELSE Oznaceni ||  '; ' END || CASE WHEN jzm_popis IS NULL THEN '' ELSE jzm_popis || '; ' END || CASE WHEN jzm_km IS NULL THEN '' ELSE jzm_km || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;

UPDATE Sklonik   SET Tepar = ( CASE WHEN popis IS NULL THEN '' ELSE popis || '; ' END || CASE WHEN jzm_km IS NULL THEN '' ELSE jzm_km || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;
UPDATE Rychlostniky SET Tepar = ( CASE WHEN udaje IS NULL THEN '' ELSE udaje || '; ' END || CASE WHEN udajeD IS NULL THEN '' ELSE udajeD || '; ' END || CASE WHEN jzm_km IS NULL THEN '' ELSE jzm_km || '; ' END ) WHERE Tepar IS NULL OR LENGTH(TRIM(Tepar))=0;

-- Linestyles.sql

DROP TABLE IF EXISTS GI_Linestyles;

CREATE TABLE GI_Linestyles (LinestyleID Integer NOT NULL PRIMARY KEY, Linestyle VarChar(255) NOT NULL, Unit VarChar(2) NOT NULL, Description VarChar(255));

DROP TABLE IF EXISTS GI_Linestyles_Comp;

CREATE TABLE GI_Linestyles_Comp (PKID Integer NOT NULL PRIMARY KEY, LinestyleID Integer NOT NULL, LineID Integer NOT NULL, SortOrder Integer NOT NULL, OffsetX FLOAT, OffsetY FLOAT, LineOffsetY FLOAT, CompType Integer NOT NULL, CompValue TEXT, CompJustify Integer, CompPlacement Integer, GI_Style BLOB, CONSTRAINT GI_Linestyles_Comp_FK_LinestyleID FOREIGN KEY(LinestyleID) REFERENCES GI_Linestyles(LinestyleID) ON DELETE CASCADE);

DROP TABLE IF EXISTS GI_Linestyles_Symbols;

CREATE TABLE GI_Linestyles_Symbols (SymbolID Integer NOT NULL PRIMARY KEY, Symbol VarChar(255) NOT NULL, SymbolType Integer, Description VarChar(255));

DROP TABLE IF EXISTS GI_Linestyles_Symbols_Geom;

CREATE TABLE GI_Linestyles_Symbols_Geom (PKID Integer NOT NULL PRIMARY KEY, SymbolID Integer NOT NULL, CompID Integer NOT NULL, Geometry geometry NOT NULL, GeomType Integer NOT NULL, CompValue TEXT, GI_Style BLOB, CONSTRAINT GI_Linestyles_Symbols_Geom_FK_SymbolID FOREIGN KEY(SymbolID) REFERENCES GI_Linestyles_Symbols(SymbolID) ON DELETE CASCADE );



-- Data GI_Linestyles
insert into GI_Linestyles values(100008, 'Brana', 'd', NULL);
insert into GI_Linestyles values(100009, 'BudovaCD', 'd', NULL);
insert into GI_Linestyles values(100010, 'Desky', 'd', NULL);
insert into GI_Linestyles values(100011, 'Dopzar1', 'd', NULL);
insert into GI_Linestyles values(100012, 'Dopzar10', 'd', NULL);
insert into GI_Linestyles values(100013, 'Dopzar11', 'd', NULL);
insert into GI_Linestyles values(100014, 'Dopzar12', 'd', NULL);
insert into GI_Linestyles values(100015, 'Dopzar13', 'd', NULL);
insert into GI_Linestyles values(100016, 'Dopzar2', 'd', NULL);
insert into GI_Linestyles values(100017, 'Dopzar4', 'd', NULL);
insert into GI_Linestyles values(100018, 'Dopzar5', 'd', NULL);
insert into GI_Linestyles values(100019, 'Dopzar6', 'd', NULL);
insert into GI_Linestyles values(100020, 'Dopzar7', 'd', NULL);
insert into GI_Linestyles values(100021, 'Dopzar8', 'd', NULL);
insert into GI_Linestyles values(100022, 'Dopzar9', 'd', NULL);
insert into GI_Linestyles values(100023, 'Drat1', 'd', NULL);
insert into GI_Linestyles values(100024, 'Drat2', 'd', NULL);
insert into GI_Linestyles values(100025, 'Hran1', 'd', NULL);
insert into GI_Linestyles values(100026, 'Hran10', 'd', NULL);
insert into GI_Linestyles values(100027, 'Hran11', 'd', NULL);
insert into GI_Linestyles values(100028, 'Hran12', 'd', NULL);
insert into GI_Linestyles values(100029, 'Hran2', 'd', NULL);
insert into GI_Linestyles values(100030, 'Hran3', 'd', NULL);
insert into GI_Linestyles values(100031, 'Hran4', 'd', NULL);
insert into GI_Linestyles values(100032, 'Hran5', 'd', NULL);
insert into GI_Linestyles values(100033, 'Hran6', 'd', NULL);
insert into GI_Linestyles values(100034, 'Hran7', 'd', NULL);
insert into GI_Linestyles values(100035, 'HranDP1', 'd', NULL);
insert into GI_Linestyles values(100036, 'HranDP10', 'd', NULL);
insert into GI_Linestyles values(100037, 'HranDP11', 'd', NULL);
insert into GI_Linestyles values(100038, 'HranDP12', 'd', NULL);
insert into GI_Linestyles values(100039, 'HranDP13', 'd', NULL);
insert into GI_Linestyles values(100040, 'HranDP20', 'd', NULL);
insert into GI_Linestyles values(100041, 'HranDP21', 'd', NULL);
insert into GI_Linestyles values(100042, 'HranDP22', 'd', NULL);
insert into GI_Linestyles values(100043, 'HranDP3', 'd', NULL);
insert into GI_Linestyles values(100044, 'HranDP31', 'd', NULL);
insert into GI_Linestyles values(100045, 'HranKU1', 'd', NULL);
insert into GI_Linestyles values(100046, 'HranKU3', 'd', NULL);
insert into GI_Linestyles values(100047, 'HranOB1', 'd', NULL);
insert into GI_Linestyles values(100048, 'HranOB3', 'd', NULL);
insert into GI_Linestyles values(100049, 'HranOK1', 'd', NULL);
insert into GI_Linestyles values(100050, 'HranOK3', 'd', NULL);
insert into GI_Linestyles values(100051, 'HranOP1', 'd', NULL);
insert into GI_Linestyles values(100052, 'HranOP2', 'd', NULL);
insert into GI_Linestyles values(100053, 'HranOP3', 'd', NULL);
insert into GI_Linestyles values(100054, 'HranOP4', 'd', NULL);
insert into GI_Linestyles values(100055, 'HranST1', 'd', NULL);
insert into GI_Linestyles values(100056, 'HranST3', 'd', NULL);
insert into GI_Linestyles values(100057, 'Izokol', 'd', NULL);
insert into GI_Linestyles values(100058, 'Izokolpo', 'd', NULL);
insert into GI_Linestyles values(100059, 'Izokop', 'd', NULL);
insert into GI_Linestyles values(100060, 'Kanal14', 'd', NULL);
insert into GI_Linestyles values(100061, 'Kanal15', 'd', NULL);
insert into GI_Linestyles values(100062, 'Kanal2', 'd', NULL);
insert into GI_Linestyles values(100063, 'Kanal20', 'd', NULL);
insert into GI_Linestyles values(100064, 'Kanal21', 'd', NULL);
insert into GI_Linestyles values(100065, 'Kanal26', 'd', NULL);
insert into GI_Linestyles values(100066, 'Kanal27', 'd', NULL);
insert into GI_Linestyles values(100067, 'Kanal3', 'd', NULL);
insert into GI_Linestyles values(100068, 'Kanal32', 'd', NULL);
insert into GI_Linestyles values(100069, 'Kanal33', 'd', NULL);
insert into GI_Linestyles values(100070, 'Kanal34', 'd', NULL);
insert into GI_Linestyles values(100071, 'Kanal40', 'd', NULL);
insert into GI_Linestyles values(100072, 'Kanal41', 'd', NULL);
insert into GI_Linestyles values(100073, 'Kanal42', 'd', NULL);
insert into GI_Linestyles values(100074, 'Kanal8', 'd', NULL);
insert into GI_Linestyles values(100075, 'Kanal9', 'd', NULL);
insert into GI_Linestyles values(100076, 'Kolbrjed', 'd', NULL);
insert into GI_Linestyles values(100077, 'Kolbrl', 'd', NULL);
insert into GI_Linestyles values(100078, 'Kolbrp', 'd', NULL);
insert into GI_Linestyles values(100079, 'Kolbrz', 'd', NULL);
insert into GI_Linestyles values(100080, 'Line1', 'd', NULL);
insert into GI_Linestyles values(100081, 'Line10', 'd', NULL);
insert into GI_Linestyles values(100082, 'Line13', 'd', NULL);
insert into GI_Linestyles values(100083, 'Line2', 'd', NULL);
insert into GI_Linestyles values(100084, 'Line3', 'd', NULL);
insert into GI_Linestyles values(100085, 'Line4', 'd', NULL);
insert into GI_Linestyles values(100086, 'Line5', 'd', NULL);
insert into GI_Linestyles values(100087, 'Line6', 'd', NULL);
insert into GI_Linestyles values(100088, 'Line7', 'd', NULL);
insert into GI_Linestyles values(100089, 'Line8', 'd', NULL);
insert into GI_Linestyles values(100090, 'Nastup', 'd', NULL);
insert into GI_Linestyles values(100091, 'Operzed1', 'd', NULL);
insert into GI_Linestyles values(100092, 'Osa1', 'd', NULL);
insert into GI_Linestyles values(100093, 'Osa2', 'd', NULL);
insert into GI_Linestyles values(100094, 'Osa3', 'd', NULL);
insert into GI_Linestyles values(100095, 'Osa4', 'd', NULL);
insert into GI_Linestyles values(100096, 'Osa5', 'd', NULL);
insert into GI_Linestyles values(100097, 'OsaK1', 'd', NULL);
insert into GI_Linestyles values(100098, 'OsaK2', 'd', NULL);
insert into GI_Linestyles values(100099, 'OsaK3', 'd', NULL);
insert into GI_Linestyles values(100100, 'Plot1', 'd', NULL);
insert into GI_Linestyles values(100101, 'Plot11a', 'd', NULL);
insert into GI_Linestyles values(100102, 'Plot13', 'd', NULL);
insert into GI_Linestyles values(100103, 'Plot15', 'd', NULL);
insert into GI_Linestyles values(100104, 'Plot17', 'd', NULL);
insert into GI_Linestyles values(100105, 'Plot19', 'd', NULL);
insert into GI_Linestyles values(100106, 'Plot21a', 'd', NULL);
insert into GI_Linestyles values(100107, 'Plot23', 'd', NULL);
insert into GI_Linestyles values(100108, 'Plot25', 'd', NULL);
insert into GI_Linestyles values(100109, 'Plot27', 'd', NULL);
insert into GI_Linestyles values(100110, 'Plot29', 'd', NULL);
insert into GI_Linestyles values(100111, 'Plot3', 'd', NULL);
insert into GI_Linestyles values(100112, 'Plot31', 'd', NULL);
insert into GI_Linestyles values(100113, 'Plot33', 'd', NULL);
insert into GI_Linestyles values(100114, 'Plot5', 'd', NULL);
insert into GI_Linestyles values(100115, 'Plot7', 'd', NULL);
insert into GI_Linestyles values(100116, 'Plot9', 'd', NULL);
insert into GI_Linestyles values(100117, 'Plyn10', 'd', NULL);
insert into GI_Linestyles values(100118, 'Plyn11', 'd', NULL);
insert into GI_Linestyles values(100119, 'Plyn12', 'd', NULL);
insert into GI_Linestyles values(100120, 'Plyn14', 'd', NULL);
insert into GI_Linestyles values(100121, 'Plyn15', 'd', NULL);
insert into GI_Linestyles values(100122, 'Plyn16', 'd', NULL);
insert into GI_Linestyles values(100123, 'Plyn17', 'd', NULL);
insert into GI_Linestyles values(100124, 'Plyn18', 'd', NULL);
insert into GI_Linestyles values(100125, 'Plyn19', 'd', NULL);
insert into GI_Linestyles values(100126, 'Plyn2', 'd', NULL);
insert into GI_Linestyles values(100127, 'Plyn20', 'd', NULL);
insert into GI_Linestyles values(100128, 'Plyn21', 'd', NULL);
insert into GI_Linestyles values(100129, 'Plyn22', 'd', NULL);
insert into GI_Linestyles values(100130, 'Plyn23', 'd', NULL);
insert into GI_Linestyles values(100131, 'Plyn24', 'd', NULL);
insert into GI_Linestyles values(100132, 'Plyn25', 'd', NULL);
insert into GI_Linestyles values(100133, 'Plyn3', 'd', NULL);
insert into GI_Linestyles values(100134, 'Plyn4', 'd', NULL);
insert into GI_Linestyles values(100135, 'Plyn6', 'd', NULL);
insert into GI_Linestyles values(100136, 'Plyn7', 'd', NULL);
insert into GI_Linestyles values(100137, 'Plyn8', 'd', NULL);
insert into GI_Linestyles values(100138, 'Polygon', 'd', NULL);
insert into GI_Linestyles values(100139, 'Prechod', 'd', NULL);
insert into GI_Linestyles values(100140, 'Prejezd', 'd', NULL);
insert into GI_Linestyles values(100141, 'Preves', 'd', NULL);
insert into GI_Linestyles values(100142, 'Prjama', 'd', NULL);
insert into GI_Linestyles values(100143, 'Pulsluc1', 'd', NULL);
insert into GI_Linestyles values(100144, 'Pulsluc2', 'd', NULL);
insert into GI_Linestyles values(100145, 'Pulsluc3', 'd', NULL);
insert into GI_Linestyles values(100146, 'Rozhran1', 'd', NULL);
insert into GI_Linestyles values(100147, 'Rozhran3', 'd', NULL);
insert into GI_Linestyles values(100148, 'Ruzna10', 'd', NULL);
insert into GI_Linestyles values(100149, 'Ruzna11', 'd', NULL);
insert into GI_Linestyles values(100150, 'Ruzna12', 'd', NULL);
insert into GI_Linestyles values(100151, 'Ruzna14', 'd', NULL);
insert into GI_Linestyles values(100152, 'Ruzna15', 'd', NULL);
insert into GI_Linestyles values(100153, 'Ruzna16', 'd', NULL);
insert into GI_Linestyles values(100154, 'Ruzna17', 'd', NULL);
insert into GI_Linestyles values(100155, 'Ruzna2', 'd', NULL);
insert into GI_Linestyles values(100156, 'Ruzna3', 'd', NULL);
insert into GI_Linestyles values(100157, 'Ruzna4', 'd', NULL);
insert into GI_Linestyles values(100158, 'Ruzna6', 'd', NULL);
insert into GI_Linestyles values(100159, 'Ruzna7', 'd', NULL);
insert into GI_Linestyles values(100160, 'Ruzna8', 'd', NULL);
insert into GI_Linestyles values(100161, 'Sdel1', 'd', NULL);
insert into GI_Linestyles values(100162, 'Sdel10', 'd', NULL);
insert into GI_Linestyles values(100163, 'Sdel2', 'd', NULL);
insert into GI_Linestyles values(100164, 'Sdel2a', 'd', NULL);
insert into GI_Linestyles values(100165, 'Sdel3', 'd', NULL);
insert into GI_Linestyles values(100166, 'Sdel4', 'd', NULL);
insert into GI_Linestyles values(100167, 'Sdel5', 'd', NULL);
insert into GI_Linestyles values(100168, 'Sdel6', 'd', NULL);
insert into GI_Linestyles values(100169, 'Sdel7', 'd', NULL);
insert into GI_Linestyles values(100170, 'Sdel8', 'd', NULL);
insert into GI_Linestyles values(100171, 'Sdel9', 'd', NULL);
insert into GI_Linestyles values(100172, 'Sdelnep', 'd', NULL);
insert into GI_Linestyles values(100173, 'Sdneopzl', 'd', NULL);
insert into GI_Linestyles values(100174, 'Silnop11', 'd', NULL);
insert into GI_Linestyles values(100175, 'Silnop12', 'd', NULL);
insert into GI_Linestyles values(100176, 'Silnop14', 'd', NULL);
insert into GI_Linestyles values(100177, 'Silnop15', 'd', NULL);
insert into GI_Linestyles values(100178, 'Silnop16', 'd', NULL);
insert into GI_Linestyles values(100179, 'Silnop19', 'd', NULL);
insert into GI_Linestyles values(100180, 'Silnop2', 'd', NULL);
insert into GI_Linestyles values(100181, 'Silnop20', 'd', NULL);
insert into GI_Linestyles values(100182, 'Silnop22', 'd', NULL);
insert into GI_Linestyles values(100183, 'Silnop23', 'd', NULL);
insert into GI_Linestyles values(100184, 'Silnop24', 'd', NULL);
insert into GI_Linestyles values(100185, 'Silnop27', 'd', NULL);
insert into GI_Linestyles values(100186, 'Silnop28', 'd', NULL);
insert into GI_Linestyles values(100187, 'Silnop3', 'd', NULL);
insert into GI_Linestyles values(100188, 'Silnop30', 'd', NULL);
insert into GI_Linestyles values(100189, 'Silnop31', 'd', NULL);
insert into GI_Linestyles values(100190, 'Silnop32', 'd', NULL);
insert into GI_Linestyles values(100191, 'Silnop33', 'd', NULL);
insert into GI_Linestyles values(100192, 'Silnop34', 'd', NULL);
insert into GI_Linestyles values(100193, 'Silnop4', 'd', NULL);
insert into GI_Linestyles values(100194, 'Silnop6', 'd', NULL);
insert into GI_Linestyles values(100195, 'Silnop7', 'd', NULL);
insert into GI_Linestyles values(100196, 'Silnop8', 'd', NULL);
insert into GI_Linestyles values(100197, 'Slucka1', 'd', NULL);
insert into GI_Linestyles values(100198, 'Slucka2', 'd', NULL);
insert into GI_Linestyles values(100199, 'Slucka3', 'd', NULL);
insert into GI_Linestyles values(100200, 'Snadop', 'd', NULL);
insert into GI_Linestyles values(100201, 'Stena', 'd', NULL);
insert into GI_Linestyles values(100202, 'StenaBet', 'd', NULL);
insert into GI_Linestyles values(100203, 'StenaDr', 'd', NULL);
insert into GI_Linestyles values(100204, 'StenaPl', 'd', NULL);
insert into GI_Linestyles values(100205, 'StenaSkl', 'd', NULL);
insert into GI_Linestyles values(100206, 'Strecha', 'd', NULL);
insert into GI_Linestyles values(100207, 'Teplo10', 'd', NULL);
insert into GI_Linestyles values(100208, 'Teplo11', 'd', NULL);
insert into GI_Linestyles values(100209, 'Teplo12', 'd', NULL);
insert into GI_Linestyles values(100210, 'Teplo14', 'd', NULL);
insert into GI_Linestyles values(100211, 'Teplo15', 'd', NULL);
insert into GI_Linestyles values(100212, 'Teplo16', 'd', NULL);
insert into GI_Linestyles values(100213, 'Teplo18', 'd', NULL);
insert into GI_Linestyles values(100214, 'Teplo19', 'd', NULL);
insert into GI_Linestyles values(100215, 'Teplo2', 'd', NULL);
insert into GI_Linestyles values(100216, 'Teplo20', 'd', NULL);
insert into GI_Linestyles values(100217, 'Teplo22', 'd', NULL);
insert into GI_Linestyles values(100218, 'Teplo23', 'd', NULL);
insert into GI_Linestyles values(100219, 'Teplo24', 'd', NULL);
insert into GI_Linestyles values(100220, 'Teplo26', 'd', NULL);
insert into GI_Linestyles values(100221, 'Teplo27', 'd', NULL);
insert into GI_Linestyles values(100222, 'Teplo28', 'd', NULL);
insert into GI_Linestyles values(100223, 'Teplo3', 'd', NULL);
insert into GI_Linestyles values(100224, 'Teplo30', 'd', NULL);
insert into GI_Linestyles values(100225, 'Teplo31', 'd', NULL);
insert into GI_Linestyles values(100226, 'Teplo32', 'd', NULL);
insert into GI_Linestyles values(100227, 'Teplo34', 'd', NULL);
insert into GI_Linestyles values(100228, 'Teplo35', 'd', NULL);
insert into GI_Linestyles values(100229, 'Teplo36', 'd', NULL);
insert into GI_Linestyles values(100230, 'Teplo38', 'd', NULL);
insert into GI_Linestyles values(100231, 'Teplo39', 'd', NULL);
insert into GI_Linestyles values(100232, 'Teplo4', 'd', NULL);
insert into GI_Linestyles values(100233, 'Teplo40', 'd', NULL);
insert into GI_Linestyles values(100234, 'Teplo6', 'd', NULL);
insert into GI_Linestyles values(100235, 'Teplo7', 'd', NULL);
insert into GI_Linestyles values(100236, 'Teplo8', 'd', NULL);
insert into GI_Linestyles values(100237, 'Uziv15', 'd', NULL);
insert into GI_Linestyles values(100238, 'VecneBrem', 'd', NULL);
insert into GI_Linestyles values(100239, 'Vodovod10', 'd', NULL);
insert into GI_Linestyles values(100240, 'Vodovod11', 'd', NULL);
insert into GI_Linestyles values(100241, 'Vodovod12', 'd', NULL);
insert into GI_Linestyles values(100242, 'Vodovod2', 'd', NULL);
insert into GI_Linestyles values(100243, 'Vodovod3', 'd', NULL);
insert into GI_Linestyles values(100244, 'Vodovod4', 'd', NULL);
insert into GI_Linestyles values(100245, 'Vodovod6', 'd', NULL);
insert into GI_Linestyles values(100246, 'Vodovod7', 'd', NULL);
insert into GI_Linestyles values(100247, 'Vodovod8', 'd', NULL);
insert into GI_Linestyles values(100248, 'Zabnad', 'd', NULL);
insert into GI_Linestyles values(100249, 'Zabpod', 'd', NULL);
insert into GI_Linestyles values(100250, 'Zabpoo', 'd', NULL);
insert into GI_Linestyles values(100251, 'Zabpot', 'd', NULL);
insert into GI_Linestyles values(100252, 'Zasnezky', 'd', NULL);
insert into GI_Linestyles values(100253, 'dratne', 'd', NULL);
insert into GI_Linestyles values(100254, 'prikop1', 'd', NULL);
insert into GI_Linestyles values(100255, 'sdelner', 'd', NULL);
insert into GI_Linestyles values(100256, 'zabnad_', 'd', NULL);
insert into GI_Linestyles values(100257, 'zabpod_', 'd', NULL);
insert into GI_Linestyles values(100258, 'zabpodk', 'd', NULL);
insert into GI_Linestyles values(100259, 'zabpodne', 'd', NULL);
insert into GI_Linestyles values(100260, 'zabpoo_', 'd', NULL);
insert into GI_Linestyles values(100261, 'zabpook', 'd', NULL);
insert into GI_Linestyles values(100262, 'zabpoone', 'd', NULL);
insert into GI_Linestyles values(100263, 'zabpot_', 'd', NULL);
insert into GI_Linestyles values(100264, 'zabpotk', 'd', NULL);



-- Data GI_Linestyles_Comp
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100008,1,1,NULL,NULL,-0.25,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100008,1,2,NULL,NULL,-0.25,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100008,2,1,NULL,NULL,0.25,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100008,2,2,NULL,NULL,0.25,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100009,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100010,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100010,2,1,NULL,NULL,-2,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100010,3,1,NULL,NULL,NULL,4,'LS_010_010',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100011,1,1,NULL,NULL,NULL,1,'12',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100011,1,2,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100011,1,3,NULL,NULL,NULL,3,'1524',0,0,x'49000000000000F03F5100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100011,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100011,1,5,NULL,NULL,NULL,1,'12',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100012,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100012,2,1,NULL,NULL,NULL,2,'-10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100012,2,2,-2,NULL,NULL,4,'LS_010_012',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100013,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100013,2,1,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100013,2,2,-2,NULL,NULL,4,'LS_010_012',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100013,2,3,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100013,2,4,-2,NULL,NULL,4,'LS_010_013',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100014,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100014,2,1,NULL,NULL,NULL,2,'-10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100014,2,2,-2,NULL,NULL,4,'LS_010_014',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100015,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100015,2,1,NULL,NULL,NULL,4,'LS_010_014',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100016,1,1,NULL,NULL,NULL,1,'12',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100016,1,2,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100016,1,3,NULL,NULL,NULL,3,'1000',0,0,x'49000000000000F03F5100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100016,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100016,1,5,NULL,NULL,NULL,1,'12',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100017,1,1,NULL,NULL,NULL,1,'12',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100017,1,2,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100017,1,3,NULL,NULL,NULL,3,'750',0,0,x'49000000000000F03F5100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100017,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100017,1,5,NULL,NULL,NULL,1,'12',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,2,1,NULL,NULL,NULL,2,'-21',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,2,2,NULL,NULL,NULL,4,'LS_010_018',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100018,2,3,NULL,NULL,NULL,2,'-19',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100019,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100019,2,1,NULL,NULL,NULL,2,'-12',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100019,2,2,NULL,NULL,NULL,4,'LS_010_019',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100019,2,3,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100020,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100020,2,1,NULL,NULL,NULL,2,'-15.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100020,2,4,NULL,NULL,NULL,4,'LS_010_DOPZAR',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100020,2,5,NULL,NULL,NULL,2,'-8.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,3,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,6,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,10,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,11,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,12,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,1,13,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,2,1,NULL,NULL,NULL,2,'-15.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,2,2,NULL,NULL,NULL,4,'LS_010_DOPZAR',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100021,2,5,NULL,NULL,NULL,2,'-8.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100022,1,1,NULL,NULL,NULL,1,'4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100022,1,2,NULL,NULL,NULL,2,'-1.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100022,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100022,1,4,NULL,NULL,NULL,2,'-1.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100022,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100022,1,6,NULL,NULL,NULL,2,'-1.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100022,1,7,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100022,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100022,2,1,NULL,NULL,NULL,2,'-19',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100022,2,2,NULL,NULL,NULL,4,'LS_010_DOPZAR',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100023,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100023,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100023,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100023,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100023,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100023,1,6,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100023,1,7,NULL,NULL,NULL,1,'0.4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100023,1,8,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100024,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100024,1,2,NULL,NULL,NULL,2,'-1.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100024,1,3,NULL,NULL,NULL,1,'0.4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100024,1,4,NULL,NULL,NULL,2,'-1.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100025,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100026,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100026,2,1,NULL,NULL,NULL,4,'LS_010_040',1,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100027,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100027,2,1,NULL,NULL,NULL,4,'LS_010_040',4,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100028,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100028,2,1,NULL,NULL,NULL,4,'LS_010_040',5,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100029,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100029,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100030,1,1,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100030,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100031,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100031,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100031,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100031,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100032,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100032,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100032,1,3,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100032,1,4,NULL,NULL,NULL,2,'-1.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100032,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100032,1,6,NULL,NULL,NULL,2,'-1.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100033,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100033,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100034,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100034,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100034,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100034,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100035,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100035,2,1,4,NULL,NULL,4,'LS_010_035',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100036,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100036,2,1,4,NULL,NULL,4,'LS_010_035',5,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100037,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100037,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100037,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100037,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100037,2,1,4,NULL,NULL,4,'LS_010_035',5,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100038,1,1,4,NULL,NULL,4,'LS_010_035',5,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100039,1,1,4,NULL,NULL,4,'LS_010_035',1,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100040,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100040,2,1,NULL,NULL,NULL,4,'LS_010_040',1,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100040,3,1,3.5,NULL,NULL,4,'LS_010_035',1,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100041,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100041,2,1,NULL,NULL,NULL,4,'LS_010_040',4,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100041,3,1,4.5,NULL,NULL,4,'LS_010_035',1,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100042,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100042,2,1,3.5,NULL,NULL,4,'LS_010_035',1,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100042,2,2,NULL,NULL,NULL,4,'LS_010_040',5,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100043,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100043,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100043,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100043,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100043,2,1,4,NULL,NULL,4,'LS_010_035',1,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100044,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100044,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100044,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100044,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100045,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100045,2,1,8.5,NULL,NULL,4,'LS_010_HRANKU',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100046,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100046,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100046,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100046,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100046,2,1,8.5,NULL,NULL,4,'LS_010_HRANKU',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100047,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100047,2,1,10,NULL,NULL,4,'LS_010_HRANOB',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100048,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100048,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100048,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100048,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100048,2,1,10,NULL,NULL,4,'LS_010_HRANOB',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100049,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100049,2,1,12,NULL,NULL,4,'LS_010_HRANOK',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100050,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100050,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100050,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100050,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100050,2,2,12,NULL,NULL,4,'LS_010_HRANOK',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100051,1,1,NULL,NULL,NULL,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100051,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100051,1,3,NULL,0.5,NULL,3,'D',0,0,x'4900000000000000405100000000000000406806');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100051,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100051,1,6,NULL,NULL,NULL,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100051,1,7,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100051,1,8,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100051,1,9,NULL,NULL,NULL,2,'-0.9',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100051,1,10,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100051,1,11,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100052,1,1,NULL,NULL,NULL,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100052,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100052,1,3,NULL,0.5,NULL,3,'M',0,0,x'4900000000000000405100000000000000406806');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100052,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100052,1,6,NULL,NULL,NULL,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100052,1,7,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100052,1,8,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100052,1,9,NULL,NULL,NULL,2,'-0.9',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100052,1,10,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100052,1,11,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100053,1,1,NULL,NULL,NULL,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100053,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100053,1,3,NULL,0.5,NULL,3,'D',0,0,x'4900000000000000405100000000000000406806');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100053,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100053,1,6,NULL,NULL,NULL,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100053,1,7,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100053,1,8,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100053,1,9,NULL,NULL,NULL,2,'-0.9',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100053,1,10,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100053,1,11,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100054,1,1,NULL,NULL,NULL,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100054,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100054,1,3,NULL,0.5,NULL,3,'RT',0,0,x'4900000000000000405100000000000000406806');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100054,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100054,1,6,NULL,NULL,NULL,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100054,1,7,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100054,1,8,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100054,1,9,NULL,NULL,NULL,2,'-0.9',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100054,1,10,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100054,1,11,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100055,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100055,2,1,12,NULL,NULL,4,'LS_010_HRANST',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100056,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100056,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100056,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100056,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100056,2,1,12,NULL,NULL,4,'LS_010_HRANST',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100057,1,1,NULL,NULL,0.75,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100057,2,1,NULL,0.7,NULL,4,'LS_010_106',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100058,1,1,NULL,NULL,0.75,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100058,2,1,NULL,NULL,-0.75,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100058,3,1,NULL,NULL,NULL,4,'LS_010_209',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100059,1,1,NULL,NULL,-0.75,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100059,2,1,NULL,NULL,NULL,4,'LS_010_106',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,2,2,NULL,NULL,NULL,4,'LS_010_KAN2VM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100060,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,2,2,NULL,NULL,NULL,4,'LS_010_KAN2VM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100061,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,1,3,NULL,NULL,NULL,1,'6.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,2,2,NULL,NULL,NULL,4,'LS_010_KAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100062,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,1,5,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,2,2,NULL,NULL,NULL,4,'LS_010_KAN1VV',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100063,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,2,2,NULL,NULL,NULL,4,'LS_010_KAN1VV',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100064,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,2,2,NULL,NULL,NULL,4,'LS_010_KAN1UV',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100065,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,2,2,NULL,NULL,NULL,4,'LS_010_KAN1UV',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100066,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,2,2,NULL,NULL,NULL,4,'LS_010_KAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100067,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,2,1,NULL,NULL,NULL,2,'-12.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,2,2,3,NULL,NULL,4,'LS_010_KAN1Z',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100068,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,2,2,NULL,NULL,NULL,4,'LS_010_KAN1Z',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100069,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,2,2,NULL,NULL,NULL,4,'LS_010_KAN1Z',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100070,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,2,1,NULL,NULL,NULL,2,'-12.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,2,2,3,NULL,NULL,4,'LS_010_KAN2VV',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100071,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,2,2,NULL,NULL,NULL,4,'LS_010_KAN2VV',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100072,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,2,2,NULL,NULL,NULL,4,'LS_010_KAN2VV',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100073,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,2,2,NULL,NULL,NULL,4,'LS_010_KAN1V1U',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100074,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,2,2,NULL,NULL,NULL,4,'LS_010_KAN1V1U',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100075,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100076,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100077,1,1,NULL,NULL,0.5,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100078,1,1,NULL,NULL,-0.5,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100079,1,1,NULL,NULL,0.5,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100079,2,1,NULL,NULL,-0.5,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100080,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100081,1,1,NULL,NULL,NULL,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100081,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100082,1,1,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100082,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100082,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100082,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100083,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100084,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100085,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100085,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100086,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100086,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100087,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100087,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100088,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100088,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100089,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100089,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100090,1,1,NULL,NULL,0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100090,2,1,NULL,NULL,-0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100090,3,1,NULL,NULL,NULL,4,'LS_010_201',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100091,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100091,2,1,NULL,NULL,0.5,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100091,2,2,NULL,NULL,0.5,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100091,2,3,NULL,NULL,0.5,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100092,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100092,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100092,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100092,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,6,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,7,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,8,NULL,NULL,NULL,2,'-3.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,9,NULL,NULL,NULL,3,'1524',0,0,x'49000000000000F03F5100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,10,NULL,NULL,NULL,2,'-3.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,11,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,12,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,13,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,14,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,15,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100093,1,16,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,6,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,7,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,8,NULL,NULL,NULL,2,'-3.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,9,NULL,NULL,NULL,3,'1000',0,0,x'49000000000000F03F5100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,10,NULL,NULL,NULL,2,'-3.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,11,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,12,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,13,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,14,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,15,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100094,1,16,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,6,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,7,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,8,NULL,NULL,NULL,2,'-3.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,9,NULL,NULL,NULL,3,'760',0,0,x'49000000000000F03F5100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,10,NULL,NULL,NULL,2,'-3.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,11,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,12,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,13,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,14,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,15,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100095,1,16,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,6,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,7,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,8,NULL,NULL,NULL,2,'-3.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,9,NULL,NULL,NULL,3,'750',0,0,x'49000000000000F03F5100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,10,NULL,NULL,NULL,2,'-3.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,11,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,12,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,13,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,14,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,15,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100096,1,16,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100097,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100098,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100098,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100099,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100099,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100100,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100100,2,1,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100100,2,2,NULL,NULL,NULL,4,'LS_010_100',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100100,2,3,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100101,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100101,2,1,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100101,2,2,NULL,NULL,NULL,4,'LS_010_101',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100101,2,3,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100102,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100102,2,1,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100102,2,2,-0.5,NULL,NULL,4,'LS_010_102',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100102,2,3,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100102,2,4,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100102,2,5,-0.5,NULL,NULL,4,'LS_010_101',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100102,2,6,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100103,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100103,2,1,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100103,2,2,NULL,NULL,NULL,4,'LS_010_107',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100103,2,3,NULL,NULL,NULL,2,'-8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100104,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100104,2,1,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100104,2,2,-0.5,NULL,NULL,4,'LS_010_107',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100104,2,3,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100104,2,4,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100104,2,5,-0.5,NULL,NULL,4,'LS_010_104',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100104,2,6,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100105,1,1,NULL,NULL,0.5,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100105,3,1,NULL,NULL,NULL,4,'LS_010_254',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100105,4,1,NULL,NULL,-0.5,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100105,4,2,-0.5,NULL,NULL,4,'LS_010_105',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100105,4,3,NULL,NULL,-0.5,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100106,1,1,NULL,NULL,0.5,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100106,3,1,NULL,NULL,NULL,4,'LS_010_254',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100106,4,1,NULL,NULL,-0.5,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100106,4,2,-0.5,NULL,NULL,4,'LS_010_106',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100106,4,3,NULL,NULL,-0.5,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100107,1,1,NULL,NULL,0.5,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100107,3,1,NULL,NULL,NULL,4,'LS_010_254',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100107,4,1,NULL,NULL,-0.5,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100107,4,2,NULL,NULL,NULL,4,'LS_010_107',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100107,4,3,NULL,NULL,-0.5,1,'5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100108,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100108,2,1,NULL,NULL,NULL,4,'LS_010_100',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100109,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100109,2,1,NULL,NULL,NULL,4,'LS_010_106',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100110,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100110,2,1,NULL,NULL,NULL,4,'LS_010_105',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100111,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100111,2,1,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100111,2,2,NULL,NULL,NULL,4,'LS_010_106',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100111,2,3,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100112,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100112,2,1,NULL,NULL,NULL,4,'LS_010_102',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100113,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100113,2,1,NULL,NULL,NULL,4,'LS_010_107',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100114,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100114,2,1,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100114,2,2,NULL,NULL,NULL,4,'LS_010_106',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100114,2,3,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100114,2,4,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100114,2,5,NULL,0.7,NULL,4,'LS_010_106',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100114,2,6,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100115,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100115,2,1,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100115,2,2,-0.5,NULL,NULL,4,'LS_010_105',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100115,2,3,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100116,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100116,2,1,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100116,2,2,NULL,NULL,NULL,4,'LS_010_116',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100116,2,3,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100116,2,4,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100116,2,5,NULL,NULL,NULL,4,'LS_010_105',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100116,2,6,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,7,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,8,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,10,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,11,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,12,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,13,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,14,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,1,15,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,2,4,NULL,NULL,NULL,2,'-15.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,2,5,NULL,NULL,NULL,4,'LS_010_PLYN2I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100117,2,6,NULL,NULL,NULL,2,'-10.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,1,2,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,2,2,NULL,NULL,NULL,4,'LS_010_PLYN2I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100118,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,10,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,13,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,15,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,1,16,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,2,2,NULL,NULL,NULL,4,'LS_010_PLYN2I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100119,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,7,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,8,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,10,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,11,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,12,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,13,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,14,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,1,15,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,2,4,NULL,NULL,NULL,2,'-15.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,2,5,NULL,NULL,NULL,4,'LS_010_PLYN3I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100120,2,6,NULL,NULL,NULL,2,'-10.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,1,2,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,2,2,NULL,NULL,NULL,4,'LS_010_PLYN3I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100121,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,10,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,13,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,15,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,1,16,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,2,2,NULL,NULL,NULL,4,'LS_010_PLYN3I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100122,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,7,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,8,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,10,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,11,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,12,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,13,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,14,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,1,15,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,2,4,NULL,NULL,NULL,2,'-15.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,2,5,NULL,NULL,NULL,4,'LS_010_PLYN4I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100123,2,6,NULL,NULL,NULL,2,'-10.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,7,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,8,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,10,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,11,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,12,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,13,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,14,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,1,15,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,2,4,NULL,NULL,NULL,2,'-15.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,2,5,NULL,NULL,NULL,4,'LS_010_PLYNCO',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100124,2,6,NULL,NULL,NULL,2,'-10.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,1,2,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,2,2,NULL,NULL,NULL,4,'LS_010_PLYNCO',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100125,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,7,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,8,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,10,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,11,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,12,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,13,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,14,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,1,15,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,2,4,NULL,NULL,NULL,2,'-15.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,2,5,NULL,NULL,NULL,4,'LS_010_PLYN0I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100126,2,6,NULL,NULL,NULL,2,'-10.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,10,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,13,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,15,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,1,16,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,2,2,NULL,NULL,NULL,4,'LS_010_PLYNCO',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100127,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,10,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,13,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,15,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,1,16,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,2,2,NULL,NULL,NULL,4,'LS_010_PLYN4I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100128,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100129,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100129,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100129,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100129,1,4,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100129,1,5,NULL,NULL,NULL,4,'LS_010_124',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100129,1,6,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100129,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100129,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100129,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100129,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100130,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100130,1,2,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100130,1,3,NULL,NULL,NULL,4,'LS_010_124',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100130,1,4,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100130,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100130,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100130,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100130,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,6,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,7,NULL,NULL,NULL,4,'LS_010_124',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,8,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,11,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100131,1,14,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,1,2,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,2,2,NULL,NULL,NULL,4,'LS_010_PLYN4I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100132,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,1,2,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,2,2,NULL,NULL,NULL,4,'LS_010_PLYN0I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100133,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,10,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,13,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,15,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,1,16,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,2,2,NULL,NULL,NULL,4,'LS_010_PLYN0I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100134,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,7,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,8,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,10,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,11,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,12,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,13,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,14,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,1,15,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,2,4,NULL,NULL,NULL,2,'-15.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,2,5,NULL,NULL,NULL,4,'LS_010_PLYN1I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100135,2,6,NULL,NULL,NULL,2,'-10.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,1,2,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,2,2,NULL,NULL,NULL,4,'LS_010_PLYN1I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100136,2,3,NULL,NULL,NULL,2,'-23.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,10,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,13,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,15,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,1,16,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,2,1,NULL,NULL,NULL,2,'-17.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,2,2,NULL,NULL,NULL,4,'LS_010_PLYN1I',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100137,2,3,NULL,NULL,NULL,2,'-13.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100138,1,1,NULL,NULL,NULL,4,'LS_010_POLYGON',2,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100139,1,1,NULL,NULL,1,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100139,2,1,NULL,NULL,-1,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100139,3,1,NULL,1,NULL,4,'LS_010_010',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100140,1,1,NULL,NULL,1,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100140,2,1,NULL,NULL,-1,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100141,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100141,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100142,1,1,NULL,NULL,1,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100142,2,1,NULL,NULL,-1,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100142,3,1,NULL,1,NULL,4,'LS_010_010',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100142,3,2,0.8,1,NULL,4,'LS_010_010',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100142,3,3,1.6,1,NULL,4,'LS_010_010',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100142,3,4,2.4,1,NULL,4,'LS_010_010',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100143,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100143,2,1,NULL,NULL,NULL,4,'LS_010_143',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100144,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100144,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100144,2,1,NULL,NULL,NULL,4,'LS_010_143',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100145,1,1,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100145,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100145,2,1,NULL,NULL,NULL,4,'LS_010_143',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100146,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100146,2,1,20,NULL,NULL,4,'LS_010_ROZHR',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100147,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100147,1,2,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100147,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100147,1,4,NULL,NULL,NULL,2,'-0.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100147,2,1,20,NULL,NULL,4,'LS_010_ROZHR',2,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100148,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100148,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100148,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100148,1,4,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100148,1,5,NULL,NULL,NULL,4,'LS_010_148',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100148,1,6,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100148,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100148,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100148,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100148,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100149,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100149,1,2,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100149,1,3,NULL,NULL,NULL,4,'LS_010_148',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100149,1,4,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100149,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100149,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100149,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100149,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,6,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,7,NULL,NULL,NULL,4,'LS_010_148',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,8,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,11,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100150,1,14,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100151,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100151,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100151,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100151,1,4,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100151,1,5,4.3,NULL,NULL,4,'LS_010_KYNETA2',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100151,1,6,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100151,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100151,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100151,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100151,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100152,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100152,1,2,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100152,1,3,NULL,NULL,NULL,4,'LS_010_151',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100152,1,4,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100152,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100152,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100152,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100152,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,6,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,7,NULL,NULL,NULL,4,'LS_010_151',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,8,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,11,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100153,1,14,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100154,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100154,1,2,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100154,1,3,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100155,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100155,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100155,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100155,1,4,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100155,1,5,NULL,NULL,NULL,4,'LS_010_155',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100155,1,6,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100155,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100155,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100155,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100155,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100156,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100156,1,2,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100156,1,3,NULL,NULL,NULL,4,'LS_010_155',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100156,1,4,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100156,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100156,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100156,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100156,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,6,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,7,NULL,NULL,NULL,4,'LS_010_155',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,8,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,11,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100157,1,14,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,1,4,NULL,NULL,NULL,2,'-12',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,2,1,NULL,NULL,NULL,2,'-9',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,2,3,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,2,5,NULL,NULL,NULL,4,'LS_010_PROD',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,2,6,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100158,2,7,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100159,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100159,1,2,NULL,NULL,NULL,2,'-14',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100159,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100159,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100159,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100159,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100159,2,1,NULL,NULL,NULL,2,'-11',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100159,2,3,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100159,2,5,NULL,NULL,NULL,4,'LS_010_PROD',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100159,2,6,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,6,NULL,NULL,NULL,2,'-14',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,11,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,1,14,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,2,1,NULL,NULL,NULL,2,'-11',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,2,3,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,2,5,NULL,NULL,NULL,4,'LS_010_PROD',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100160,2,6,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100161,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100161,1,2,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100161,1,3,NULL,NULL,NULL,4,'LS_010_161',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100161,1,4,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100161,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100161,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100161,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100161,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,6,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,7,NULL,NULL,NULL,4,'LS_010_162',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,8,NULL,NULL,NULL,4,'LS_010_148',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,9,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,10,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,11,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,12,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,13,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,14,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100162,1,15,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100163,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100163,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100163,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100163,1,4,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100163,1,5,NULL,NULL,NULL,4,'LS_010_162',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100163,1,6,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100163,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100163,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100163,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100163,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100164,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100164,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100164,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100164,1,4,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100164,1,5,NULL,NULL,NULL,4,'LS_010_162',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100164,1,6,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100164,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100164,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100164,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100164,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100165,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100165,1,2,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100165,1,3,NULL,NULL,NULL,4,'LS_010_162',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100165,1,4,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100165,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100165,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100165,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100165,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100166,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100166,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100166,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100166,1,4,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100166,1,5,NULL,NULL,NULL,4,'LS_010_161',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100166,1,6,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100166,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100166,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100166,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100166,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100167,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100167,1,2,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100167,1,3,NULL,NULL,NULL,4,'LS_010_161',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100167,1,4,NULL,NULL,NULL,4,'LS_010_167',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100167,1,5,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100167,1,6,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100167,1,7,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100167,1,8,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100167,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,4,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,5,NULL,NULL,NULL,4,'LS_010_162',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,6,NULL,NULL,NULL,4,'LS_010_148',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,7,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,8,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,9,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,10,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100168,1,11,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100169,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100169,1,2,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100169,1,3,NULL,NULL,NULL,4,'LS_010_162',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100169,1,4,NULL,NULL,NULL,4,'LS_010_148',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100169,1,5,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100169,1,6,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100169,1,7,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100169,1,8,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100169,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,4,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,5,NULL,NULL,NULL,4,'LS_010_161',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,6,NULL,NULL,NULL,4,'LS_010_167',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,7,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,8,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,9,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,10,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100170,1,11,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,6,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,7,NULL,NULL,NULL,4,'LS_010_162',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,8,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,11,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100171,1,14,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100172,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100172,1,2,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100172,1,3,NULL,NULL,NULL,4,'LS_010_255',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100172,1,4,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100172,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100172,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100172,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100172,1,9,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,6,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,7,NULL,NULL,NULL,4,'LS_010_161',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,8,NULL,NULL,NULL,4,'LS_010_167',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,9,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,10,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,11,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,12,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,13,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,14,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,15,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,16,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,17,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,18,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,19,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,20,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100173,1,21,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,1,2,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,2,2,1,NULL,NULL,4,'LS_010_KABSIL1KAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100174,2,3,NULL,NULL,NULL,2,'-24',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,12,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,2,2,1,NULL,NULL,4,'LS_010_KABSIL1KAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100175,2,3,NULL,NULL,NULL,2,'-14',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,5,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,2,1,NULL,NULL,NULL,2,'-15',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL2',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100176,2,3,NULL,NULL,NULL,2,'-11',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,1,2,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL2',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100177,2,3,NULL,NULL,NULL,2,'-24',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,12,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL2',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100178,2,3,NULL,NULL,NULL,2,'-14',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,1,2,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,2,2,1,NULL,NULL,4,'LS_010_KABSIL2KAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100179,2,3,NULL,NULL,NULL,2,'-24',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,5,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,2,1,NULL,NULL,NULL,2,'-15',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL0',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100180,2,3,NULL,NULL,NULL,2,'-11',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,12,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,2,2,1,NULL,NULL,4,'LS_010_KABSIL2KAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100181,2,3,NULL,NULL,NULL,2,'-14',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,5,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,2,1,NULL,NULL,NULL,2,'-15',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL3',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100182,2,3,NULL,NULL,NULL,2,'-11',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,1,2,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL3',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100183,2,3,NULL,NULL,NULL,2,'-24',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,12,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL3',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100184,2,3,NULL,NULL,NULL,2,'-14',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,1,2,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,2,2,1,NULL,NULL,4,'LS_010_KABSIL3KAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100185,2,3,NULL,NULL,NULL,2,'-24',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,12,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,2,2,1,NULL,NULL,4,'LS_010_KABSIL3KAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100186,2,3,NULL,NULL,NULL,2,'-14',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,1,2,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL0',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100187,2,3,NULL,NULL,NULL,2,'-24',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,5,NULL,NULL,NULL,1,'2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,7,NULL,NULL,NULL,1,'2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,2,2,3,NULL,NULL,4,'LS_010_KABZEM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100188,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,1,2,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,1,3,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,2,2,NULL,NULL,NULL,4,'LS_010_KABZEM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100189,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,6,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,2,2,NULL,NULL,NULL,4,'LS_010_KABZEM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100190,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,1,2,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,2,2,1,NULL,NULL,4,'LS_010_KABSIL0KAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100191,2,3,NULL,NULL,NULL,2,'-24',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,12,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,2,2,1,NULL,NULL,4,'LS_010_KABSIL0KAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100192,2,3,NULL,NULL,NULL,2,'-14',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,12,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL0',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100193,2,3,NULL,NULL,NULL,2,'-14',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,5,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,2,1,NULL,NULL,NULL,2,'-15',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL1',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100194,2,3,NULL,NULL,NULL,2,'-11',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,1,2,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,1,4,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,1,5,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,1,9,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,1,10,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL1',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100195,2,3,NULL,NULL,NULL,2,'-24',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,6,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,12,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,2,1,NULL,NULL,NULL,2,'-17',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,2,2,NULL,NULL,NULL,4,'LS_010_KABSIL1',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100196,2,3,NULL,NULL,NULL,2,'-14',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100197,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100197,2,1,NULL,NULL,NULL,4,'LS_010_197',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100198,1,1,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100198,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100198,2,1,NULL,NULL,NULL,4,'LS_010_197',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100199,1,1,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100199,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100199,2,1,NULL,NULL,NULL,4,'LS_010_197',3,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,6,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,7,NULL,NULL,NULL,4,'LS_010_200',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,8,NULL,NULL,NULL,2,'-7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,11,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100200,1,14,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100201,1,1,NULL,NULL,0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100201,2,1,NULL,NULL,-0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100201,3,1,NULL,NULL,NULL,4,'LS_010_201',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100202,1,1,NULL,NULL,0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100202,2,1,NULL,NULL,-0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100202,3,1,NULL,NULL,NULL,4,'LS_010_201',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100202,4,1,NULL,-0.8,NULL,3,'ph.s.bet',3,1,x'4900000000000000405100000000000000406804');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100203,1,1,NULL,NULL,0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100203,2,1,NULL,NULL,-0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100203,3,1,NULL,NULL,NULL,4,'LS_010_201',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100203,4,1,NULL,-0.8,NULL,3,'ph.s.d',3,1,x'4900000000000000405100000000000000406804');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100204,1,1,NULL,NULL,0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100204,2,1,NULL,NULL,-0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100204,3,1,NULL,NULL,NULL,4,'LS_010_201',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100204,4,1,NULL,-0.8,NULL,3,'ph.s.pl',3,1,x'4900000000000000405100000000000000406804');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100205,1,1,NULL,NULL,0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100205,2,1,NULL,NULL,-0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100205,3,1,NULL,NULL,NULL,4,'LS_010_201',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100205,4,1,NULL,-0.8,NULL,3,'ph.s.skl',3,1,x'4900000000000000405100000000000000406804');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100206,1,1,NULL,NULL,NULL,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100206,2,1,NULL,NULL,NULL,4,'LS_010_201',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100206,2,2,NULL,NULL,NULL,2,'-1000',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,2,2,3,NULL,NULL,4,'LS_010_TEPPRM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100207,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,2,2,NULL,NULL,NULL,4,'LS_010_TEPPRM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100208,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,2,2,NULL,NULL,NULL,4,'LS_010_TEPPRM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100209,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,2,2,3,NULL,NULL,4,'LS_010_TEPPRMKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100210,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,2,2,NULL,NULL,NULL,4,'LS_010_TEPPRMKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100211,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,2,2,NULL,NULL,NULL,4,'LS_010_TEPPRMKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100212,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,2,2,3,NULL,NULL,4,'LS_010_HORPRM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100213,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,2,2,NULL,NULL,NULL,4,'LS_010_HORPRM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100214,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,2,2,3,NULL,NULL,4,'LS_010_TEPNER',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100215,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,2,2,NULL,NULL,NULL,4,'LS_010_HORPRM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100216,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,2,2,3,NULL,NULL,4,'LS_010_HORPRMKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100217,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,2,2,NULL,NULL,NULL,4,'LS_010_HORPRMKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100218,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,2,2,NULL,NULL,NULL,4,'LS_010_HORPRMKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100219,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,4,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,5,NULL,NULL,NULL,1,'1.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,6,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,7,NULL,NULL,NULL,1,'1.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,8,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,2,2,3,NULL,NULL,4,'LS_010_PARPRM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100220,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,1,2,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,1,3,NULL,NULL,NULL,1,'4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,1,4,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,2,2,NULL,NULL,NULL,4,'LS_010_PARPRM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100221,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,6,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,11,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,12,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,2,2,NULL,NULL,NULL,4,'LS_010_PARPRM',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100222,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,2,2,NULL,NULL,NULL,4,'LS_010_TEPNER',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100223,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,4,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,5,NULL,NULL,NULL,1,'1.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,6,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,7,NULL,NULL,NULL,1,'1.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,8,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,2,2,3,NULL,NULL,4,'LS_010_PARPRMKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100224,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,1,2,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,1,3,NULL,NULL,NULL,1,'4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,1,4,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,2,2,NULL,NULL,NULL,4,'LS_010_PARPRMKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100225,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,6,NULL,NULL,NULL,2,'-5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,11,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,12,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,2,2,NULL,NULL,NULL,4,'LS_010_PARPRMKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100226,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,2,2,3,NULL,NULL,4,'LS_010_TEPSEK',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100227,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,2,2,NULL,NULL,NULL,4,'LS_010_TEPSEK',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100228,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,2,2,NULL,NULL,NULL,4,'LS_010_TEPSEK',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100229,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,2,2,3,NULL,NULL,4,'LS_010_TEPSEKKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100230,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,2,2,NULL,NULL,NULL,4,'LS_010_TEPSEKKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100231,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,2,2,NULL,NULL,NULL,4,'LS_010_TEPNER',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100232,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,2,2,NULL,NULL,NULL,4,'LS_010_TEPSEKKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100233,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,2,2,3,NULL,NULL,4,'LS_010_TEPNER',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,2,2,3,NULL,NULL,4,'LS_010_TEPSEKKAN',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,2,3,3,NULL,NULL,4,'LS_010_KANVOD',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100234,2,4,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,2,2,NULL,NULL,NULL,4,'LS_010_TEPNER',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,2,3,NULL,NULL,NULL,4,'LS_010_KANVOD',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100235,2,4,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,2,2,NULL,NULL,NULL,4,'LS_010_TEPNER',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,2,3,NULL,NULL,NULL,4,'LS_010_KANVOD',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100236,2,4,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100237,1,1,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100237,1,2,NULL,NULL,NULL,2,'-1.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100237,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100237,1,4,NULL,NULL,NULL,2,'-1.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100237,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100237,1,6,NULL,NULL,NULL,2,'-1.8',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100237,1,7,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100237,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100238,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100238,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100238,1,3,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100238,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100238,2,1,NULL,NULL,NULL,2,'-5.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100238,2,2,NULL,0.7,NULL,4,'LS_010_106',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100238,2,3,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,2,2,3,NULL,NULL,4,'LS_010_VODUZI',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100239,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,2,2,NULL,NULL,NULL,4,'LS_010_VODUZI',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100240,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,2,2,NULL,NULL,NULL,4,'LS_010_VODUZI',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100241,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,2,2,3,NULL,NULL,4,'LS_010_VODNER',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100242,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,2,2,NULL,NULL,NULL,4,'LS_010_VODNER',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100243,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,2,2,NULL,NULL,NULL,4,'LS_010_VODNER',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100244,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,8,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,1,12,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,2,1,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,2,2,3,NULL,NULL,4,'LS_010_VODPIT',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100245,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,1,1,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,1,2,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,1,3,NULL,NULL,NULL,1,'6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,1,4,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,1,5,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,1,6,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,1,7,NULL,NULL,NULL,1,'7',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,1,8,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,2,2,NULL,NULL,NULL,4,'LS_010_VODPIT',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100246,2,3,NULL,NULL,NULL,2,'-23',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,6,NULL,NULL,NULL,2,'-4.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,7,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,12,NULL,NULL,NULL,2,'-3.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,13,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,15,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,1,18,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,2,1,NULL,NULL,NULL,2,'-18',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,2,2,NULL,NULL,NULL,4,'LS_010_VODPIT',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100247,2,3,NULL,NULL,NULL,2,'-13',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100248,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100248,1,2,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100248,1,3,NULL,NULL,NULL,3,'Z',0,0,x'4900000000000000405100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100248,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100248,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100248,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100248,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100248,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,2,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,4,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,6,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,7,NULL,NULL,NULL,1,'10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,8,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,9,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,10,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,11,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100249,1,12,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,2,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,4,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,6,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,9,NULL,NULL,NULL,3,'zo',0,0,x'4900000000000000405100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,12,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,13,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,14,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,15,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,16,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,17,NULL,NULL,NULL,1,'10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100250,1,18,NULL,NULL,NULL,2,'-0.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,2,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,4,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,6,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,9,NULL,NULL,NULL,3,'zt',0,0,x'4900000000000000405100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,12,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,13,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,14,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,15,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,16,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,17,NULL,NULL,NULL,1,'10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100251,1,18,NULL,NULL,NULL,2,'-0.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100252,1,1,NULL,NULL,0.25,0,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100252,2,1,NULL,NULL,-0.25,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100252,2,2,NULL,NULL,-0.25,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100253,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100253,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100253,1,3,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100253,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100253,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100253,1,6,NULL,NULL,NULL,2,'-1.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100253,1,7,NULL,NULL,NULL,1,'0.4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100253,1,8,NULL,NULL,NULL,2,'-1.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100254,1,1,NULL,NULL,0.5,1,'4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100254,2,1,NULL,NULL,-0.5,1,'4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100254,3,1,NULL,NULL,NULL,2,'-4',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100254,3,2,NULL,NULL,NULL,4,'LS_010_254',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100254,4,1,NULL,NULL,NULL,4,'LS_010_254',1,1,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100255,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100255,1,2,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100255,1,3,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100255,1,4,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100255,1,5,NULL,NULL,NULL,4,'LS_010_255',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100255,1,6,NULL,NULL,NULL,2,'-6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100255,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100255,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100255,1,9,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100255,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100256,1,1,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100256,1,2,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100256,1,3,NULL,NULL,NULL,3,'Z',0,0,x'4900000000000000405100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100256,1,4,NULL,NULL,NULL,2,'-3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100256,1,5,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100256,1,6,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100256,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100256,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,2,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,4,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,6,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,7,NULL,NULL,NULL,1,'10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,8,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,9,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,10,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,11,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100257,1,12,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,1,NULL,NULL,NULL,1,'10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,2,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,4,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,6,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,7,NULL,NULL,NULL,1,'1.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,8,NULL,NULL,NULL,4,'LS_010_148',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,9,NULL,NULL,NULL,1,'1.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,10,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,11,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,12,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,13,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100258,1,14,NULL,NULL,NULL,2,'-1.1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,3,NULL,NULL,NULL,1,'0.6',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,4,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,6,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,7,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,8,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,9,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,10,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,11,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,12,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,13,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,14,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,15,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100259,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,4,NULL,NULL,NULL,2,'-1.2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,6,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,9,NULL,NULL,NULL,3,'zo',0,0,x'4900000000000000405100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,13,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,14,NULL,NULL,NULL,2,'-1.2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,15,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,17,NULL,NULL,NULL,1,'10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100260,1,18,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,4,NULL,NULL,NULL,2,'-1.2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,6,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,9,NULL,NULL,NULL,3,'ZO',0,0,x'4900000000000000405100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,10,NULL,NULL,NULL,4,'LS_010_148',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,11,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,12,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,13,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,14,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,15,NULL,NULL,NULL,2,'-1.2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,16,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,17,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,18,NULL,NULL,NULL,1,'10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100261,1,19,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,4,NULL,NULL,NULL,2,'-1.2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,6,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,9,NULL,NULL,NULL,3,'zo',0,0,x'4900000000000000405100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,13,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,14,NULL,NULL,NULL,2,'-1.2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,15,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,16,NULL,NULL,NULL,2,'-2.5',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,17,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,18,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,19,NULL,NULL,NULL,1,'1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,20,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,21,NULL,NULL,NULL,1,'2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100262,1,22,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,4,NULL,NULL,NULL,2,'-1.2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,6,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,9,NULL,NULL,NULL,3,'zt',0,0,x'4900000000000000405100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,10,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,11,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,12,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,13,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,14,NULL,NULL,NULL,2,'-1.2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,15,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,16,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,17,NULL,NULL,NULL,1,'10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100263,1,18,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,1,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,2,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,3,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,4,NULL,NULL,NULL,2,'-1.2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,5,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,6,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,7,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,8,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,9,NULL,NULL,NULL,3,'ZT',0,0,x'4900000000000000405100000000000000406805');
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,10,NULL,NULL,NULL,4,'LS_010_148',0,0,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,11,NULL,NULL,NULL,2,'-2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,12,NULL,NULL,NULL,1,'3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,13,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,14,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,15,NULL,NULL,NULL,2,'-1.2',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,16,NULL,NULL,NULL,1,'0.3',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,17,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,18,NULL,NULL,NULL,1,'10',NULL,NULL,NULL);
insert into GI_Linestyles_Comp (LinestyleID,LineID,SortOrder,OffsetX,OffsetY,LineOffsetY,CompType,CompValue,CompJustify,CompPlacement,GI_Style) values(100264,1,19,NULL,NULL,NULL,2,'-1',NULL,NULL,NULL);



-- Data GI_Linestyles_Symbols
insert into GI_Linestyles_Symbols values(100001,'LS_010_010',1,NULL);
insert into GI_Linestyles_Symbols values(100002,'LS_010_012',1,NULL);
insert into GI_Linestyles_Symbols values(100003,'LS_010_013',1,NULL);
insert into GI_Linestyles_Symbols values(100004,'LS_010_014',1,NULL);
insert into GI_Linestyles_Symbols values(100005,'LS_010_018',1,NULL);
insert into GI_Linestyles_Symbols values(100006,'LS_010_019',1,NULL);
insert into GI_Linestyles_Symbols values(100007,'LS_010_020',1,NULL);
insert into GI_Linestyles_Symbols values(100008,'LS_010_021',1,NULL);
insert into GI_Linestyles_Symbols values(100009,'LS_010_035',1,NULL);
insert into GI_Linestyles_Symbols values(100010,'LS_010_040',1,NULL);
insert into GI_Linestyles_Symbols values(100011,'LS_010_045',1,NULL);
insert into GI_Linestyles_Symbols values(100012,'LS_010_049',1,NULL);
insert into GI_Linestyles_Symbols values(100013,'LS_010_055',1,NULL);
insert into GI_Linestyles_Symbols values(100014,'LS_010_056',1,NULL);
insert into GI_Linestyles_Symbols values(100015,'LS_010_057',1,NULL);
insert into GI_Linestyles_Symbols values(100016,'LS_010_060',1,NULL);
insert into GI_Linestyles_Symbols values(100017,'LS_010_061',1,NULL);
insert into GI_Linestyles_Symbols values(100018,'LS_010_063',1,NULL);
insert into GI_Linestyles_Symbols values(100019,'LS_010_068',1,NULL);
insert into GI_Linestyles_Symbols values(100020,'LS_010_100',1,NULL);
insert into GI_Linestyles_Symbols values(100021,'LS_010_101',1,NULL);
insert into GI_Linestyles_Symbols values(100022,'LS_010_102',1,NULL);
insert into GI_Linestyles_Symbols values(100023,'LS_010_104',1,NULL);
insert into GI_Linestyles_Symbols values(100024,'LS_010_105',1,NULL);
insert into GI_Linestyles_Symbols values(100025,'LS_010_106',1,NULL);
insert into GI_Linestyles_Symbols values(100026,'LS_010_107',1,NULL);
insert into GI_Linestyles_Symbols values(100027,'LS_010_116',1,NULL);
insert into GI_Linestyles_Symbols values(100028,'LS_010_117',1,NULL);
insert into GI_Linestyles_Symbols values(100029,'LS_010_120',1,NULL);
insert into GI_Linestyles_Symbols values(100030,'LS_010_123',1,NULL);
insert into GI_Linestyles_Symbols values(100031,'LS_010_124',1,NULL);
insert into GI_Linestyles_Symbols values(100032,'LS_010_126',1,NULL);
insert into GI_Linestyles_Symbols values(100033,'LS_010_135',1,NULL);
insert into GI_Linestyles_Symbols values(100034,'LS_010_143',1,NULL);
insert into GI_Linestyles_Symbols values(100035,'LS_010_148',1,NULL);
insert into GI_Linestyles_Symbols values(100036,'LS_010_151',1,NULL);
insert into GI_Linestyles_Symbols values(100037,'LS_010_155',1,NULL);
insert into GI_Linestyles_Symbols values(100038,'LS_010_158',1,NULL);
insert into GI_Linestyles_Symbols values(100039,'LS_010_161',1,NULL);
insert into GI_Linestyles_Symbols values(100040,'LS_010_162',1,NULL);
insert into GI_Linestyles_Symbols values(100041,'LS_010_167',1,NULL);
insert into GI_Linestyles_Symbols values(100042,'LS_010_174',1,NULL);
insert into GI_Linestyles_Symbols values(100043,'LS_010_175',1,NULL);
insert into GI_Linestyles_Symbols values(100044,'LS_010_180',1,NULL);
insert into GI_Linestyles_Symbols values(100045,'LS_010_188',1,NULL);
insert into GI_Linestyles_Symbols values(100046,'LS_010_197',1,NULL);
insert into GI_Linestyles_Symbols values(100047,'LS_010_200',1,NULL);
insert into GI_Linestyles_Symbols values(100048,'LS_010_201',1,NULL);
insert into GI_Linestyles_Symbols values(100049,'LS_010_207',1,NULL);
insert into GI_Linestyles_Symbols values(100050,'LS_010_208',1,NULL);
insert into GI_Linestyles_Symbols values(100051,'LS_010_209',1,NULL);
insert into GI_Linestyles_Symbols values(100052,'LS_010_220',1,NULL);
insert into GI_Linestyles_Symbols values(100053,'LS_010_221',1,NULL);
insert into GI_Linestyles_Symbols values(100054,'LS_010_239',1,NULL);
insert into GI_Linestyles_Symbols values(100055,'LS_010_245',1,NULL);
insert into GI_Linestyles_Symbols values(100056,'LS_010_254',1,NULL);
insert into GI_Linestyles_Symbols values(100057,'LS_010_255',1,NULL);
insert into GI_Linestyles_Symbols values(100101,'LS_010_BRANA',1,'LS 008');
insert into GI_Linestyles_Symbols values(100102,'LS_010_DOPZAR',1,'LS 020');
insert into GI_Linestyles_Symbols values(100103,'LS_010_HRANDP',1,'LS 035');
insert into GI_Linestyles_Symbols values(100104,'LS_010_HRANKU',1,'LS 045');
insert into GI_Linestyles_Symbols values(100105,'LS_010_HRANOB',1,'LS 047');
insert into GI_Linestyles_Symbols values(100106,'LS_010_HRANOK',1,'LS 049');
insert into GI_Linestyles_Symbols values(100107,'LS_010_HRANST',1,'LS 055');
insert into GI_Linestyles_Symbols values(100108,'LS_010_KAN2VM',1,'LS 060');
insert into GI_Linestyles_Symbols values(100109,'LS_010_KAN',1,'LS 062');
insert into GI_Linestyles_Symbols values(100110,'LS_010_KAN1VV',1,'LS 063');
insert into GI_Linestyles_Symbols values(100111,'LS_010_KAN1UV',1,'LS 065');
insert into GI_Linestyles_Symbols values(100112,'LS_010_KAN1Z',1,'LS 068');
insert into GI_Linestyles_Symbols values(100113,'LS_010_KAN2VV',1,'LS 071');
insert into GI_Linestyles_Symbols values(100114,'LS_010_KAN1V1U',1,'LS 074');
insert into GI_Linestyles_Symbols values(100115,'LS_010_PLYN2I',1,'LS 117');
insert into GI_Linestyles_Symbols values(100116,'LS_010_PLYN3I',1,'LS 120');
insert into GI_Linestyles_Symbols values(100117,'LS_010_PLYN4I',1,'LS 123');
insert into GI_Linestyles_Symbols values(100118,'LS_010_PLYNCO',1,'LS 124');
insert into GI_Linestyles_Symbols values(100119,'LS_010_PLYN0I',1,'LS 126');
insert into GI_Linestyles_Symbols values(100120,'LS_010_PLYNO',1,'LS 129');
insert into GI_Linestyles_Symbols values(100121,'LS_010_PLYN1I',1,'LS 135');
insert into GI_Linestyles_Symbols values(100122,'LS_010_ROZHR',1,'LS 146');
insert into GI_Linestyles_Symbols values(100123,'LS_010_KYNETA',1,'LS 148');
insert into GI_Linestyles_Symbols values(100124,'LS_010_KYNETA2',1,'LS 151');
insert into GI_Linestyles_Symbols values(100125,'LS_010_POPO',1,'LS 155');
insert into GI_Linestyles_Symbols values(100126,'LS_010_PROD',1,'LS 158');
insert into GI_Linestyles_Symbols values(100127,'LS_010_KABOPT',1,'LS 161');
insert into GI_Linestyles_Symbols values(100128,'LS_010_KABSDKAN',1,'LS 162');
insert into GI_Linestyles_Symbols values(100129,'LS_010_KABSD',1,'LS 163');
insert into GI_Linestyles_Symbols values(100130,'LS_010_KABOPTKAN',1,'LS 167');
insert into GI_Linestyles_Symbols values(100131,'LS_010_KABSDNEP',1,'LS 172');
insert into GI_Linestyles_Symbols values(100132,'LS_010_KABSIL1KAN',1,'LS 174');
insert into GI_Linestyles_Symbols values(100133,'LS_010_KABSIL2',1,'LS 178');
insert into GI_Linestyles_Symbols values(100134,'LS_010_KABSIL2KAN',1,'LS 179');
insert into GI_Linestyles_Symbols values(100135,'LS_010_KABSIL0',1,'LS 180');
insert into GI_Linestyles_Symbols values(100136,'LS_010_KABSIL3',1,'LS 182');
insert into GI_Linestyles_Symbols values(100137,'LS_010_KABSIL3KAN',1,'LS 185');
insert into GI_Linestyles_Symbols values(100138,'LS_010_KABZEM',1,'LS 188');
insert into GI_Linestyles_Symbols values(100139,'LS_010_KABSIL0KAN',1,'LS 191');
insert into GI_Linestyles_Symbols values(100140,'LS_010_KABSIL1',1,'LS 194');
insert into GI_Linestyles_Symbols values(100141,'LS_010_TEPPRM',1,'LS 207');
insert into GI_Linestyles_Symbols values(100142,'LS_010_TEPPRMKAN',1,'LS 210');
insert into GI_Linestyles_Symbols values(100143,'LS_010_KANVOD',1,'LS 211');
insert into GI_Linestyles_Symbols values(100144,'LS_010_HORPRM',1,'LS 213');
insert into GI_Linestyles_Symbols values(100145,'LS_010_TEPNER',1,'LS 215');
insert into GI_Linestyles_Symbols values(100146,'LS_010_HORPRMKAN',1,'LS 217');
insert into GI_Linestyles_Symbols values(100147,'LS_010_PARPRM',1,'LS 220');
insert into GI_Linestyles_Symbols values(100148,'LS_010_PARPRMKAN',1,'LS 224');
insert into GI_Linestyles_Symbols values(100149,'LS_010_TEPSEK',1,'LS 227');
insert into GI_Linestyles_Symbols values(100150,'LS_010_TEPSEKKAN',1,'LS 230');
insert into GI_Linestyles_Symbols values(100151,'LS_010_VODUZI',1,'LS 239');
insert into GI_Linestyles_Symbols values(100152,'LS_010_VODNER',1,'LS 242');
insert into GI_Linestyles_Symbols values(100153,'LS_010_VODPIT',1,'LS 245');
insert into GI_Linestyles_Symbols values(100154,'LS_010_POLBOD',1,'LS 137');
insert into GI_Linestyles_Symbols values(100155,'LS_010_POLYGON',1,'LS 138');



-- Data GI_Linestyles_Symbols_Geom
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100001,1,x'0001FFFFFFFF000000000000000000000000000000C0000000000000000000000000000000007C020000000200000000000000000000000000000000000000000000000000000000000000000000C0FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100002,1,x'0001FFFFFFFF00000000000000000000000000000000000000000000F03F000000000000F03F7C020000000200000000000000000000000000000000000000000000000000F03F000000000000F03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100003,1,x'0001FFFFFFFF000000000000F0BF000000000000F0BF000000000000000000000000000000007C020000000200000000000000000000000000000000000000000000000000F0BF000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100004,1,x'0001FFFFFFFF1383C0CAA145C6BF1383C0CAA145C6BF676666666666C63F676666666666C63F7C02000000020000001383C0CAA145C6BF1383C0CAA145C6BF676666666666C63F676666666666C63FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100004,2,x'0001FFFFFFFF010000000000D0BF010000000000D0BF010000000000D03F010000000000D03F7C0300000001000000310000000000000000000000010000000000D0BFD1A26D0F15B5A03F9D68EC92EAB9CFBF910693C17D90B03F17BF4847DDE8CEBF65A9AEA6E27DB83F488D32CF6B90CDBF000000000000C03FAD4C58E87AB6CBBFEA13953FF97AC33F9524578B2663C9BFCD3B7F669EA0C63FCE3B7F669EA0C6BF9324578B2663C93FEC13953FF97AC3BFAC4C58E87AB6CB3F020000000000C0BF488D32CF6B90CD3F66A9AEA6E27DB8BF16BF4847DDE8CE3F950693C17D90B0BF9D68EC92EAB9CF3FD6A26D0F15B5A0BF010000000000D03F085C143326A671BC9E68EC92EAB9CF3FCAA26D0F15B5A03F18BF4847DDE8CE3F8B0693C17D90B03F488D32CF6B90CD3F64A9AEA6E27DB83FAD4C58E87AB6CB3FFEFFFFFFFFFFBF3F9624578B2663C93FE813953FF97AC33FCE3B7F669EA0C63FCD3B7F669EA0C63FED13953FF97AC33F9324578B2663C93F040000000000C03FAB4C58E87AB6CB3F67A9AEA6E27DB83F488D32CF6B90CD3F960693C17D90B03F16BF4847DDE8CE3FE0A26D0F15B5A03F9D68EC92EAB9CF3F085C143326A6813C010000000000D03FB8A26D0F15B5A0BF9E68EC92EAB9CF3F8A0693C17D90B0BF18BF4847DDE8CE3F63A9AEA6E27DB8BF498D32CF6B90CD3FF7FFFFFFFFFFBFBFB04C58E87AB6CB3FE813953FF97AC3BF9624578B2663C93FCD3B7F669EA0C6BFCF3B7F669EA0C63F9224578B2663C9BFED13953FF97AC33FAA4C58E87AB6CBBF050000000000C03F468D32CF6B90CDBF6FA9AEA6E27DB83F15BF4847DDE8CEBF9F0693C17D90B03F9D68EC92EAB9CFBFD3A26D0F15B5A03F010000000000D0BF0C8A9E4C39798A3C9E68EC92EAB9CFBFC6A26D0F15B5A0BF18BF4847DDE8CEBF890693C17D90B0BF478D32CF6B90CDBF69A9AEA6E27DB8BFB04C58E87AB6CBBFF6FFFFFFFFFFBFBF9424578B2663C9BFEA13953FF97AC3BFCF3B7F669EA0C6BFCC3B7F669EA0C6BFED13953FF97AC3BF9224578B2663C9BF050000000000C0BFAA4C58E87AB6CBBF70A9AEA6E27DB8BF468D32CF6B90CDBFA00693C17D90B0BF15BF4847DDE8CEBFD5A26D0F15B5A0BF9D68EC92EAB9CFBF0000000000000000010000000000D0BFFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100005,1,x'0001FFFFFFFF500D1F829700F0BF00000000000000009A99B8FBD0FEEF3FFCA9F1D24D62203D7C0200000002000000500D1F829700F0BFFCA9F1D24D62203D9A99B8FBD0FEEF3F0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100005,2,x'0001FFFFFFFF410D1F829700F0BF410D1F829700F0BF410D1F829700F03F00000000000000007C0200000021000000410D1F829700F0BF0000000000000000F32B8732BBD9EFBF4B2170579418B9BFDE11AE01C163EFBFAEAFC9B2A4F9C8BF9631C84E63A0EEBF71B9E61AB694D2BFF5CC9AC28391EDBF2F08E891CA7ED8BF06F81C2EBE39ECBF6699A1E67A2CDEBF4B06051C629CEABF179B8292E3C7E1BFF59E3CA76ABDE8BFD1685860B34DE4BF10145BAA74A1E6BF0F145BAA74A1E6BFD1685860B34DE4BFF59E3CA76ABDE8BF189B8292E3C7E1BF4B06051C629CEABF6999A1E67A2CDEBF05F81C2EBE39ECBF3008E891CA7ED8BFF5CC9AC28391EDBF71B9E61AB694D2BF9731C84E63A0EEBFB1AFC9B2A4F9C8BFDE11AE01C163EFBF572170579418B9BFF22B8732BBD9EFBFFF14A552CDA691BC410D1F829700F0BF4E2170579418B93FF32B8732BBD9EFBFACAFC9B2A4F9C83FDE11AE01C163EFBF6EB9E61AB694D23F9731C84E63A0EEBF2E08E891CA7ED83FF5CC9AC28391EDBF6799A1E67A2CDE3F06F81C2EBE39ECBF159B8292E3C7E13F4D06051C629CEABFD0685860B34DE43FF69E3CA76ABDE8BF0F145BAA74A1E63F10145BAA74A1E6BFF59E3CA76ABDE83FD1685860B34DE4BF4C06051C629CEA3F179B8292E3C7E1BF05F81C2EBE39EC3F6A99A1E67A2CDEBFF5CC9AC28391ED3F3108E891CA7ED8BF9631C84E63A0EE3F72B9E61AB694D2BFDE11AE01C163EF3FBBAFC9B2A4F9C8BFF22B8732BBD9EF3F5B2170579418B9BF410D1F829700F03FFF14A552CDA6A1BCFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100006,1,x'0001FFFFFFFF000000000000F0BF0000000000000000000000000000F03F000000000000F03F7C0200000021000000000000000000F0BF00000000000000002625D1A38DD8EFBF2CB429BCA617B93FB05CF7CF9762EFBF0AA6693CB8F8C83FDA2DC656419FEEBF059FD52E0694D23F468D32CF6B90EDBF63A9AEA6E27DD83FB1BD80F1B238ECBF3BF606385D2BDE3FA3A10E29669BEABFC868AE393BC7E13F4117156B80BCE8BFD61D0925F34CE43FCD3B7F669EA0E6BFCC3B7F669EA0E63FD61D0925F34CE4BF4117156B80BCE83FC968AE393BC7E1BFA3A10E29669BEA3F3EF606385D2BDEBFB0BD80F1B238EC3F64A9AEA6E27DD8BF468D32CF6B90ED3F059FD52E0694D2BFDB2DC656419FEE3F0DA6693CB8F8C8BFB05CF7CF9762EF3F38B429BCA617B9BF2525D1A38DD8EF3F075C143326A691BC000000000000F03F2FB429BCA617B93F2625D1A38DD8EF3F08A6693CB8F8C83FB05CF7CF9762EF3F029FD52E0694D23FDB2DC656419FEE3F62A9AEA6E27DD83F468D32CF6B90ED3F3CF606385D2BDE3FB1BD80F1B238EC3FC668AE393BC7E13FA5A10E29669BEA3FD51D0925F34CE43F4217156B80BCE83FCC3B7F669EA0E63FCD3B7F669EA0E63F4117156B80BCE83FD61D0925F34CE43FA4A10E29669BEA3FC868AE393BC7E13FB0BD80F1B238EC3F3FF606385D2BDE3F468D32CF6B90ED3F65A9AEA6E27DD83FDA2DC656419FEE3F069FD52E0694D23FB05CF7CF9762EF3F17A6693CB8F8C83F2525D1A38DD8EF3F3CB429BCA617B93F000000000000F03F075C143326A6A13CFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100007,1,x'0001FFFFFFFF0000000000000000000000000000E8BF94189C010000E83F856B09000000E83F7C0300000001000000250000002B879E9C9999D93FB6F314FDFFFFE7BF299C4166ABCBDB3F5FF4189031F2E7BFB29B277353F8DD3FCE97D952E8C8E7BF6D4A7EAF1A0DE03F22DBF30E8A84E7BF4977AFAA0716E13F56C8D652BF25E7BF5C34F4836314E23FEB8533D271ADE6BF0D056321BB05E33F4DF4D025CA1CE6BF026F6D80BBE7E33FB95B4FF02C75E5BFB70BD37037B8E43F1AF8E66E37B8E4BF7AA755F22C75E53FEE1E997EBBE7E3BF2DACF327CA1CE63F50C9A31FBB05E3BFCF9774D471ADE63FC82947826314E2BF4ED73755BF25E73FDC8D11A90716E1BF623B76118A84E73FD44CECAD1A0DE0BF674B7E55E8C8E73FBBD2147053F8DDBFBFA8E09231F2E73F99353963ABCBDBBF000000000000E83F9A9999999999D9BF94189C010000E83F999999999999D93FBFCD8A9431F2E73FA46EAD63ABCBDB3F9CB93057E8C8E73F9E76FF7053F8DD3FE71A2B138A84E73F1F5B9DAE1A0DE03F384AE956BF25E73F294CFEA90716E13FA0C81CD671ADE63F99F86E836314E23F41DC8C29CA1CE63F84770521BB05E33F263DDAF32C75E53FBCEC3280BBE7E33F1BA03D7237B8E43F559BB67037B8E43F5DDBB881BBE7E33F7F0552F22C75E53F6E6F8A22BB05E33FEF570328CA1CE63F941BF3846314E23F10E191D471ADE63F11BE81AB0716E13F3DEC5C55BF25E73F7E4120B01A0DE03FF8369D118A84E73F177A047453F8DD3FEA43A155E8C8E73F92F8B166ABCBDB3F5CBEF99231F2E73FE8FB9D9C9999D93F856B09000000E83F0000000000000000000000000000E83F0000000000000000000000000000E8BF2B879E9C9999D93FB6F314FDFFFFE7BFFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100008,1,x'0001FFFFFFFF00000000000000C0000000000000E8BF0000000000000000000000000000E83F7C020000000300000000000000000000C0000000000000E83F0000000000000000000000000000000000000000000000C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100009,1,x'0001FFFFFFFF00000000000004C000000000000000000000000000000440000000000000F03F7C03000000010000000500000000000000000004C0000000000000F03F00000000000004C00000000000000000000000000000044000000000000000000000000000000440000000000000F03F00000000000004C0000000000000F03FFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100009,2,x'0001FFFFFFFF00000000000000C00000000000000000000000000000F0BF000000000000F03F7C020000000200000000000000000000C00000000000000000000000000000F0BF000000000000F03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100009,3,x'0001FFFFFFFF000000000000F0BF00000000000000000000000000000000000000000000F03F7C0200000002000000000000000000F0BF00000000000000000000000000000000000000000000F03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100009,4,x'0001FFFFFFFF00000000000000000000000000000000000000000000F03F000000000000F03F7C020000000200000000000000000000000000000000000000000000000000F03F000000000000F03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100009,5,x'0001FFFFFFFF000000000000F03F00000000000000000000000000000040000000000000F03F7C0200000002000000000000000000F03F00000000000000000000000000000040000000000000F03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100010,1,x'0001FFFFFFFF00000000000000000000000000000000000000000000000000000000000000007C0100000000000000000000000000000000000000FE',1,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100010,2,x'0001FFFFFFFF010000000000E0BF010000000000E0BF010000000000E03F010000000000E03F7C030000000100000031000000010000000000E03FFDA9F1D24D6220BDE168EC92EAB9DF3FB29A6D0F15B5B03F9FBF4847DDE8DE3F9C0293C17D90C03F118E32CF6B90DD3F9CA5AEA6E27DC83FB34D58E87AB6DB3F74FCFFFFFFFFCF3FD425578B2663D93F4A12953FF97AD33F413D7F669EA0D63F5A3A7F669EA0D63F8C15953FF97AD33F5423578B2663D93FC80100000000D03FA64B58E87AB6DB3F2FADAEA6E27DC83F7F8C32CF6B90DD3F8A0A93C17D90C03F8EBE4847DDE8DE3FF5AA6D0F15B5B03F5968EC92EAB9DF3F146F7E5CB766203D010000000000E03FAB9A6D0F15B5B0BFE268EC92EAB9DF3F960293C17D90C0BFA0BF4847DDE8DE3F9BA5AEA6E27DC8BF118E32CF6B90DD3F72FCFFFFFFFFCFBFB34D58E87AB6DB3F4812953FF97AD3BFD525578B2663D93F5A3A7F669EA0D6BF413D7F669EA0D63F5423578B2663D9BF8D15953FF97AD33FA54B58E87AB6DBBFCA0100000000D03F7F8C32CF6B90DDBF30ADAEA6E27DC83F8EBE4847DDE8DEBF8B0A93C17D90C03F5968EC92EAB9DFBFFFAA6D0F15B5B03F010000000000E0BF2B340BE6206B203DE268EC92EAB9DFBF999A6D0F15B5B0BFA0BF4847DDE8DEBF950293C17D90C0BF128E32CF6B90DDBF9AA5AEA6E27DC8BFB64D58E87AB6DBBF6BFCFFFFFFFFCFBFD525578B2663D9BF4812953FF97AD3BF423D7F669EA0D6BF5A3A7F669EA0D6BF8D15953FF97AD3BF5323578B2663D9BFCB0100000000D0BFA44B58E87AB6DBBF38ADAEA6E27DC8BF7D8C32CF6B90DDBF940A93C17D90C0BF8DBE4847DDE8DEBFF2AA6D0F15B5B0BF5968EC92EAB9DFBF42F9976F8A6F20BD010000000000E0BFA79A6D0F15B5B03FE268EC92EAB9DFBF940293C17D90C03FA0BF4847DDE8DEBFA0A5AEA6E27DC83F108E32CF6B90DDBF6AFCFFFFFFFFCF3FB64D58E87AB6DBBF4A12953FF97AD33FD325578B2663D9BF593A7F669EA0D63F423D7F669EA0D6BF5323578B2663D93F8D15953FF97AD3BFA44B58E87AB6DB3FCB0100000000D0BF7D8C32CF6B90DD3F39ADAEA6E27DC8BF8DBE4847DDE8DE3F950A93C17D90C0BF5968EC92EAB9DF3FF4AA6D0F15B5B0BF010000000000E03FFDA9F1D24D6220BDFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100011,1,x'0001FFFFFFFF686666666666D6BF686666666666D6BF686666666666D63F686666666666D63F7C030000000100000031000000686666666666D63F0000000000000000A1AFD8665735D63FBEB0CC48EA63A73FF7B87F4B01A3D53F3209010FB030B73F4CC90911E5B1D43F9376AD74EB24C13FDF68D7D52266D33F676666666666C63F3533F0C767C5D13FAFE80359C345CB3F54ED7E8FAAADCF3F53ED7E8FAAADCF3FB1E80359C345CB3F3433F0C767C5D13F696666666666C63FDF68D7D52266D33F9476AD74EB24C13F4CC90911E5B1D43F3709010FB030B73FF6B87F4B01A3D53FC5B0CC48EA63A73FA1AFD8665735D63FA54DE9AD68B5783C686666666666D63FB5B0CC48EA63A7BFA2AFD8665735D63F2909010FB030B7BFF7B87F4B01A3D53F9376AD74EB24C1BF4CC90911E5B1D43F656666666666C6BFDF68D7D52266D33FACE80359C345CBBF3633F0C767C5D13F53ED7E8FAAADCFBF54ED7E8FAAADCF3F3433F0C767C5D1BFB3E80359C345CB3FDE68D7D52266D3BF6C6666666666C63F4CC90911E5B1D4BF9576AD74EB24C13FF6B87F4B01A3D5BF3909010FB030B73FA1AFD8665735D6BFD3B0CC48EA63A73F686666666666D6BFA54DE9AD68B5883CA2AFD8665735D6BF9BB0CC48EA63A7BFF7B87F4B01A3D5BF2809010FB030B7BF4DC90911E5B1D4BF9276AD74EB24C1BFE268D7D52266D3BF606666666666C6BF3633F0C767C5D1BFACE80359C345CBBF56ED7E8FAAADCFBF53ED7E8FAAADCFBFB3E80359C345CBBF3333F0C767C5D1BF6E6666666666C6BFDD68D7D52266D3BF9A76AD74EB24C1BF4BC90911E5B1D4BF4509010FB030B7BFF5B87F4B01A3D5BFC1B0CC48EA63A7BFA1AFD8665735D6BF3CFA6E820E8892BC686666666666D6BFAFB0CC48EA63A73FA2AFD8665735D6BF2609010FB030B73FF7B87F4B01A3D5BF9676AD74EB24C13F4BC90911E5B1D4BF606666666666C63FE268D7D52266D3BFAFE80359C345CB3F3433F0C767C5D1BF52ED7E8FAAADCF3F56ED7E8FAAADCFBF3333F0C767C5D13FB3E80359C345CBBFDD68D7D52266D33F6E6666666666C6BF4BC90911E5B1D43F9B76AD74EB24C1BFF5B87F4B01A3D53F4709010FB030B7BFA1AFD8665735D63FC4B0CC48EA63A7BF686666666666D63F0000000000000000FE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100011,2,x'0001FFFFFFFF54E3A59BC420D0BF653BDF4F8D97CEBF653BDF4F8D97CE3F54E3A59BC420D03F7C020000000200000054E3A59BC420D0BF653BDF4F8D97CEBF653BDF4F8D97CE3F54E3A59BC420D03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100012,1,x'0001FFFFFFFF000000000000F8BF676666666666D6BF000000000000F83F676666666666D63F7C030000000100000005000000000000000000F8BF676666666666D63F000000000000F8BF676666666666D6BF000000000000F83F676666666666D6BF000000000000F83F676666666666D63F000000000000F8BF676666666666D63FFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100013,1,x'0001FFFFFFFF676666666666FABF40355EBA490CC23F0E2DB29DEFA7F4BF000000000000E03F7C0200000002000000676666666666FABF40355EBA490CC23F0E2DB29DEFA7F4BF000000000000E03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100013,2,x'0001FFFFFFFF676666666666FABF4C37894160E5D8BF273108AC1C5AE8BF000000000000E03F7C0200000002000000676666666666FABF4C37894160E5D8BF273108AC1C5AE8BF000000000000E03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100013,3,x'0001FFFFFFFFAE47E17A14AEF3BF000000000000E0BF713D0AD7A370CDBF000000000000E03F7C0200000002000000AE47E17A14AEF3BF000000000000E0BF713D0AD7A370CDBF000000000000E03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100013,4,x'0001FFFFFFFF676666666666E6BF000000000000E0BF333333333333D33F000000000000E03F7C0200000002000000676666666666E6BF000000000000E0BF333333333333D33F000000000000E03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100013,5,x'0001FFFFFFFFC3F5285C8FC2C5BF000000000000E0BF90C2F5285C8FEA3F000000000000E03F7C0200000002000000C3F5285C8FC2C5BF000000000000E0BF90C2F5285C8FEA3F000000000000E03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100013,6,x'0001FFFFFFFFB4C876BE9F1AD73F000000000000E0BF2DB29DEFA7C6F53F000000000000E03F7C0200000002000000B4C876BE9F1AD73F000000000000E0BF2DB29DEFA7C6F53F000000000000E03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100013,7,x'0001FFFFFFFF508D976E1283EC3F000000000000E0BF676666666666FA3FFA7E6ABC7493D03F7C0200000002000000508D976E1283EC3F000000000000E0BF676666666666FA3FFA7E6ABC7493D03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100013,8,x'0001FFFFFFFF23DBF97E6ABCF63F000000000000E0BF676666666666FA3FF2D24D621058D1BF7C020000000200000023DBF97E6ABCF63F000000000000E0BF676666666666FA3FF2D24D621058D1BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100013,9,x'0001FFFFFFFF676666666666FABF000000000000E0BF676666666666FA3F000000000000E03F7C030000000100000005000000676666666666FABF000000000000E03F676666666666FABF000000000000E0BF676666666666FA3F000000000000E0BF676666666666FA3F000000000000E03F676666666666FABF000000000000E03FFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100013,10,x'0001FFFFFFFF676666666666FABF0000000000000000676666666666FA3F00000000000000007C0200000002000000676666666666FABF0000000000000000676666666666FA3F0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100014,1,x'0001FFFFFFFF25068195438BDCBF46B6F3FDD478C9BFF2D24D621058C93F7B14AE47E17ADC3F7C020000000200000025068195438BDCBF46B6F3FDD478C9BFF2D24D621058C93F7B14AE47E17ADC3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100014,2,x'0001FFFFFFFFBF9F1A2FDD24C6BFC976BE9F1A2FDDBFC976BE9F1A2FDD3F6BBC74931804C63F7C0200000002000000BF9F1A2FDD24C6BFC976BE9F1A2FDDBFC976BE9F1A2FDD3F6BBC74931804C63FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100014,3,x'0001FFFFFFFF078195438B6CDFBF078195438B6CDFBF078195438B6CDF3F078195438B6CDF3F7C030000000100000031000000078195438B6CDF3F0000000000000000264E99C8B827DF3F63F5E2431868B03F7A34A8CC6E5ADE3F49EA91922944C03FE11059863008DD3F0F45F604070DC83F4820138BC736DB3F068195438B6CCF3F895360752AEED83F9E2B1E463521D33F563F5F035A38D63F553F5F035A38D63FA02B1E463521D33F875360752AEED83F098195438B6CCF3F4720138BC736DB3F1045F604070DC83FE11059863008DD3F4DEA91922944C03F7934A8CC6E5ADE3F68F5E2431868B03F264E99C8B827DF3F84606491D254813C078195438B6CDF3F5CF5E2431868B0BF274E99C8B827DF3F43EA91922944C0BF7B34A8CC6E5ADE3F0E45F604070DC8BFE11059863008DD3F038195438B6CCFBF4820138BC736DB3F9C2B1E463521D3BF8A5360752AEED83F553F5F035A38D6BF563F5F035A38D63F875360752AEED8BFA12B1E463521D33F4620138BC736DBBF0D8195438B6CCF3FE11059863008DDBF1145F604070DC83F7934A8CC6E5ADEBF4EEA91922944C03F264E99C8B827DFBF72F5E2431868B03F078195438B6CDFBF84606491D254913C274E99C8B827DFBF4BF5E2431868B0BF7B34A8CC6E5ADEBF42EA91922944C0BFE21059863008DDBF0D45F604070DC8BF4B20138BC736DBBFFC8095438B6CCFBF8A5360752AEED8BF9C2B1E463521D3BF573F5F035A38D6BF553F5F035A38D6BFA12B1E463521D3BF865360752AEED8BF0F8195438B6CCFBF4520138BC736DBBF1945F604070DC8BFDF1059863008DDBF57EA91922944C0BF7834A8CC6E5ADEBF65F5E2431868B0BF264E99C8B827DFBFC69016DA3BFF99BC078195438B6CDFBF58F5E2431868B03F274E99C8B827DFBF41EA91922944C03F7B34A8CC6E5ADEBF1345F604070DC83FE01059863008DDBFFB8095438B6CCF3F4B20138BC736DBBF9E2B1E463521D33F885360752AEED8BF543F5F035A38D63F573F5F035A38D6BF865360752AEED83FA12B1E463521D3BF4520138BC736DB3F0F8195438B6CCFBFDF1059863008DD3F1A45F604070DC8BF7834A8CC6E5ADE3F58EA91922944C0BF264E99C8B827DF3F67F5E2431868B0BF078195438B6CDF3F0000000000000000FE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100015,1,x'0001FFFFFFFF0000000000000000000000000000F0BF0000000000000000000000000000F03F7C02000000020000000000000000000000000000000000F03F0000000000000000000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100016,1,x'0001FFFFFFFFF90000000000F0BF000000000000F0BF0000000000000000000000000000F03F7C0200000021000000000000000000F0BF000000000000F03F6BC97A280BDDECBF2425D1A38DD8EF3F5F96E5F0D1C1E9BFAA5CF7CF9762EF3F503095E8FCB5E6BFCD2DC656419FEE3F15ABA8AC0EC1E3BF2E8D32CF6B90ED3F9E84FC6351EAE0BF8CBD80F1B238EC3FD42DA38C8971DCBF6FA10E29669BEA3FACC3EDB51966D7BFFC16156B80BCE83FB6870133C3BED2BF743B7F669EA0E63F98A1AB53FE0DCDBF691D0925F34CE43F1C78C55B6792C5BF4768AE393BC7E13FF80FFA73683ABEBF0EF506385D2BDE3F90936B86A17CB3BF08A8AEA6E27DD83FB01E9D93EA0BA6BF829DD52E0694D23FA064140106AD93BFB5A2693CB8F8C83F80616D172EB973BFE1AC29BCA617B93F0000000000000000A4EBCCD9592E1FBD007A6D172EB973BF65BC29BCA617B9BFE070140106AD93BF5BAA693CB8F8C8BFC0279D93EA0BA6BF3DA1D52E0694D2BF88996B86A17CB3BFA2ABAEA6E27DD8BF5017FA73683ABEBF7EF806385D2BDEBF6C7CC55B6792C5BFE469AE393BC7E1BF8CA6AB53FE0DCDBFEB1E0925F34CE4BF7A8A0133C3BED2BFD63C7F669EA0E6BFACC6EDB51966D7BF3718156B80BCE8BF1031A38C8971DCBF84A20E29669BEABF5686FC6351EAE0BF78BE80F1B238ECBFE0ACA8AC0EC1E3BFED8D32CF6B90EDBF2E3295E8FCB5E6BF5E2EC656419FEEBF4998E5F0D1C1E9BF0C5DF7CF9762EFBF5ACB7A280BDDECBF5525D1A38DD8EFBFF90000000000F0BF000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100017,1,x'0001FFFFFFFFB0726891ED7CE3BFDBF97E6ABC74E3BF0000000000000000333333333333E33F7C0200000003000000333333333333E3BF333333333333E33F00000000000000000000000000000000B0726891ED7CE3BFDBF97E6ABC74E3BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100018,1,x'0001FFFFFFFF000000000000F0BF000000000000F0BF0000000000000000000000000000F03F7C0200000003000000000000000000F0BF000000000000F03F00000000000000000000000000000000000000000000F0BF000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100019,1,x'0001FFFFFFFF000000000000F0BF000000000000F0BF0000000000000000000000000000F03F7C0200000004000000000000000000F0BF000000000000F03F0000000000000000000000000000F03F0000000000000000000000000000F0BF000000000000F0BF000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100020,1,x'0001FFFFFFFF0000000000000000676666666666E6BF0000000000000000676666666666E63F7C02000000020000000000000000000000676666666666E63F0000000000000000676666666666E6BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100021,1,x'0001FFFFFFFF000000000000E0BF0000000000000000000000000000E0BF676666666666E63F7C0200000002000000000000000000E0BF676666666666E63F000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100021,2,x'0001FFFFFFFF000000000000E03F0000000000000000000000000000E03F676666666666E63F7C0200000002000000000000000000E03F676666666666E63F000000000000E03F0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100022,1,x'0001FFFFFFFF000000000000E0BF676666666666E6BF000000000000E0BF00000000000000007C0200000002000000000000000000E0BF676666666666E6BF000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100022,2,x'0001FFFFFFFF000000000000E03F676666666666E6BF000000000000E03F00000000000000007C0200000002000000000000000000E03F676666666666E6BF000000000000E03F0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100023,1,x'0001FFFFFFFF10521DE96466E6BFFFB4C8EE495660BF746866666666E63F5C5925BD0F56E63F7C0200000021000000746866666666E63FFFB4C8EE495660BF4257A5F3CF4AE63FD1C9EABBD30BB13F55A8828F50F8E53FCDC7E0768D37C13F0202FE6EB36FE53F9A810A7927BEC93FBAC06C1349B2E43FBC256BDE5B02D13FE3F1990DE4C1E33FAE6BC0EB6DFBD43FA0618980D4A0E23F5D7E87A880C0D83F2285EC6EE251E13FA9D902ED4A48DC3F43D7A3C28DB0DF3F077415851A8ADF3FB25DDEEB476FDC3FA259E8CDF43EE13F663426DBF7E7D83FC273363F398EE23F59A796974E23D53F078EFFC2A0AFE33F61322045942AD13F3964E67D62A0E43F180E508F220FCA3FEC2A8C682D5EE53F1BAF8054EC88C13F81204E042EE7E53FFB0751170AAFB13F3959CCDA123AE63F0F4248344A56403F5C5925BD0F56E63F5AED046A016EB1BF7702E7BADF3AE63F99030354E068C1BF0CFDDDCBC5E8E53F6153F7D4DDEFC9BF9A58212B8C60E53F15E8970D7C1BD1BF50B2F06482A3E43FA9DFFBB3E514D5BF84E02F1C7AB3E33F07E3E4C961DAD8BF7400748FC292E23F776D1724A662DCBF820CABE82244E13FA0BABE61FFA4DFBF0676C2CAA695DF3F6ABA6F2DB34CE1BFD7F6FDD0EA54DC3F32AA49F3499CE2BF63F2101215CED83F9E3B2C6409BEE3BF34FECA67D509D53F7A0E26CC27AFE4BFEC8E00F27211D13F330F913F536DE5BFC86156786ADDC93FC1520252B7F6E5BF39D16D4D9857C13F25961A98014AE6BF89D4493DDB4CB13F10521DE96466E6BF498DCEEE495650BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100024,1,x'0001FFFFFFFF676666666666E6BF676666666666E6BF676666666666E63F00000000000000007C0200000003000000676666666666E6BF676666666666E6BF00000000000000000000000000000000676666666666E63F676666666666E6BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100025,1,x'0001FFFFFFFF0000000000000000676666666666E6BF000000000000000000000000000000007C0200000002000000000000000000000000000000000000000000000000000000676666666666E6BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100026,1,x'0001FFFFFFFF746866666666E6BF102214076666E6BF10521DE96466E63F00000000000000007C0200000021000000746866666666E6BF00000000000000004257A5F3CF4AE6BF790F610B868EB1BF55A8828F50F8E5BFA1EA9B9EE678C1BF0202FE6EB36FE5BF6EA4C5A080FFC9BFBAC06C1349B2E4BF26B748720823D1BFE3F1990DE4C1E3BF18FD9D7F1A1CD5BFA0618980D4A0E2BFC70F653C2DE1D8BF2285EC6EE251E1BF136BE080F768DCBF42D7A3C28DB0DFBF7105F318C7AADFBFB15DDEEB476FDCBF5722D7174B4FE1BF653426DBF7E7D8BF773C25898F9EE2BF58A796974E23D5BFBC56EE0CF7BFE3BF60322045942AD1BFEE2CD5C7B8B0E4BF150E508F220FCABFA0F37AB2836EE5BF18AF8054EC88C1BF35E93C4E84F7E5BFF50751170AAFB1BFED21BB24694AE6BFF83E48344A5640BF102214076666E6BF60ED046A016EB13F2BCBD504364BE6BF9C030354E068C13FC0C5CC151CF9E5BF6453F7D4DDEFC93F4E211075E270E5BF16E8970D7C1BD13F047BDFAED8B3E4BFAADFFBB3E514D53F38A91E66D0C3E3BF08E3E4C961DAD83F28C962D918A3E2BF786D1724A662DC3F36D599327954E1BFA1BABE61FFA4DF3F6D07A05E53B6DFBF6ABA6F2DB34CE13F3E88DB649775DCBF32AA49F3499CE23FCA83EEA5C1EED8BF9E3B2C6409BEE33F9B8FA8FB812AD5BF7A0E26CC27AFE43F5320DE851F32D1BF330F913F536DE53F968411A0C31ECABFC1520252B7F6E53F07F42875F198C1BF25961A98014AE63F251AC08C8DCFB1BF10521DE96466E63F9DD9C2EE495650BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100027,1,x'0001FFFFFFFF676666666666E6BF0000000000000000676666666666E63F676666666666E63F7C0200000003000000676666666666E6BF676666666666E63F00000000000000000000000000000000676666666666E63F676666666666E63FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100028,1,x'0001FFFFFFFF0000000000000CC0000000000000F0BF0000000000000C4000000000000000007C02000000060000000000000000000CC00000000000000000000000000000F8BF0000000000000000000000000000F8BF000000000000F0BF000000000000F83F000000000000F0BF000000000000F83F00000000000000000000000000000C400000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100028,2,x'0001FFFFFFFF000000000000E83F000000000000F0BF000000000000E83F00000000000000007C0200000002000000000000000000E83F0000000000000000000000000000E83F000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100028,3,x'0001FFFFFFFF000000000000E8BF000000000000F0BF000000000000E8BF00000000000000007C0200000002000000000000000000E8BF0000000000000000000000000000E8BF000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100029,1,x'0001FFFFFFFF0000000000000CC0000000000000F0BF0000000000000C4000000000000000007C02000000060000000000000000000CC00000000000000000000000000000F8BF0000000000000000000000000000F8BF000000000000F0BF000000000000F83F000000000000F0BF000000000000F83F00000000000000000000000000000C400000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100029,2,x'0001FFFFFFFF000000000000E83F000000000000F0BF000000000000E83F00000000000000007C0200000002000000000000000000E83F0000000000000000000000000000E83F000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100029,3,x'0001FFFFFFFF000000000000E8BF000000000000F0BF000000000000E8BF00000000000000007C0200000002000000000000000000E8BF0000000000000000000000000000E8BF000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100029,4,x'0001FFFFFFFF0000000000000000000000000000F0BF000000000000000000000000000000007C0200000002000000000000000000000000000000000000000000000000000000000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100030,1,x'0001FFFFFFFF0000000000000CC0000000000000F0BF0000000000000C4000000000000000007C02000000060000000000000000000CC00000000000000000000000000000F8BF0000000000000000000000000000F8BF000000000000F0BF000000000000F83F000000000000F0BF000000000000F83F00000000000000000000000000000C400000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100030,2,x'0001FFFFFFFFCDCCCCCCCCCCECBF000000000000F0BFCDCCCCCCCCCCECBF00000000000000007C0200000002000000CDCCCCCCCCCCECBF0000000000000000CDCCCCCCCCCCECBF000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100030,3,x'0001FFFFFFFF333333333333D3BF000000000000F0BF333333333333D3BF00000000000000007C0200000002000000333333333333D3BF0000000000000000333333333333D3BF000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100030,4,x'0001FFFFFFFF333333333333D33F000000000000F0BF333333333333D33F00000000000000007C0200000002000000333333333333D33F0000000000000000333333333333D33F000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100030,5,x'0001FFFFFFFFCDCCCCCCCCCCEC3F000000000000F0BFCDCCCCCCCCCCEC3F00000000000000007C0200000002000000CDCCCCCCCCCCEC3F0000000000000000CDCCCCCCCCCCEC3F000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100031,1,x'0001FFFFFFFF000000000000F8BF0000000000000000000000000000F83F000000000000F83F7C0200000021000000000000000000F8BF0000000000000000DCDBDC3A6AE2F7BF21471F0DBDD1C23F8485F9DBF189F7BF883C4F2D8ABAD23F64A2140171F7F6BF886E404609DEDB3FF4E965DB502CF6BF0AFF02FD695EE23F458E2035862AF5BFAC3805EA85A0E63F3AF9CA9E8CF4F3BF2C9D85D6D8AAEA3F71D14F50608DF2BFC1AC8DB76C73EE3FDA6CDFCC76F8F0BFD96CDFCC76F8F03FC1AC8DB76C73EEBF71D14F50608DF23F2E9D85D6D8AAEABF3AF9CA9E8CF4F33FAE3805EA85A0E6BF448E2035862AF53F0BFF02FD695EE2BFF4E965DB502CF63F886E404609DEDBBF64A2140171F7F63F8A3C4F2D8ABAD2BF8485F9DBF189F73F2A471F0DBDD1C2BFDCDBDC3A6AE2F73F0A8A9E4C39799ABC000000000000F83F23471F0DBDD1C23FDCDBDC3A6AE2F73F863C4F2D8ABAD23F8485F9DBF189F73F836E404609DEDB3F64A2140171F7F63F0AFF02FD695EE23FF4E965DB502CF63FAD3805EA85A0E63F458E2035862AF53F299D85D6D8AAEA3F3CF9CA9E8CF4F33FC0AC8DB76C73EE3F72D14F50608DF23FD96CDFCC76F8F03FDA6CDFCC76F8F03F71D14F50608DF23FC1AC8DB76C73EE3F3BF9CA9E8CF4F33F2C9D85D6D8AAEA3F448E2035862AF53FAF3805EA85A0E63FF4E965DB502CF63F0CFF02FD695EE23F64A2140171F7F63F896E404609DEDB3F8485F9DBF189F73F913C4F2D8ABAD23FDCDBDC3A6AE2F73F2D471F0DBDD1C23F000000000000F83F0A8A9E4C3979AA3CFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100032,1,x'0001FFFFFFFF0000000000000CC0000000000000F0BF0000000000000C4000000000000000007C02000000060000000000000000000CC00000000000000000000000000000F8BF0000000000000000000000000000F8BF000000000000F0BF000000000000F83F000000000000F0BF000000000000F83F00000000000000000000000000000C400000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100033,1,x'0001FFFFFFFF0000000000000CC0000000000000F0BF0000000000000C4000000000000000007C02000000060000000000000000000CC00000000000000000000000000000F8BF0000000000000000000000000000F8BF000000000000F0BF000000000000F83F000000000000F0BF000000000000F83F00000000000000000000000000000C400000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100033,2,x'0001FFFFFFFF0000000000000000000000000000F0BF000000000000000000000000000000007C02000000020000000000000000000000000000000000F0BF00000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100034,1,x'0001FFFFFFFF804D50989999A9BF64997FBB2A16E8BFCE0CD93153CCD73F00000000007C303D7C02000000210000000000000080DF0A3D00000000007C303D637460797C89A33F8493DD30128063BFBB57D2C2C26CB33FA7F00C410BA781BF5ACDD9848CDEBC3FE2BF725EAA1993BFA3DA14D89400C33F822351E7A693A0BF14359BC73C5EC73FA1C671F5A86BA9BFCD39AC21B67CCB3FDD572AD8BFFEB1BF907C00D71F51CF3F36E1F33CA016B8BFA4CD1B3AAE68D13FFF856ABD5DEDBEBF90A7876C16FAD23FEA815C297438C3BF749A3352A458D43F5DA4E3C7B346C7BF334A480ABA80D53FF99EC885B796CBBF6C591191496FD63FDA259FBD8D0ED0BF290E6FD1DC21D73F42CE4E11F666D2BF943A00259C96D73F521694F462CED4BFCE0CD93153CCD73F4AB5DEF37A3ED7BF1C9DEC1874C2D73F23F78AB6CDB0D9BF2537C2EC1879D73F5C957700E51EDCBFF2B1986C03F1D63FF21E29C35582DEBF33B7AD049B2BD63F8E9EB388686AE0BFC286F018E92AD53F690E47641A88E1BF3A7EEBA393F1D33FEC3FC9E14D97E2BFC0881938D682D23FC5B677B63695E3BFC2F1207679E2D03FC6F82E43367FE4BFB63F011D9229CE3FE9B4A67FE252E5BFB67029D2103DCA3FEF09C85A0C0EE6BF9BE1D320CC09C63F239F467FC5AEE6BF18E63304DC9AC13FD397406D6533E7BF45545A21ECF7B93F71FC6CDB8D9AE7BFE425560D9D72B03F4C5A47542EE3E7BFDCE83DB7C0FB9A3F710EAD05870CE8BFE27AB12BD54B88BF64997FBB2A16E8BF804D50989999A9BF8ADE11000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100035,1,x'0001FFFFFFFF9A99999999990DC0000000000000F83F6766666666660A40000000000000F83F7C02000000020000009A99999999990DC0000000000000F83F6766666666660A40000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100035,2,x'0001FFFFFFFF9A99999999990DC0000000000000F8BF6766666666660A40000000000000F8BF7C02000000020000009A99999999990DC0000000000000F8BF6766666666660A40000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100036,1,x'0001FFFFFFFF9A99999999990DC0000000000000F83F6766666666660A40000000000000F83F7C02000000020000009A99999999990DC0000000000000F83F6766666666660A40000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100036,2,x'0001FFFFFFFF9A99999999990DC0000000000000F03F6766666666660A40000000000000F03F7C02000000020000009A99999999990DC0000000000000F03F6766666666660A40000000000000F03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100036,3,x'0001FFFFFFFF9A99999999990DC0000000000000F0BF6766666666660A40000000000000F0BF7C02000000020000009A99999999990DC0000000000000F0BF6766666666660A40000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100036,4,x'0001FFFFFFFF9A99999999990DC0000000000000F8BF6766666666660A40000000000000F8BF7C02000000020000009A99999999990DC0000000000000F8BF6766666666660A40000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100037,1,x'0001FFFFFFFF0000000000000CC0000000000000E8BF0000000000000C40000000000000E83F7C0300000001000000050000000000000000000CC0000000000000E83F0000000000000CC0000000000000E8BF0000000000000C40000000000000E8BF0000000000000C40000000000000E83F0000000000000CC0000000000000E83FFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100038,1,x'0001FFFFFFFF000000000000E8BF91ED2071E20DE8BF000000000000E83F6F12DF8E1DF2E73F7C030000000100000031000000000000000000E83FD122DB41E2C45BBF744E31EE6FCBE73FAD071D0E8CA0B83F508F76F5A52EE73F92D3D8DD32A1C83FF4E965DB502CE63FE723C11AA542D23F8039422EDCC8E43FDC24BE1D3BE4D73F6E5B81E85C0AE33FBBC21DFDB01CDD3FDA6CDFCC76F8E03F487FBE5B94EAE03FE09D5FDF7538DD3FDC6D60777AFCE23F020000000000D83FEF4B21BDF9BAE43F0BFF02FD695ED23F63FC446A6E1EE63FDE895CA2BCD8C83FBEA15584C320E73F407424979F0FB93FE360107D8DBDE73F0A8A9E4C39798A3C6F12DF8E1DF2E73F2E7424979F0FB9BFE460107D8DBDE73FCF895CA2BCD8C8BFBFA15584C320E73F0AFF02FD695ED2BF63FC446A6E1EE63FFDFFFFFFFFFFD7BFEF4B21BDF9BAE43FDA9D5FDF7538DDBFDE6D60777AFCE23FD96CDFCC76F8E0BF497FBE5B94EAE03F6D5B81E85C0AE3BFBFC21DFDB01CDD3F7F39422EDCC8E4BFE124BE1D3BE4D73FF4E965DB502CE6BFE923C11AA542D23F4F8F76F5A52EE7BF9AD3D8DD32A1C83F744E31EE6FCBE7BFC3071D0E8CA0B83F000000000000E8BF2921DB41E2C45BBF754E31EE6FCBE7BF9DE02B20B37EB9BF508F76F5A52EE7BF1440E0664610C9BFF5E965DB502CE6BF2CDA44DF2E7AD2BF8239422EDCC8E4BF1BDB41E2C41BD8BF6F5B81E85C0AE3BFFD78A1C13A54DDBFDA6CDFCC76F8E0BF6A5A003E5906E1BFE29D5FDF7538DDBFFD48A2593F18E3BF060000000000D8BF0F27639FBED6E4BF12FF02FD695ED2BF84D7864C333AE6BFED895CA2BCD8C8BFDF7C9766883CE7BF3B7424979F0FB9BF053C525F52D9E7BF88E776F9EADAA3BC91ED2071E20DE8BF287424979F0FB93F063C525F52D9E7BFCC895CA2BCD8C83FE17C9766883CE7BF0DFF02FD695ED23F85D7864C333AE6BFF7FFFFFFFFFFD73F1327639FBED6E4BFDE9D5FDF7538DD3FFF48A2593F18E3BFD86CDFCC76F8E03F6B5A003E5906E1BF6C5B81E85C0AE33F0579A1C13A54DDBF7E39422EDCC8E43F29DB41E2C41BD8BFF3E965DB502CE63F35DA44DF2E7AD2BF4E8F76F5A52EE73F3440E0664610C9BF744E31EE6FCBE73FC9E02B20B37EB9BF000000000000E83FD122DB41E2C45BBFFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100039,1,x'0001FFFFFFFF23DBBF4F8D85E8BF9418B0726891E7BFAE4755D9CE1BD03FB4C820B07268F03F7C020000000200000023DBBF4F8D85E8BF9418B0726891E7BFAE4755D9CE1BD03FB4C820B07268F03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100039,2,x'0001FFFFFFFFF2D2D90356EAD0BFEE7C95438B6CF0BF81957DBA491EE83F21B0C64B3789E73F7C0200000002000000F2D2D90356EAD0BFEE7C95438B6CF0BF81957DBA491EE83F21B0C64B3789E73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100039,3,x'0001FFFFFFFF941834DC2476B0BFF85337894160E33FAE4755D9CE1BD03FB4C820B07268F03F7C0200000003000000941834DC2476B0BF77BEF3FDD478E73FAE4755D9CE1BD03FB4C820B07268F03F33331BF0A70EC43FF85337894160E33FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100039,4,x'0001FFFFFFFF2FDD98643B03DC3F60E578E92631D43F81957DBA491EE83F21B0C64B3789E73F7C02000000030000002FDD98643B03DC3F5EBAF1D24D62DC3F81957DBA491EE83F21B0C64B3789E73F77BED9490C14E53F60E578E92631D43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100039,5,x'0001FFFFFFFF8A9150E5D019F8BF8A9150E5D019F8BF8A9150E5D019F83F8A9150E5D019F83F7C0300000001000000310000008A9150E5D019F83F0000000000000000E829434908E5F73FE73692A9942AC93FC2D174A99547F73F0D45A5AA76F3D83F427F38AE2A44F63F01FBD8372C72E23F864AFEA637DFF43F899150E5D019E83F66380619D81EF33FCD58AD5AE457ED3F7E80CBFEB70AF13F7E80CBFEB70AF13FD058AD5AE457ED3F64380619D81EF33F8C9150E5D019E83F864AFEA637DFF43F02FBD8372C72E23F427F38AE2A44F63F1345A5AA76F3D83FC1D174A99547F73FEE3692A9942AC93FE829434908E5F73FE7D33155B3959A3C8A9150E5D019F83FDC3692A9942AC9BFE829434908E5F73F0445A5AA76F3D8BFC2D174A99547F73F01FBD8372C72E2BF427F38AE2A44F63F879150E5D019E8BF864AFEA637DFF43FCA58AD5AE457EDBF66380619D81EF33F7E80CBFEB70AF1BF7E80CBFEB70AF13F64380619D81EF3BFD258AD5AE457ED3F854AFEA637DFF4BF8F9150E5D019E83F427F38AE2A44F6BF03FBD8372C72E23FC1D174A99547F7BF1545A5AA76F3D83FE829434908E5F7BFFE3692A9942AC93F8A9150E5D019F8BFE7D33155B395AA3CE829434908E5F7BFC13692A9942AC9BFC2D174A99547F7BF0345A5AA76F3D8BF427F38AE2A44F6BF00FBD8372C72E2BF894AFEA637DFF4BF829150E5D019E8BF66380619D81EF3BFCA58AD5AE457EDBF7F80CBFEB70AF1BF7E80CBFEB70AF1BFD258AD5AE457EDBF63380619D81EF3BF909150E5D019E8BF844AFEA637DFF4BF09FBD8372C72E2BF407F38AE2A44F6BF2245A5AA76F3D8BFC0D174A99547F7BFEA3692A9942AC9BFE829434908E5F7BFED5EE57F46F0B3BC8A9150E5D019F8BFD63692A9942AC93FE829434908E5F7BF0145A5AA76F3D83FC2D174A99547F7BF04FBD8372C72E23F417F38AE2A44F6BF819150E5D019E83F894AFEA637DFF4BFCD58AD5AE457ED3F65380619D81EF3BF7D80CBFEB70AF13F7F80CBFEB70AF1BF63380619D81EF33FD258AD5AE457EDBF844AFEA637DFF43F909150E5D019E8BF407F38AE2A44F63F0AFBD8372C72E2BFC0D174A99547F73F2445A5AA76F3D8BFE829434908E5F73FED3692A9942AC9BF8A9150E5D019F83F0000000000000000FE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100040,1,x'0001FFFFFFFF546A33D0CCCC08C01081B4619A99B9BF0000000000A843BD9CD1A73777EBDF3F7C0200000011000000546A33D0CCCC08C01081B4619A99B9BF00995339667C07C0D070077A01EC9E3FB16EB8688F1606C01E273EAA12AFC23F681BE5D7DE9D04C0508592227B8CCF3F99EA5EE60D1503C076BCB438F42ED53F56B99DCEF37E01C030F235BFA987D93F5EC46DC700BDFFBF2054D22952C8DC3F4B39FE426D6DFCBFDC0B6FF4E7EADE3F0A3668324E15F9BF9CD1A73777EBDF3FC6B7008AD4BAF5BFC47E2AFA24C8DF3FDC65B4993564F2BFF02D0BA03281DE3F4EA4681D3F2FEEBFB4FDB471FD18DC3FD62DB1045CB6E7BFB494573BFA93D83F5A1ACF56BD69E1BFA0F0EB0CADF8D33F3CA6C21A19AAD6BFD8E72C543A9FCC3F38051D5C2E0EC6BF4028ED00158DBE3F0000000000A843BD0000000000E0343DFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100040,2,x'0001FFFFFFFF000000000080363DE0F40E5177EBDFBFE67648D4CCCC0840F0B1BBFE9999B93F7C0200000011000000000000000080363D00000000006A603D36A5795C2E0EC63F0E32DA11158DBEBF83E9961B19AAD63FD0C9A9643A9FCCBF704FC357BD69E13FD231E918ADF8D3BFFA4461065CB6E73F3759C44AFA93D8BF2F9D00203F2FEE3F505B3884FD18DCBF3033879B3564F23F5E0644B53281DEBFD4E7698CD4BAF53F9CFCB01125C8DFBF98E873354E15F93FE0F40E5177EBDFBFDA02B5466D6DFC3FCC41460FE8EADEBFF99FD4CB00BDFF3FD015A74552C8DCBF5CDF29D1F37E0140546595DBA987D9BF9EAD42E90D1503403C522D55F42ED5BF259F1DDBDE9D0440409FD85A7B8CCFBF8024416C8F16064070B904E112AFC2BFB053263D667C074080FAFA1D03EC9EBFE67648D4CCCC0840F0B1BBFE9999B93FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100041,1,x'0001FFFFFFFF000000000000F8BF0000000000000040000000000000F83F00000000000000407C0200000002000000000000000000F8BF0000000000000040000000000000F83F0000000000000040FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100041,2,x'0001FFFFFFFF000000000000F8BF00000000000000C0000000000000F83F00000000000000C07C0200000002000000000000000000F8BF00000000000000C0000000000000F83F00000000000000C0FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100042,1,x'0001FFFFFFFF00000000000008C000000000000000000000000000000840000000000000F03F7C020000000500000000000000000008C0000000000000000000000000000000C0000000000000000000000000000000C0000000000000F03F0000000000000000000000000000000000000000000008400000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100043,1,x'0001FFFFFFFF000000000000F0BF000000000000E8BF0000000000000000000000000000E83F7C0200000003000000000000000000F0BF000000000000E83F00000000000000000000000000000000000000000000F0BF000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100044,1,x'0001FFFFFFFF00000000000008C000000000000000000000000000000840000000000000F03F7C020000000500000000000000000008C0000000000000000000000000000000C0000000000000000000000000000000C0000000000000F03F0000000000000000000000000000000000000000000008400000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100045,1,x'0001FFFFFFFF0000000000000CC000000000000000000000000000000C4000000000000000007C02000000020000000000000000000CC000000000000000000000000000000C400000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100045,2,x'0001FFFFFFFF00000000000004C0000000000000F0BF0000000000000440000000000000F0BF7C020000000200000000000000000004C0000000000000F0BF0000000000000440000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100045,3,x'0001FFFFFFFF000000000000F0BF00000000000000C0000000000000F03F00000000000000C07C0200000002000000000000000000F0BF00000000000000C0000000000000F03F00000000000000C0FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100046,1,x'0001FFFFFFFF3A0D4F3453CCD7BF000000003ED9623D8E8740849999A93F338483BB2A16E83F7C02000000210000008E8740849999A93F689515000000E83F5098F0D8D44B883F338483BB2A16E83F403FDDE1C0FB9ABFC023AF05870CE83FFFBA4A189D72B0BF209745542EE3E73F9240962CECF7B9BFF76E65DB8D9AE73F96A7F109DC9AC1BFC769316D6533E73F4572AC26CC09C6BFD61F2E7FC5AEE63FC1CD16D8103DCABFB8B7A45A0C0EE63FBE79FC229229CEBFDB45777FE252E53F609E217979E2D0BF9862F242367FE43FF50F193BD682D2BFB1352DB63695E33FB167E5A693F1D3BF755C70E14D97E23F022BE01BE92AD5BFFBA1DF631A88E13FEA548E079B2BD6BFCED63D88686AE03F2084656F03F1D6BF80E021C25582DE3FB88B76EF1879D7BF3C5D56FFE41EDC3FACEB831B74C2D7BF892652B5CDB0D93F3A0D4F3453CCD7BFDB5491F27A3ED73F07FB50279C96D7BFDECE35F362CED43F430897D3DC21D7BFB4DEE30FF666D23F38860D93496FD6BF8A562CBC8D0ED03F9C34160CBA80D5BF0FC6DD82B796CB3FE26FD153A458D4BFF4E7FEC4B346C73F7646F46D16FAD2BF3EE389267438C33FA9D1563BAE68D1BFC78502B85DEDBE3FE61314D91F51CFBF1EC3E237A016B83FE2C05F23B67CCBBF43038AD3BFFEB13FD5AFF2C83C5EC7BFA63A46EDA86BA93F44F215D99400C3BF562C6DE0A693A03FD3CA3D868CDEBCBF06259B53AA19933FFEE4A9C3C26CB3BFA6EFF5310BA7813F8248207A7C89A3BF72D288111280633F0000000000E4253D000000003ED9623DFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100046,2,x'0001FFFFFFFF171960AC9999A9BF4EC77BBB2A16E8BFAC0E632F53CCD73F00000000005026BD7C020000002100000000000000C0A811BD00000000005026BD4B77A0787C89A33F04554A50128063BFE3B7FAC1C26CB33FAFDC29500BA781BF5FBF75838CDEBC3F37474D69AA1993BFE7BB13D79400C33F108D36EEA693A0BF68B443C63C5EC73FCEC19EFDA86BA9BF06AEF81FB67CCB3FDA62CBDCBFFEB1BFCEE1ECD41F51CF3FD8B40542A016B8BF85C8E038AE68D13F413BD3C25DEDBEBF2C081B6B16FAD23F047B2F2C7438C3BF1BC59550A458D43F44BBC8CAB346C7BF6D607A08BA80D53FA0D2B388B796CBBFC12D158F496FD63FB62212BF8D0ED0BFA41547CFDC21D73F9BEBB912F666D2BF197CAF229C96D73FDA8BF2F562CED4BFAC0E632F53CCD73F22442CF57A3ED7BF1851551674C2D73F82F6C3B7CDB0D9BF50E50DEA1879D73FA1FC9801E51EDCBF9EE2CB6903F1D63FEB8C30C45582DEBF611CCD019B2BD63F437E2989686AE0BF64E50016E92AD53FFD92AE641A88E1BF8997F1A093F1D33FB73B22E24D97E2BF28041A35D682D23F5850C2B63695E3BF8D47207379E2D03F95A76B43367FE4BFF70906179229CE3FB73CD67FE252E5BF53173CCC103DCA3F0275EB5A0C0EE6BFF153FB1ACC09C63F5B375F7FC5AEE6BFE22676FEDB9AC13FD1DE4F6D6533E7BFF56A1E16ECF7B93FDEA274DB8D9AE7BF499261029D72B03F5F3649542EE3E7BF31929E8CC0FB9A3FF811AB05870CE8BFE068727ED54B88BF4EC77BBB2A16E8BF171960AC9999A9BF42400E000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,1,x'0001FFFFFFFF00000000000008C000000000000008C0000000000000084000000000000008407C03000000010000003100000000000000000008400000000000000000744E31EE6FCB0740387424979F0FD93F508F76F5A52E0740D8895CA2BCD8E83FF4E965DB502C06400AFF02FD695EF23F8039422EDCC80440FFFFFFFFFFFFF73F6E5B81E85C0A0340DE9D5FDF7538FD3FDA6CDFCC76F80040D96CDFCC76F80040E09D5FDF7538FD3F6D5B81E85C0A0340020000000000F83F8039422EDCC804400BFF02FD695EF23FF4E965DB502C0640DE895CA2BCD8E83F4F8F76F5A52E0740407424979F0FD93F744E31EE6FCB07400A8A9E4C3979AA3C00000000000008402E7424979F0FD9BF754E31EE6FCB0740CF895CA2BCD8E8BF508F76F5A52E07400AFF02FD695EF2BFF4E965DB502C0640FDFFFFFFFFFFF7BF8039422EDCC80440DA9D5FDF7538FDBF6F5B81E85C0A0340D96CDFCC76F800C0DA6CDFCC76F800406D5B81E85C0A03C0E29D5FDF7538FD3F7F39422EDCC804C0040000000000F83FF4E965DB502C06C00CFF02FD695EF23F4F8F76F5A52E07C0E0895CA2BCD8E83F744E31EE6FCB07C04E7424979F0FD93F00000000000008C00A8A9E4C3979BA3C754E31EE6FCB07C0127424979F0FD9BF508F76F5A52E07C0CE895CA2BCD8E8BFF5E965DB502C06C009FF02FD695EF2BF8239422EDCC804C0F8FFFFFFFFFFF7BF6F5B81E85C0A03C0DA9D5FDF7538FDBFDA6CDFCC76F800C0D96CDFCC76F800C0E29D5FDF7538FDBF6C5B81E85C0A03C0060000000000F8BF7E39422EDCC804C012FF02FD695EF2BFF3E965DB502C06C0ED895CA2BCD8E8BF4E8F76F5A52E07C03B7424979F0FD9BF744E31EE6FCB07C088E776F9EADAC3BC00000000000008C0287424979F0FD93F754E31EE6FCB07C0CC895CA2BCD8E83F508F76F5A52E07C00DFF02FD695EF23FF4E965DB502C06C0F7FFFFFFFFFFF73F8239422EDCC804C0DE9D5FDF7538FD3F6E5B81E85C0A03C0D86CDFCC76F80040DA6CDFCC76F800C06C5B81E85C0A0340E29D5FDF7538FDBF7E39422EDCC80440060000000000F8BFF3E965DB502C064012FF02FD695EF2BF4E8F76F5A52E0740EE895CA2BCD8E8BF744E31EE6FCB07403E7424979F0FD9BF00000000000008400000000000000000FE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,2,x'0001FFFFFFFFE8FBA9F1D24DF8BFC520B0726891F7BF508D976E1283E03FD122DBF97E6A00407C0200000002000000508D976E1283E03FD122DBF97E6A0040E8FBA9F1D24DF8BFC520B0726891F7BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,3,x'0001FFFFFFFF7B14AE47E17AE0BF068195438B6C00C052B81E85EB51F83F5A643BDF4F8DF73F7C020000000200000052B81E85EB51F83F5A643BDF4F8DF73F7B14AE47E17AE0BF068195438B6C00C0FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,4,x'0001FFFFFFFFC1CAA145B6F3BDBF46B6F3FDD478F73F508D976E1283E03FD122DBF97E6A00407C0200000002000000508D976E1283E03FD122DBF97E6A0040C1CAA145B6F3BDBF46B6F3FDD478F73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,5,x'0001FFFFFFFF48E17A14AE47F53FFED478E92631E43F52B81E85EB51F83F5A643BDF4F8DF73F7C020000000200000052B81E85EB51F83F5A643BDF4F8DF73F48E17A14AE47F53FFED478E92631E43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,6,x'0001FFFFFFFF77BE9F1A2FDDD43FC74B37894160F33F508D976E1283E03FD122DBF97E6A00407C0200000002000000508D976E1283E03FD122DBF97E6A004077BE9F1A2FDDD43FC74B37894160F33FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,7,x'0001FFFFFFFFFCA9F1D24D62EC3FFCA9F1D24D62EC3F52B81E85EB51F83F5A643BDF4F8DF73F7C020000000200000052B81E85EB51F83F5A643BDF4F8DF73FFCA9F1D24D62EC3FFCA9F1D24D62EC3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,8,x'0001FFFFFFFFE8FBA9F1D24DF8BFC520B0726891F7BF508D976E1283E03FD122DBF97E6A00407C0200000002000000E8FBA9F1D24DF8BFC520B0726891F7BF508D976E1283E03FD122DBF97E6A0040FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,9,x'0001FFFFFFFF7B14AE47E17AE0BF068195438B6C00C052B81E85EB51F83F5A643BDF4F8DF73F7C02000000020000007B14AE47E17AE0BF068195438B6C00C052B81E85EB51F83F5A643BDF4F8DF73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,10,x'0001FFFFFFFFC1CAA145B6F3BDBFC74B37894160F33F508D976E1283E03FD122DBF97E6A00407C0200000003000000C1CAA145B6F3BDBF46B6F3FDD478F73F508D976E1283E03FD122DBF97E6A004077BE9F1A2FDDD43FC74B37894160F33FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,11,x'0001FFFFFFFFFCA9F1D24D62EC3FFED478E92631E43F52B81E85EB51F83F5A643BDF4F8DF73F7C0200000003000000FCA9F1D24D62EC3FFCA9F1D24D62EC3F52B81E85EB51F83F5A643BDF4F8DF73F48E17A14AE47F53FFED478E92631E43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100047,12,x'0001FFFFFFFF01000000000008C001000000000008C0010000000000084001000000000008407C03000000010000003100000001000000000008400000000000000000754E31EE6FCB0740397424979F0FD93F518F76F5A52E0740D9895CA2BCD8E83FF5E965DB502C06400BFF02FD695EF23F8139422EDCC80440000000000000F83F6F5B81E85C0A0340DF9D5FDF7538FD3FDA6CDFCC76F80040DA6CDFCC76F80040E29D5FDF7538FD3F6E5B81E85C0A0340030000000000F83F8039422EDCC804400CFF02FD695EF23FF5E965DB502C0640DF895CA2BCD8E83F508F76F5A52E0740417424979F0FD93F754E31EE6FCB07400C8A9E4C3979AA3C01000000000008402F7424979F0FD9BF764E31EE6FCB0740D0895CA2BCD8E8BF518F76F5A52E07400AFF02FD695EF2BFF5E965DB502C0640FEFFFFFFFFFFF7BF8139422EDCC80440DC9D5FDF7538FDBF705B81E85C0A0340DA6CDFCC76F800C0DA6CDFCC76F800406E5B81E85C0A03C0E39D5FDF7538FD3F8039422EDCC804C0060000000000F83FF5E965DB502C06C00DFF02FD695EF23F508F76F5A52E07C0E1895CA2BCD8E83F754E31EE6FCB07C0507424979F0FD93F01000000000008C00C8A9E4C3979BA3C764E31EE6FCB07C0147424979F0FD9BF518F76F5A52E07C0CF895CA2BCD8E8BFF6E965DB502C06C00AFF02FD695EF2BF8339422EDCC804C0F9FFFFFFFFFFF7BF705B81E85C0A03C0DC9D5FDF7538FDBFDB6CDFCC76F800C0DA6CDFCC76F800C0E39D5FDF7538FDBF6D5B81E85C0A03C0070000000000F8BF7F39422EDCC804C013FF02FD695EF2BFF4E965DB502C06C0EE895CA2BCD8E8BF4F8F76F5A52E07C03C7424979F0FD9BF754E31EE6FCB07C088E776F9EADAC3BC01000000000008C0297424979F0FD93F764E31EE6FCB07C0CD895CA2BCD8E83F518F76F5A52E07C00EFF02FD695EF23FF5E965DB502C06C0F8FFFFFFFFFFF73F8339422EDCC804C0DF9D5FDF7538FD3F6E5B81E85C0A03C0D96CDFCC76F80040DB6CDFCC76F800C06D5B81E85C0A0340E39D5FDF7538FDBF7F39422EDCC80440070000000000F8BFF4E965DB502C064013FF02FD695EF2BF4F8F76F5A52E0740F0895CA2BCD8E8BF754E31EE6FCB07403F7424979F0FD9BF01000000000008400000000000000000FE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100048,1,x'0001FFFFFFFF0000000000000000000000000000D0BF0000000000000000000000000000D03F7C02000000020000000000000000000000000000000000D0BF0000000000000000000000000000D03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100049,1,x'0001FFFFFFFF0000000000000000000000000000E8BF0000000000000040000000000000E83F7C02000000030000000000000000000040000000000000E83F000000000000000000000000000000000000000000000040000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100050,1,x'0001FFFFFFFF00000000000000C0000000000000E8BF0000000000000000000000000000E83F7C020000000300000000000000000000C0000000000000E83F0000000000000000000000000000000000000000000000C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100051,1,x'0001FFFFFFFF0000000000000000000000000000E8BF0000000000000000000000000000E83F7C02000000020000000000000000000000000000000000E8BF0000000000000000000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100052,1,x'0001FFFFFFFF3831F3404260F7BFE620F3404260E7BF000000000080F03CAA41F3404260E73F7C030000000100000031000000000000000080F03CFCA9F1D24D62603D80F3DFE31B9979BF75D453F3D168B83F800281DB137D99BF1F8811505C33C83F402C96AB6478ACBF3F151B4527E4D13FE0FDECC4E80DB9BF0C52F3404260D73FC0338F248252C3BFCA0E3CCDF875DC3FE46681CBFE62CBBFCFE7128E8287E03F4674AAB48B4AD2BF9874CFB7A18BE23F0531F3404260D7BFCCA15528853EE43FD36DCB3C5DDCDCBFC5DE39F6BB98E53F80DFEE2C6B53E1BF753917A25994E63FFAC688022853E4BFA2812B09102DE73F2731F3404260E7BFAA41F3404260E73F529B5D7F5C6DEABFA3812B09102DE73FCA82F754196DEDBF763917A25994E63FB255C0F12A29F0BFC5DE39F6BB98E53FE564B6B03188F1BFCDA15528853EE43F1494C8539FCDF2BF9A74CFB7A18BE23F4A048367E2F3F3BFD0E7128E8287E03FAE4A61FCF1F5F4BFCF0E3CCDF875DC3F4861A4B463CFF5BF1152F3404260D73FC57F961B7F7CF6BF40151B4527E4D13F1D2D85F14DFAF6BF268811505C33C83F34510F25A946F7BF8BD453F3D168B83F3831F3404260F7BF0DC7181B1C63603D34510F25A946F7BF2DCE52F3D168B8BF1E2D85F14DFAF6BF030511505C33C8BFC67F961B7F7CF6BFB3D31A4527E4D1BF4A61A4B463CFF5BF7B10F3404260D7BFB04A61FCF1F5F4BF3DCD3BCDF875DCBF4B048367E2F3F3BF0BC7128E8287E0BF1694C8539FCDF2BFD353CFB7A18BE2BFE764B6B03188F1BF07815528853EE4BFB455C0F12A29F0BF00BE39F6BB98E5BFD282F754196DEDBFB01817A25994E6BF549B5D7F5C6DEABFDE602B09102DE7BF2831F3404260E7BFE620F3404260E7BFFDC688022853E4BFDF602B09102DE7BF84DFEE2C6B53E1BFB21817A25994E6BFD16DCB3C5DDCDCBF00BE39F6BB98E5BF0F31F3404260D7BF0B815528853EE4BF4974AAB48B4AD2BFD553CFB7A18BE2BFEC6681CBFE62CBBF0DC7128E8287E0BFC8338F248252C3BF45CD3BCDF875DCBFF0FDECC4E80DB9BF8910F3404260D7BF502C96AB6478ACBFBDD31A4527E4D1BFA00281DB137D99BF230511505C33C8BF80F3DFE31B9979BF57CE52F3D168B8BF000000000080F03CFCA9F1D24D62603DFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100053,1,x'0001FFFFFFFF000000000080F0BCAA41F3404260E7BF3831F3404260F73FE620F3404260E73F7C0300000001000000310000003831F3404260F73FFCA9F1D24D6260BD34510F25A946F73F51CE52F3D168B83F1D2D85F14DFAF63F0D0511505C33C83FC57F961B7F7CF63FB5D31A4527E4D13F4961A4B463CFF53F8210F3404260D73FAF4A61FCF1F5F43F40CD3BCDF875DC3F4A048367E2F3F33F0BC7128E8287E03F1694C8539FCDF23FD453CFB7A18BE23FE664B6B03188F13F08815528853EE43FB255C0F12A29F03F01BE39F6BB98E53FCE82F754196DED3FB11817A25994E63F549B5D7F5C6DEA3FDE602B09102DE73F2731F3404260E73FE620F3404260E73FFCC688022853E43FDF602B09102DE73F84DFEE2C6B53E13FB21817A25994E63FD56DCB3C5DDCDC3F01BE39F6BB98E53F0931F3404260D73F09815528853EE43F4C74AAB48B4AD23FD653CFB7A18BE23FE86681CBFE62CB3F0CC7128E8287E03FC4338F248252C33F45CD3BCDF875DC3FF0FDECC4E80DB93F8710F3404260D73F402C96AB6478AC3FB6D31A4527E4D13F800281DB137D993F140511505C33C83F80F3DFE31B99793F67CE52F3D168B83F000000000080F0BCEB8CCA8A7F6160BD00F3DFE31B99793F51D453F3D168B8BF600281DB137D993F158811505C33C8BF302C96AB6478AC3F3D151B4527E4D1BFD0FDECC4E80DB93F0552F3404260D7BFBC338F248252C33FC70E3CCDF875DCBFE06681CBFE62CB3FCFE7128E8287E0BF4474AAB48B4AD23F9774CFB7A18BE2BF0031F3404260D73FCBA15528853EE4BFCD6DCB3C5DDCDC3FC4DE39F6BB98E5BF7CDFEE2C6B53E13F743917A25994E6BFFAC688022853E43FA2812B09102DE7BF2631F3404260E73FAA41F3404260E7BF519B5D7F5C6DEA3FA3812B09102DE7BFCA82F754196DED3F763917A25994E6BFB355C0F12A29F03FC4DE39F6BB98E5BFE364B6B03188F13FCFA15528853EE4BF1594C8539FCDF23F9974CFB7A18BE2BF4A048367E2F3F33FD1E7128E8287E0BFAE4A61FCF1F5F43FCF0E3CCDF875DCBF4861A4B463CFF53F1352F3404260D7BFC47F961B7F7CF63F47151B4527E4D1BF1C2D85F14DFAF63F358811505C33C8BF34510F25A946F73F7BD453F3D168B8BF3831F3404260F73FFCA9F1D24D6260BDFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100054,1,x'0001FFFFFFFF92ED7C3F355EBA3FFCA9F1D24D6270BD1B2FDD240681F13FBF9FCAA145B6EF3F7C020000000200000092ED7C3F355EBA3FFCA9F1D24D6270BD1B2FDD240681F13FBF9FCAA145B6EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100054,2,x'0001FFFFFFFFEC51B81E85EBE93FFCA9F1D24D6270BD448B6CE7FBA9F93FD7A320B07268E93F7C0200000002000000EC51B81E85EBE93FFCA9F1D24D6270BD448B6CE7FBA9F93FD7A320B07268E93FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100054,3,x'0001FFFFFFFF1383C0CAA145F83FFCA9F1D24D6270BDCFF753E3A59BFE3F69914D621058D93F7C02000000020000001383C0CAA145F83FFCA9F1D24D6270BDCFF753E3A59BFE3F69914D621058D93FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100054,4,x'0001FFFFFFFF0000000000000000FCA9F1D24D6270BD00000000000000409EEFFFFFFFFFEF3F7C0300000001000000220000000000000000000000FCA9F1D24D6270BD0000000000000040FCA9F1D24D6260BD9292E8D146ECFF3F2A3129BCA617B93F58AEFBE74BB1FF3F8E64693CB8F8C83FED1663ABA04FFF3F417ED52E0694D23FA34699E735C8FE3FA088AEA6E27DD83FD85EC078591CFE3F7AD506385D2BDE3FD2508714B34DFD3F6658AE393BC7E13FA08B8A35405EFC3F740D0925F34CE43FE69D3F334F50FB3F6B2B7F669EA0E63FEA8E84927926FA3FE006156B80BCE83F6334D79C9DE3F83F43910E29669BEA3F8FBD014ED78AF73F4FAD80F1B238EC3F58AAABA9781FF63FE47C32CF6B90ED3FC067B58B01A5F43F791DC656419FEE3FC1348D07171FF33F4E4CF7CF9762EF3F439BC26B7A91F13FC414D1A38DD8EF3FFFFFFFFFFFFFEF3F9EEFFFFFFFFFEF3F79C97A280BDDEC3FC314D1A38DD8EF3F7D96E5F0D1C1E93F4E4CF7CF9762EF3F7E3095E8FCB5E63F791DC656419FEE3F4EABA8AC0EC1E33FE47C32CF6B90ED3FE184FC6351EAE03F4EAD80F1B238EC3F722EA38C8971DC3F42910E29669BEA3F54C4EDB51966D73FDF06156B80BCE83F66880133C3BED23F6A2B7F669EA0E63FFCA2AB53FE0DCD3F730D0925F34CE43F7079C55B6792C53F6558AE393BC7E13F8012FA73683ABE3F78D506385D2BDE3FD0956B86A17CB33F9E88AEA6E27DD83F50229D93EA0BA63F3F7ED52E0694D23F006A140106AD933F8964693CB8F8C83F006D6D172EB9733F223129BCA617B93F0000000000000000FCA9F1D24D6270BDFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100055,1,x'0001FFFFFFFF0000000000C010BD000000000000B9BCF598DEFFFFFFFF3F427244650C73EE3F7C02000000210000000000000000C010BD000000000000B9BC33C5C6A8B1E8823FED575627883EB83F86FB01E978129C3F0837993ACC13C83F6F323921AAD7AB3F3C434707FAE0D13FB92717A9C402B73F0281D9F05C87D73FD109F865341AC13FA69B0198FEEFDC3F20EA4BD86FB3C73FCD4609C22E07E13F0D30BCEAD23DCF3FCEDCFCF7516BE33F57B45323F7D3D33F8C67C293E19EE53FF64FBDA7266FD83FEB52318CC69CE73F98A54C8FD165DD3F4207E1ED6560E93F9A6ED1F03E56E13FBC3C1181ABE5EA3F62AE2A557C1BE43FE8860C381329EC3F045ED41639FCE63FE7AE3650B127ED3FD03BE5C3CDF1E93F0827FB1239DFED3FACED05B962F5EC3FAE0CFE26024EEE3FD4697CF3FFFFEF3F427244650C73EE3F588308974E85F13F985C7729024EEE3F7DEAC5111907F33F8E0EE81739DFED3F4DFD9868E381F43FA2CA8B57B127ED3F2562D5C941F2F53FB2E2B8411329EC3FC288857CE054F73FE37AFE8CABE5EA3FF666B9918BA6F83F3894F3FB6560E93F35E8544C36E4F93F10A5489CC69CE73FD1AD3E2E020BFB3F644AB9A5E19EE53FFE46A19A4518FC3F0EC7A90B526BE33F4843E8FD9109FD3F60BA3ED72E07E13FB9343D6DB9DCFD3F12821BC5FEEFDC3FA05284B0D38FFE3FDA1E3A205D87D73F6F1932AB4221FF3F610D8138FAE0D13FB1DFC719B68FFF3F9181DB9FCC13C83F7886519B2EDAFF3F0C19A4F5883EB83FF598DEFFFFFFFF3F000080813D076A3EFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100056,1,x'0001FFFFFFFF0000000000000000000000000000E0BF0000000000000000000000000000E03F7C02000000020000000000000000000000000000000000E0BF0000000000000000000000000000E03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100057,1,x'0001FFFFFFFF297826D2CCCC08C0D0A9EC389A99B9BF3A9A1C68C951ECBF287D5A8E65FFDF3F7C0200000009000000297826D2CCCC08C0D0A9EC389A99B9BFF38752A9DFEB06C088E06AFFFB5CB43F88ADDBB862E204C0F615591C4766CD3FF8CA623ED6B702C02C276D36E549D63F04E04234347400C07AECC74992BFDB3FADD00DE5A53FFCBFDEA368361000DF3F179185F78C86F7BF287D5A8E65FFDF3F8C0CB5CD81CEF2BF049F281FE6B9DE3F3A9A1C68C951ECBF249CE4774034DB3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100057,2,x'0001FFFFFFFFD6831C68C951EC3FA0A15A8E65FFDFBFF28526D2CCCC0840807BEC389A99B93F7C0200000009000000D6831C68C951EC3F00AEE4774034DBBF0606B5CD81CEF23FD1BB281FE6B9DEBF8E8F85F78C86F73FA0A15A8E65FFDFBF4FD40DE5A53FFC3F92CC68361000DFBF70E4423434740040F415C84992BFDBBFF4D1623ED6B70240FD4D6D36E549D6BFF9B6DBB862E204408657591C4766CDBFAE9352A9DFEB0640303F6BFFFB5CB4BFF28526D2CCCC0840807BEC389A99B93FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100101,1,x'0001FFFFFFFF00000000000000C0000000000000D0BF0000000000000000000000000000D0BF7C020000000200000000000000000000C0000000000000D0BF0000000000000000000000000000D0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100101,2,x'0001FFFFFFFF00000000000000C0000000000000D03F0000000000000000000000000000D03F7C020000000200000000000000000000C0000000000000D03F0000000000000000000000000000D03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100102,1,x'0001FFFFFFFF00000000000019C00000000000000000000000000000000000000000000000007C020000000200000000000000000019C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100102,2,x'0001FFFFFFFF00000000000000C0000000000000E8BF0000000000000000000000000000E83F7C020000000300000000000000000000C0000000000000E83F0000000000000000000000000000000000000000000000C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100102,3,x'0001FFFFFFFF4D20366666661AC0057A889C9999D93F857AFDFFFFFF18C0566B09000000E83F7C02000000110000004D20366666661AC0566B09000000E83FF685149200431AC0682A955092F8E73F6BE7AE25E11F1AC0705EB3C490D4E73F0E765F2D64FD19C0015C5BB95994E73FE60AC00BE4DB19C07F6252799538E73F4475C98CB8BB19C0040F1E8434C2E63FB860BBFF359D19C0FBBBBA176D32E63FB5D7275AAC8019C054A28903B88AE53FE0746566666619C07598C9CCCCCCE43FA5738DFFA84E19C0C981B62E9DFAE33F6F50075DB23919C0B7391A025016E33F0EE67A6FB92719C05395A9993B22E23F9F5BD450ED1819C043E8F4A1DF20E13F6F3CD3C8740D19C0008FF994DE14E03F223C68E76D0519C03408FCA4ED01DE3FA302ECB5ED0019C0811FA2DEF6CFDB3F857AFDFFFFFF18C0057A889C9999D93FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100102,4,x'0001FFFFFFFFA117366666661AC06269FEFFFFFFE7BFC4DAFEFFFFFF18C0EA03899C9999D9BF7C0200000011000000C4DAFEFFFFFF18C0EA03899C9999D9BFF261EDB5ED0019C0116FA0DEF6CFDBBFEA9669E76D0519C0DE21F8A4ED01DEBF238FD4C8740D19C0FF85F694DE14E0BFC5A2D550ED1819C061D1F0A1DF20E1BF4E1E7C6FB92719C0467BA4993B22E2BF9576085DB23919C0E32914025016E3BFAE848EFFA84E19C0118CAF2E9DFAE3BF016E6666666619C017CFC1CCCCCCE4BF61B6285AAC8019C0BC198103B88AE5BFA622BCFF359D19C0898AB1176D32E6BF7818CA8CB8BB19C0D14C148434C2E6BFB58DC00BE4DB19C0202948799538E7BF20D75F2D64FD19C046C650B95994E7BFC125AF25E11F1AC01888A8C490D4E7BFEFA0149200431AC0DE2F8A5092F8E7BFA117366666661AC06269FEFFFFFFE7BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100102,5,x'0001FFFFFFFF0000000000001CC0000000000000E83F6766666666661AC0000000000000E83F7C02000000020000006766666666661AC0000000000000E83F0000000000001CC0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100102,6,x'0001FFFFFFFF0000000000001CC0000000000000E8BF0000000000001CC0000000000000E83F7C02000000020000000000000000001CC0000000000000E83F0000000000001CC0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100102,7,x'0001FFFFFFFF0000000000001CC0000000000000E8BF6766666666661AC0000000000000E8BF7C02000000020000000000000000001CC0000000000000E8BF6766666666661AC0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100102,8,x'0001FFFFFFFF00000000000019C09A9999999999D9BF00000000000019C09A9999999999D93F7C020000000200000000000000000019C09A9999999999D93F00000000000019C09A9999999999D9BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,1,x'0001FFFFFFFF00000000000014C000000000000000000000000000000000000000000000F03F7C03000000010000000500000000000000000014C0000000000000F03F00000000000014C00000000000000000000000000000000000000000000000000000000000000000000000000000F03F00000000000014C0000000000000F03FFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,2,x'0001FFFFFFFF00000000000014C000000000000000000000000000000000000000000000F03F7C03000000010000000500000000000000000014C0000000000000F03F00000000000014C00000000000000000000000000000000000000000000000000000000000000000000000000000F03F00000000000014C0000000000000F03FFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,3,x'0001FFFFFFFF00000000000014C000000000000000000000000000000000000000000000F03F7C020000000500000000000000000014C0000000000000F03F0000000000000000000000000000F03F0000000000000000000000000000000000000000000014C0000000000000000000000000000014C0000000000000F03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,4,x'0001FFFFFFFF2751963BBDEA13C01D5AF3BEDACAE83F446BDE575B1913C03789B2DCE955EF3F7C02000000020000002751963BBDEA13C01D5AF3BEDACAE83F446BDE575B1913C03789B2DCE955EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,5,x'0001FFFFFFFF2751963BBDEA13C048E1B6229C33CF3F0AB715E19CF910C03789B2DCE955EF3F7C02000000020000002751963BBDEA13C048E1B6229C33CF3F0AB715E19CF910C03789B2DCE955EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,6,x'0001FFFFFFFF39D456065FB012C017D9AE69C442953FD763541EC9B50DC03789B2DCE955EF3F7C020000000200000039D456065FB012C017D9AE69C442953FD763541EC9B50DC03789B2DCE955EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,7,x'0001FFFFFFFF1B4F6BB4A69110C017D9AE69C442953F9A597D7A587809C03789B2DCE955EF3F7C02000000020000001B4F6BB4A69110C017D9AE69C442953F9A597D7A587809C03789B2DCE955EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,8,x'0001FFFFFFFFC335457BD0E30CC017D9AE69C442953F27F1EB8CDB3805C03789B2DCE955EF3F7C0200000002000000C335457BD0E30CC017D9AE69C442953F27F1EB8CDB3805C03789B2DCE955EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,9,x'0001FFFFFFFF852B6ED75FA608C017D9AE69C442953FEAE614E96AFB00C03789B2DCE955EF3F7C0200000002000000852B6ED75FA608C017D9AE69C442953FEAE614E96AFB00C03789B2DCE955EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,10,x'0001FFFFFFFF48219733EF6804C017D9AE69C442953F58B97B8AF47BF9BF3789B2DCE955EF3F7C020000000200000048219733EF6804C017D9AE69C442953F58B97B8AF47BF9BF3789B2DCE955EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,11,x'0001FFFFFFFFD5B80546722900C017D9AE69C442953F73E858AFFAFCF0BF3789B2DCE955EF3F7C0200000002000000D5B80546722900C017D9AE69C442953F73E858AFFAFCF0BF3789B2DCE955EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,12,x'0001FFFFFFFF2F5D5D4403D8F7BF17D9AE69C442953FF0A755CF3204E1BF3789B2DCE955EF3F7C02000000020000002F5D5D4403D8F7BF17D9AE69C442953FF0A755CF3204E1BF3789B2DCE955EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,13,x'0001FFFFFFFF69915EF943BAEEBF17D9AE69C442953F17D9AE69C44295BF69915EF943BAEE3F7C020000000200000069915EF943BAEEBF17D9AE69C442953F17D9AE69C44295BF69915EF943BAEE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100103,14,x'0001FFFFFFFF3CDF3186A078DBBF17D9AE69C442953F17D9AE69C44295BF3CDF3186A078DB3F7C02000000020000003CDF3186A078DBBF17D9AE69C442953F17D9AE69C44295BF3CDF3186A078DB3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100104,1,x'0001FFFFFFFF9A999999999909C0666666666666D6BF00000000000004C0666666666666D63F7C03000000010000003100000000000000000004C0A34DE9AD68B598BCD9B6F1DF210604C0B0B0CC48EA63A73FAED55CA36C1804C02A09010FB030B73FA493AB2A903604C08F76AD74EB24C13FB1DF1172086004C0626666666666C63F67C6CED31F9404C0AAE80359C345CB3FF8DDD423F2D104C04EED7E8FAAADCF3F428E3C97701805C03133F0C767C5D13F67666666666605C0DC68D7D52266D33F64F581157EBA05C049C90911E5B1D43F83C4544C471306C0F4B87F4B01A3D53F0A9AA9233D6F06C09FAFD8665735D63FCDCCCCCCCCCC06C0666666666666D63F90FFEF755C2A07C0A0AFD8665735D63F16D5444D528607C0F5B87F4B01A3D53F36A417841BDF07C04BC90911E5B1D43F33333333333308C0DF68D7D52266D33F580B5D02298108C03533F0C767C5D13FA2BBC475A7C708C054ED7E8FAAADCF3F33D3CAC5790509C0B2E80359C345CB3FE8B98727913909C06D6666666666C63FF605EE6E096309C09676AD74EB24C13FECC33CF62C8109C03D09010FB030B73FC1E2A7B9779309C0DDB0CC48EA63A73F9A999999999909C03AFA6E820E88A23CC1E2A7B9779309C08DB0CC48EA63A7BFECC33CF62C8109C02009010FB030B7BFF605EE6E096309C08D76AD74EB24C1BFE9B98727913909C05B6666666666C6BF34D3CAC5790509C0A7E80359C345CBBFA2BBC475A7C708C04EED7E8FAAADCFBF580B5D02298108C03033F0C767C5D1BF34333333333308C0DB68D7D52266D3BF37A417841BDF07C048C90911E5B1D4BF17D5444D528607C0F3B87F4B01A3D5BF90FFEF755C2A07C09FAFD8665735D6BFCDCCCCCCCCCC06C0666666666666D6BF0A9AA9233D6F06C0A0AFD8665735D6BF84C4544C471306C0F5B87F4B01A3D5BF64F581157EBA05C04BC90911E5B1D4BF67666666666605C0E168D7D52266D3BF428E3C97701805C03433F0C767C5D1BFF8DDD423F2D104C055ED7E8FAAADCFBF67C6CED31F9404C0B2E80359C345CBBFB2DF1172086004C06F6666666666C6BFA493AB2A903604C09C76AD74EB24C1BFAFD55CA36C1804C04B09010FB030B7BFD9B6F1DF210604C0CEB0CC48EA63A7BF00000000000004C0A34DE9AD68B598BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100104,2,x'0001FFFFFFFF666666666666E6BF666666666666D6BF00000000000090BC666666666666D63F7C03000000010000003100000000000000000090BCA34DE9AD68B598BCE663DBC67F8768BFB0B0CC48EA63A73F33AED55CA36C88BF2A09010FB030B73FC7D1C95515489BBF8F76AD74EB24C13F42EC77841C02A8BF626666666666C63FCCCCD879FA83B2BFAAE80359C345CB3FF4BE9B7A443EBABF4EED7E8FAAADCF3F1DE4C8730987C1BF3133F0C767C5D13F646666666666C6BFDC68D7D52266D33F39561F58E1A7CBBF49C90911E5B1D43F1924A6623A9AD0BFF4B87F4B01A3D53F4DD04C1DE979D3BF9FAFD8665735D63F656666666666D6BF666666666666D63F7BFC7FAFE352D9BFA0AFD8665735D63FB0A8266A9232DCBFF5B87F4B01A3D53FAF21BD20DCF8DEBF4BC90911E5B1D43FCBCCCCCCCCCCE0BFDF68D7D52266D33F5D2D7409A404E2BF3533F0C767C5D13F87EE12D79D1EE3BF54ED7E8FAAADCF3FCC4C2B17E715E4BFB2E80359C345CB3FA2E71E9E44E6E4BF6D6666666666C63FD817B8BB258CE5BF9676AD74EB24C13FAE0FF3D8B304E6BF3D09010FB030B73F038B9FE6DE4DE6BFDDB0CC48EA63A73F666666666666E6BF3AFA6E820E88A23C048B9FE6DE4DE6BF8DB0CC48EA63A7BFAE0FF3D8B304E6BF2009010FB030B7BFD917B8BB258CE5BF8D76AD74EB24C1BFA4E71E9E44E6E4BF5B6666666666C6BFCE4C2B17E715E4BFA7E80359C345CBBF89EE12D79D1EE3BF4EED7E8FAAADCFBF612D7409A404E2BF3033F0C767C5D1BFCFCCCCCCCCCCE0BFDB68D7D52266D3BFB521BD20DCF8DEBF48C90911E5B1D4BFB9A8266A9232DCBFF3B87F4B01A3D5BF81FC7FAFE352D9BF9FAFD8665735D6BF6A6666666666D6BF666666666666D6BF53D04C1DE979D3BFA0AFD8665735D6BF1F24A6623A9AD0BFF5B87F4B01A3D5BF3C561F58E1A7CBBF4BC90911E5B1D4BF736666666666C6BFE168D7D52266D3BF24E4C8730987C1BF3433F0C767C5D1BF02BF9B7A443EBABF55ED7E8FAAADCFBFDCCCD879FA83B2BFB2E80359C345CBBF5EEC77841C02A8BF6F6666666666C6BFE9D1C95515489BBF9C76AD74EB24C1BF8DAED55CA36C88BF4B09010FB030B7BF1A64DBC67F8768BFCEB0CC48EA63A7BF00000000000090BCA34DE9AD68B598BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100104,3,x'0001FFFFFFFF666666666666E6BF666666666666D6BF00000000000090BC666666666666D63F7C03000000010000003100000000000000000090BCA34DE9AD68B598BCE663DBC67F8768BFB0B0CC48EA63A73F33AED55CA36C88BF2A09010FB030B73FC7D1C95515489BBF8F76AD74EB24C13F42EC77841C02A8BF626666666666C63FCCCCD879FA83B2BFAAE80359C345CB3FF4BE9B7A443EBABF4EED7E8FAAADCF3F1DE4C8730987C1BF3133F0C767C5D13F646666666666C6BFDC68D7D52266D33F39561F58E1A7CBBF49C90911E5B1D43F1924A6623A9AD0BFF4B87F4B01A3D53F4DD04C1DE979D3BF9FAFD8665735D63F656666666666D6BF666666666666D63F7BFC7FAFE352D9BFA0AFD8665735D63FB0A8266A9232DCBFF5B87F4B01A3D53FAF21BD20DCF8DEBF4BC90911E5B1D43FCBCCCCCCCCCCE0BFDF68D7D52266D33F5D2D7409A404E2BF3533F0C767C5D13F87EE12D79D1EE3BF54ED7E8FAAADCF3FCC4C2B17E715E4BFB2E80359C345CB3FA2E71E9E44E6E4BF6D6666666666C63FD817B8BB258CE5BF9676AD74EB24C13FAE0FF3D8B304E6BF3D09010FB030B73F038B9FE6DE4DE6BFDDB0CC48EA63A73F666666666666E6BF3AFA6E820E88A23C048B9FE6DE4DE6BF8DB0CC48EA63A7BFAE0FF3D8B304E6BF2009010FB030B7BFD917B8BB258CE5BF8D76AD74EB24C1BFA4E71E9E44E6E4BF5B6666666666C6BFCE4C2B17E715E4BFA7E80359C345CBBF89EE12D79D1EE3BF4EED7E8FAAADCFBF612D7409A404E2BF3033F0C767C5D1BFCFCCCCCCCCCCE0BFDB68D7D52266D3BFB521BD20DCF8DEBF48C90911E5B1D4BFB9A8266A9232DCBFF3B87F4B01A3D5BF81FC7FAFE352D9BF9FAFD8665735D6BF6A6666666666D6BF666666666666D6BF53D04C1DE979D3BFA0AFD8665735D6BF1F24A6623A9AD0BFF5B87F4B01A3D5BF3C561F58E1A7CBBF4BC90911E5B1D4BF736666666666C6BFE168D7D52266D3BF24E4C8730987C1BF3433F0C767C5D1BF02BF9B7A443EBABF55ED7E8FAAADCFBFDCCCD879FA83B2BFB2E80359C345CBBF5EEC77841C02A8BF6F6666666666C6BFE9D1C95515489BBF9C76AD74EB24C1BF8DAED55CA36C88BF4B09010FB030B7BF1A64DBC67F8768BFCEB0CC48EA63A7BF00000000000090BCA34DE9AD68B598BCFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100104,4,x'0001FFFFFFFF666666666666E6BF666666666666D6BF00000000000090BC666666666666D63F7C03000000010000003100000000000000000090BCA34DE9AD68B598BCE663DBC67F8768BFB0B0CC48EA63A73F33AED55CA36C88BF2A09010FB030B73FC7D1C95515489BBF8F76AD74EB24C13F42EC77841C02A8BF626666666666C63FCCCCD879FA83B2BFAAE80359C345CB3FF4BE9B7A443EBABF4EED7E8FAAADCF3F1DE4C8730987C1BF3133F0C767C5D13F646666666666C6BFDC68D7D52266D33F39561F58E1A7CBBF49C90911E5B1D43F1924A6623A9AD0BFF4B87F4B01A3D53F4DD04C1DE979D3BF9FAFD8665735D63F656666666666D6BF666666666666D63F7BFC7FAFE352D9BFA0AFD8665735D63FB0A8266A9232DCBFF5B87F4B01A3D53FAF21BD20DCF8DEBF4BC90911E5B1D43FCBCCCCCCCCCCE0BFDF68D7D52266D33F5D2D7409A404E2BF3533F0C767C5D13F87EE12D79D1EE3BF54ED7E8FAAADCF3FCC4C2B17E715E4BFB2E80359C345CB3FA2E71E9E44E6E4BF6D6666666666C63FD817B8BB258CE5BF9676AD74EB24C13FAE0FF3D8B304E6BF3D09010FB030B73F038B9FE6DE4DE6BFDDB0CC48EA63A73F666666666666E6BF3AFA6E820E88A23C048B9FE6DE4DE6BF8DB0CC48EA63A7BFAE0FF3D8B304E6BF2009010FB030B7BFD917B8BB258CE5BF8D76AD74EB24C1BFA4E71E9E44E6E4BF5B6666666666C6BFCE4C2B17E715E4BFA7E80359C345CBBF89EE12D79D1EE3BF4EED7E8FAAADCFBF612D7409A404E2BF3033F0C767C5D1BFCFCCCCCCCCCCE0BFDB68D7D52266D3BFB521BD20DCF8DEBF48C90911E5B1D4BFB9A8266A9232DCBFF3B87F4B01A3D5BF81FC7FAFE352D9BF9FAFD8665735D6BF6A6666666666D6BF666666666666D6BF53D04C1DE979D3BFA0AFD8665735D6BF1F24A6623A9AD0BFF5B87F4B01A3D5BF3C561F58E1A7CBBF4BC90911E5B1D4BF736666666666C6BFE168D7D52266D3BF24E4C8730987C1BF3433F0C767C5D1BF02BF9B7A443EBABF55ED7E8FAAADCFBFDCCCD879FA83B2BFB2E80359C345CBBF5EEC77841C02A8BF6F6666666666C6BFE9D1C95515489BBF9C76AD74EB24C1BF8DAED55CA36C88BF4B09010FB030B7BF1A64DBC67F8768BFCEB0CC48EA63A7BF00000000000090BCA34DE9AD68B598BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100104,5,x'0001FFFFFFFFDD2406819543E3BF115839B4C876CEBFD122DBF97E6ABCBFFED478E92631D03F7C0200000002000000DD2406819543E3BF115839B4C876CEBFD122DBF97E6ABCBFFED478E92631D03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100104,6,x'0001FFFFFFFF9A999999999909C0666666666666D6BF00000000000004C0666666666666D63F7C03000000010000003100000000000000000004C0A34DE9AD68B598BCD9B6F1DF210604C0B0B0CC48EA63A73FAED55CA36C1804C02A09010FB030B73FA493AB2A903604C08F76AD74EB24C13FB1DF1172086004C0626666666666C63F67C6CED31F9404C0AAE80359C345CB3FF8DDD423F2D104C04EED7E8FAAADCF3F428E3C97701805C03133F0C767C5D13F67666666666605C0DC68D7D52266D33F64F581157EBA05C049C90911E5B1D43F83C4544C471306C0F4B87F4B01A3D53F0A9AA9233D6F06C09FAFD8665735D63FCDCCCCCCCCCC06C0666666666666D63F90FFEF755C2A07C0A0AFD8665735D63F16D5444D528607C0F5B87F4B01A3D53F36A417841BDF07C04BC90911E5B1D43F33333333333308C0DF68D7D52266D33F580B5D02298108C03533F0C767C5D13FA2BBC475A7C708C054ED7E8FAAADCF3F33D3CAC5790509C0B2E80359C345CB3FE8B98727913909C06D6666666666C63FF605EE6E096309C09676AD74EB24C13FECC33CF62C8109C03D09010FB030B73FC1E2A7B9779309C0DDB0CC48EA63A73F9A999999999909C03AFA6E820E88A23CC1E2A7B9779309C08DB0CC48EA63A7BFECC33CF62C8109C02009010FB030B7BFF605EE6E096309C08D76AD74EB24C1BFE9B98727913909C05B6666666666C6BF34D3CAC5790509C0A7E80359C345CBBFA2BBC475A7C708C04EED7E8FAAADCFBF580B5D02298108C03033F0C767C5D1BF34333333333308C0DB68D7D52266D3BF37A417841BDF07C048C90911E5B1D4BF17D5444D528607C0F3B87F4B01A3D5BF90FFEF755C2A07C09FAFD8665735D6BFCDCCCCCCCCCC06C0666666666666D6BF0A9AA9233D6F06C0A0AFD8665735D6BF84C4544C471306C0F5B87F4B01A3D5BF64F581157EBA05C04BC90911E5B1D4BF67666666666605C0E168D7D52266D3BF428E3C97701805C03433F0C767C5D1BFF8DDD423F2D104C055ED7E8FAAADCFBF67C6CED31F9404C0B2E80359C345CBBFB2DF1172086004C06F6666666666C6BFA493AB2A903604C09C76AD74EB24C1BFAFD55CA36C1804C04B09010FB030B7BFD9B6F1DF210604C0CEB0CC48EA63A7BF00000000000004C0A34DE9AD68B598BCFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100104,7,x'0001FFFFFFFF9A999999999909C0666666666666D6BF00000000000004C0666666666666D63F7C03000000010000003100000000000000000004C0A34DE9AD68B598BCD9B6F1DF210604C0B0B0CC48EA63A73FAED55CA36C1804C02A09010FB030B73FA493AB2A903604C08F76AD74EB24C13FB1DF1172086004C0626666666666C63F67C6CED31F9404C0AAE80359C345CB3FF8DDD423F2D104C04EED7E8FAAADCF3F428E3C97701805C03133F0C767C5D13F67666666666605C0DC68D7D52266D33F64F581157EBA05C049C90911E5B1D43F83C4544C471306C0F4B87F4B01A3D53F0A9AA9233D6F06C09FAFD8665735D63FCDCCCCCCCCCC06C0666666666666D63F90FFEF755C2A07C0A0AFD8665735D63F16D5444D528607C0F5B87F4B01A3D53F36A417841BDF07C04BC90911E5B1D43F33333333333308C0DF68D7D52266D33F580B5D02298108C03533F0C767C5D13FA2BBC475A7C708C054ED7E8FAAADCF3F33D3CAC5790509C0B2E80359C345CB3FE8B98727913909C06D6666666666C63FF605EE6E096309C09676AD74EB24C13FECC33CF62C8109C03D09010FB030B73FC1E2A7B9779309C0DDB0CC48EA63A73F9A999999999909C03AFA6E820E88A23CC1E2A7B9779309C08DB0CC48EA63A7BFECC33CF62C8109C02009010FB030B7BFF605EE6E096309C08D76AD74EB24C1BFE9B98727913909C05B6666666666C6BF34D3CAC5790509C0A7E80359C345CBBFA2BBC475A7C708C04EED7E8FAAADCFBF580B5D02298108C03033F0C767C5D1BF34333333333308C0DB68D7D52266D3BF37A417841BDF07C048C90911E5B1D4BF17D5444D528607C0F3B87F4B01A3D5BF90FFEF755C2A07C09FAFD8665735D6BFCDCCCCCCCCCC06C0666666666666D6BF0A9AA9233D6F06C0A0AFD8665735D6BF84C4544C471306C0F5B87F4B01A3D5BF64F581157EBA05C04BC90911E5B1D4BF67666666666605C0E168D7D52266D3BF428E3C97701805C03433F0C767C5D1BFF8DDD423F2D104C055ED7E8FAAADCFBF67C6CED31F9404C0B2E80359C345CBBFB2DF1172086004C06F6666666666C6BFA493AB2A903604C09C76AD74EB24C1BFAFD55CA36C1804C04B09010FB030B7BFD9B6F1DF210604C0CEB0CC48EA63A7BF00000000000004C0A34DE9AD68B598BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100104,8,x'0001FFFFFFFF37894160E5D008C0653BDF4F8D97CEBF17D9CEF753E304C054E3A59BC420D03F7C020000000200000037894160E5D008C0653BDF4F8D97CEBF17D9CEF753E304C054E3A59BC420D03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,1,x'0001FFFFFFFFCDCCCCCCCCCC16C07F6A66666666D6BF01000000000014C04D6266666666D63F7C03000000010000003100000001000000000014C04F241D2D7B6830BD6DDBF8EF100314C0EB8FCC48EA63A73FD86AAE51360C14C0C8F8000FB030B73FD2C95515481B14C05E6EAD74EB24C13FD9EF0839043014C0315E66666666C63F3463E7E90F4A14C078E00359C345CB3FFC6EEA11F96814C01DE57E8FAAADCF3F22479E4B388C14C0182FF0C767C5D13F3433333333B314C0C464D7D52266D33FB2FAC00A3FDD14C031C50911E5B1D43F42622AA6A30915C0DBB47F4B01A3D53F05CDD4919E3715C086ABD8665735D63F67666666666615C04D6266666666D63FC8FFF73A2E9515C088ABD8665735D63F8C6AA22629C315C0DDB47F4B01A3D53F1CD20BC28DEF15C032C50911E5B1D43F9A999999991916C0C664D7D52266D33FAC852E81944016C01C2FF0C767C5D13FD25DE2BAD36316C023E57E8FAAADCF3F9A69E5E2BC8216C081E00359C345CB3FF5DCC393C89C16C03C5E66666666C63FFC0277B784B116C0656EAD74EB24C13FF6611E7B96C016C0DBF8000FB030B73F61F1D3DCBBC916C01990CC48EA63A73FCDCCCCCCCCCC16C07F72B0CB095930BD61F1D3DCBBC916C051D1CC48EA63A7BFF6611E7B96C016C08219010FB030B7BFFC0277B784B116C0BE7EAD74EB24C1BFF5DCC393C89C16C08C6E66666666C6BF9A69E5E2BC8216C0D8F00359C345CBBFD25DE2BAD36316C07FF57E8FAAADCFBFAC852E81944016C04937F0C767C5D1BF9A999999991916C0F46CD7D52266D3BF1CD20BC28DEF15C061CD0911E5B1D4BF8C6AA22629C315C00BBD7F4B01A3D5BFC8FFF73A2E9515C0B7B3D8665735D6BF67666666666615C07F6A66666666D6BF06CDD4919E3715C0B9B3D8665735D6BF42622AA6A30915C00EBD7F4B01A3D5BFB2FAC00A3FDD14C063CD0911E5B1D4BF3433333333B314C0F96CD7D52266D3BF22479E4B388C14C04D37F0C767C5D1BFFD6EEA11F96814C086F57E8FAAADCFBF3463E7E90F4A14C0E4F00359C345CBBFD9EF0839043014C0A06E66666666C6BFD2C95515481B14C0CD7EAD74EB24C1BFD86AAE51360C14C0AD19010FB030B7BF6DDBF8EF100314C093D1CC48EA63A7BF01000000000014C04F241D2D7B6830BDFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,2,x'0001FFFFFFFF9A999999999909C07F6A66666666D6BF00000000000004C04D6266666666D63F7C03000000010000003100000000000000000004C04F241D2D7B6830BDD9B6F1DF210604C0EB8FCC48EA63A73FAED55CA36C1804C0C8F8000FB030B73FA493AB2A903604C05E6EAD74EB24C13FB1DF1172086004C0315E66666666C63F67C6CED31F9404C078E00359C345CB3FF8DDD423F2D104C01DE57E8FAAADCF3F428E3C97701805C0182FF0C767C5D13F67666666666605C0C464D7D52266D33F64F581157EBA05C031C50911E5B1D43F83C4544C471306C0DBB47F4B01A3D53F0A9AA9233D6F06C086ABD8665735D63FCDCCCCCCCCCC06C04D6266666666D63F90FFEF755C2A07C088ABD8665735D63F16D5444D528607C0DDB47F4B01A3D53F36A417841BDF07C032C50911E5B1D43F33333333333308C0C664D7D52266D33F580B5D02298108C01C2FF0C767C5D13FA2BBC475A7C708C023E57E8FAAADCF3F33D3CAC5790509C081E00359C345CB3FE8B98727913909C03C5E66666666C63FF605EE6E096309C0656EAD74EB24C13FECC33CF62C8109C0DBF8000FB030B73FC1E2A7B9779309C01990CC48EA63A73F9A999999999909C07F72B0CB095930BDC1E2A7B9779309C051D1CC48EA63A7BFECC33CF62C8109C08219010FB030B7BFF605EE6E096309C0BE7EAD74EB24C1BFE9B98727913909C08C6E66666666C6BF34D3CAC5790509C0D8F00359C345CBBFA2BBC475A7C708C07FF57E8FAAADCFBF580B5D02298108C04937F0C767C5D1BF34333333333308C0F46CD7D52266D3BF37A417841BDF07C061CD0911E5B1D4BF17D5444D528607C00BBD7F4B01A3D5BF90FFEF755C2A07C0B7B3D8665735D6BFCDCCCCCCCCCC06C07F6A66666666D6BF0A9AA9233D6F06C0B9B3D8665735D6BF84C4544C471306C00EBD7F4B01A3D5BF64F581157EBA05C063CD0911E5B1D4BF67666666666605C0F96CD7D52266D3BF428E3C97701805C04D37F0C767C5D1BFF8DDD423F2D104C086F57E8FAAADCFBF67C6CED31F9404C0E4F00359C345CBBFB2DF1172086004C0A06E66666666C6BFA493AB2A903604C0CD7EAD74EB24C1BFAFD55CA36C1804C0AD19010FB030B7BFD9B6F1DF210604C093D1CC48EA63A7BF00000000000004C04F241D2D7B6830BDFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,3,x'0001FFFFFFFF666666666666E6BF7F6A66666666D6BF00000000000090BC4D6266666666D63F7C03000000010000003100000000000000000090BC4F241D2D7B6830BDE663DBC67F8768BFEB8FCC48EA63A73F33AED55CA36C88BFC8F8000FB030B73FC7D1C95515489BBF5E6EAD74EB24C13F42EC77841C02A8BF315E66666666C63FCCCCD879FA83B2BF78E00359C345CB3FF4BE9B7A443EBABF1DE57E8FAAADCF3F1DE4C8730987C1BF182FF0C767C5D13F646666666666C6BFC464D7D52266D33F39561F58E1A7CBBF31C50911E5B1D43F1924A6623A9AD0BFDBB47F4B01A3D53F4DD04C1DE979D3BF86ABD8665735D63F656666666666D6BF4D6266666666D63F7BFC7FAFE352D9BF88ABD8665735D63FB0A8266A9232DCBFDDB47F4B01A3D53FAF21BD20DCF8DEBF32C50911E5B1D43FCBCCCCCCCCCCE0BFC664D7D52266D33F5D2D7409A404E2BF1C2FF0C767C5D13F87EE12D79D1EE3BF23E57E8FAAADCF3FCC4C2B17E715E4BF81E00359C345CB3FA2E71E9E44E6E4BF3C5E66666666C63FD817B8BB258CE5BF656EAD74EB24C13FAE0FF3D8B304E6BFDBF8000FB030B73F038B9FE6DE4DE6BF1990CC48EA63A73F666666666666E6BF7F72B0CB095930BD048B9FE6DE4DE6BF51D1CC48EA63A7BFAE0FF3D8B304E6BF8219010FB030B7BFD917B8BB258CE5BFBE7EAD74EB24C1BFA4E71E9E44E6E4BF8C6E66666666C6BFCE4C2B17E715E4BFD8F00359C345CBBF89EE12D79D1EE3BF7FF57E8FAAADCFBF612D7409A404E2BF4937F0C767C5D1BFCFCCCCCCCCCCE0BFF46CD7D52266D3BFB521BD20DCF8DEBF61CD0911E5B1D4BFB9A8266A9232DCBF0BBD7F4B01A3D5BF81FC7FAFE352D9BFB7B3D8665735D6BF6A6666666666D6BF7F6A66666666D6BF53D04C1DE979D3BFB9B3D8665735D6BF1F24A6623A9AD0BF0EBD7F4B01A3D5BF3C561F58E1A7CBBF63CD0911E5B1D4BF736666666666C6BFF96CD7D52266D3BF24E4C8730987C1BF4D37F0C767C5D1BF02BF9B7A443EBABF86F57E8FAAADCFBFDCCCD879FA83B2BFE4F00359C345CBBF5EEC77841C02A8BFA06E66666666C6BFE9D1C95515489BBFCD7EAD74EB24C1BF8DAED55CA36C88BFAD19010FB030B7BF1A64DBC67F8768BF93D1CC48EA63A7BF00000000000090BC4F241D2D7B6830BDFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,4,x'0001FFFFFFFF666666666666E6BF7F6A66666666D6BF00000000000090BC4D6266666666D63F7C03000000010000003100000000000000000090BC4F241D2D7B6830BDE663DBC67F8768BFEB8FCC48EA63A73F33AED55CA36C88BFC8F8000FB030B73FC7D1C95515489BBF5E6EAD74EB24C13F42EC77841C02A8BF315E66666666C63FCCCCD879FA83B2BF78E00359C345CB3FF4BE9B7A443EBABF1DE57E8FAAADCF3F1DE4C8730987C1BF182FF0C767C5D13F646666666666C6BFC464D7D52266D33F39561F58E1A7CBBF31C50911E5B1D43F1924A6623A9AD0BFDBB47F4B01A3D53F4DD04C1DE979D3BF86ABD8665735D63F656666666666D6BF4D6266666666D63F7BFC7FAFE352D9BF88ABD8665735D63FB0A8266A9232DCBFDDB47F4B01A3D53FAF21BD20DCF8DEBF32C50911E5B1D43FCBCCCCCCCCCCE0BFC664D7D52266D33F5D2D7409A404E2BF1C2FF0C767C5D13F87EE12D79D1EE3BF23E57E8FAAADCF3FCC4C2B17E715E4BF81E00359C345CB3FA2E71E9E44E6E4BF3C5E66666666C63FD817B8BB258CE5BF656EAD74EB24C13FAE0FF3D8B304E6BFDBF8000FB030B73F038B9FE6DE4DE6BF1990CC48EA63A73F666666666666E6BF7F72B0CB095930BD048B9FE6DE4DE6BF51D1CC48EA63A7BFAE0FF3D8B304E6BF8219010FB030B7BFD917B8BB258CE5BFBE7EAD74EB24C1BFA4E71E9E44E6E4BF8C6E66666666C6BFCE4C2B17E715E4BFD8F00359C345CBBF89EE12D79D1EE3BF7FF57E8FAAADCFBF612D7409A404E2BF4937F0C767C5D1BFCFCCCCCCCCCCE0BFF46CD7D52266D3BFB521BD20DCF8DEBF61CD0911E5B1D4BFB9A8266A9232DCBF0BBD7F4B01A3D5BF81FC7FAFE352D9BFB7B3D8665735D6BF6A6666666666D6BF7F6A66666666D6BF53D04C1DE979D3BFB9B3D8665735D6BF1F24A6623A9AD0BF0EBD7F4B01A3D5BF3C561F58E1A7CBBF63CD0911E5B1D4BF736666666666C6BFF96CD7D52266D3BF24E4C8730987C1BF4D37F0C767C5D1BF02BF9B7A443EBABF86F57E8FAAADCFBFDCCCD879FA83B2BFE4F00359C345CBBF5EEC77841C02A8BFA06E66666666C6BFE9D1C95515489BBFCD7EAD74EB24C1BF8DAED55CA36C88BFAD19010FB030B7BF1A64DBC67F8768BF93D1CC48EA63A7BF00000000000090BC4F241D2D7B6830BDFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,5,x'0001FFFFFFFF666666666666E6BF7F6A66666666D6BF00000000000090BC4D6266666666D63F7C03000000010000003100000000000000000090BC4F241D2D7B6830BDE663DBC67F8768BFEB8FCC48EA63A73F33AED55CA36C88BFC8F8000FB030B73FC7D1C95515489BBF5E6EAD74EB24C13F42EC77841C02A8BF315E66666666C63FCCCCD879FA83B2BF78E00359C345CB3FF4BE9B7A443EBABF1DE57E8FAAADCF3F1DE4C8730987C1BF182FF0C767C5D13F646666666666C6BFC464D7D52266D33F39561F58E1A7CBBF31C50911E5B1D43F1924A6623A9AD0BFDBB47F4B01A3D53F4DD04C1DE979D3BF86ABD8665735D63F656666666666D6BF4D6266666666D63F7BFC7FAFE352D9BF88ABD8665735D63FB0A8266A9232DCBFDDB47F4B01A3D53FAF21BD20DCF8DEBF32C50911E5B1D43FCBCCCCCCCCCCE0BFC664D7D52266D33F5D2D7409A404E2BF1C2FF0C767C5D13F87EE12D79D1EE3BF23E57E8FAAADCF3FCC4C2B17E715E4BF81E00359C345CB3FA2E71E9E44E6E4BF3C5E66666666C63FD817B8BB258CE5BF656EAD74EB24C13FAE0FF3D8B304E6BFDBF8000FB030B73F038B9FE6DE4DE6BF1990CC48EA63A73F666666666666E6BF7F72B0CB095930BD048B9FE6DE4DE6BF51D1CC48EA63A7BFAE0FF3D8B304E6BF8219010FB030B7BFD917B8BB258CE5BFBE7EAD74EB24C1BFA4E71E9E44E6E4BF8C6E66666666C6BFCE4C2B17E715E4BFD8F00359C345CBBF89EE12D79D1EE3BF7FF57E8FAAADCFBF612D7409A404E2BF4937F0C767C5D1BFCFCCCCCCCCCCE0BFF46CD7D52266D3BFB521BD20DCF8DEBF61CD0911E5B1D4BFB9A8266A9232DCBF0BBD7F4B01A3D5BF81FC7FAFE352D9BFB7B3D8665735D6BF6A6666666666D6BF7F6A66666666D6BF53D04C1DE979D3BFB9B3D8665735D6BF1F24A6623A9AD0BF0EBD7F4B01A3D5BF3C561F58E1A7CBBF63CD0911E5B1D4BF736666666666C6BFF96CD7D52266D3BF24E4C8730987C1BF4D37F0C767C5D1BF02BF9B7A443EBABF86F57E8FAAADCFBFDCCCD879FA83B2BFE4F00359C345CBBF5EEC77841C02A8BFA06E66666666C6BFE9D1C95515489BBFCD7EAD74EB24C1BF8DAED55CA36C88BFAD19010FB030B7BF1A64DBC67F8768BF93D1CC48EA63A7BF00000000000090BC4F241D2D7B6830BDFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,6,x'0001FFFFFFFFB81E85EB51B8E2BF6BBC1E85EB51D0BF52B81E85EB51B8BFE4A547E17A14CE3F7C0200000002000000B81E85EB51B8E2BF6BBC1E85EB51D0BF52B81E85EB51B8BFE4A547E17A14CE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,7,x'0001FFFFFFFF9A999999999909C07F6A66666666D6BF00000000000004C04D6266666666D63F7C03000000010000003100000000000000000004C04F241D2D7B6830BDD9B6F1DF210604C0EB8FCC48EA63A73FAED55CA36C1804C0C8F8000FB030B73FA493AB2A903604C05E6EAD74EB24C13FB1DF1172086004C0315E66666666C63F67C6CED31F9404C078E00359C345CB3FF8DDD423F2D104C01DE57E8FAAADCF3F428E3C97701805C0182FF0C767C5D13F67666666666605C0C464D7D52266D33F64F581157EBA05C031C50911E5B1D43F83C4544C471306C0DBB47F4B01A3D53F0A9AA9233D6F06C086ABD8665735D63FCDCCCCCCCCCC06C04D6266666666D63F90FFEF755C2A07C088ABD8665735D63F16D5444D528607C0DDB47F4B01A3D53F36A417841BDF07C032C50911E5B1D43F33333333333308C0C664D7D52266D33F580B5D02298108C01C2FF0C767C5D13FA2BBC475A7C708C023E57E8FAAADCF3F33D3CAC5790509C081E00359C345CB3FE8B98727913909C03C5E66666666C63FF605EE6E096309C0656EAD74EB24C13FECC33CF62C8109C0DBF8000FB030B73FC1E2A7B9779309C01990CC48EA63A73F9A999999999909C07F72B0CB095930BDC1E2A7B9779309C051D1CC48EA63A7BFECC33CF62C8109C08219010FB030B7BFF605EE6E096309C0BE7EAD74EB24C1BFE9B98727913909C08C6E66666666C6BF34D3CAC5790509C0D8F00359C345CBBFA2BBC475A7C708C07FF57E8FAAADCFBF580B5D02298108C04937F0C767C5D1BF34333333333308C0F46CD7D52266D3BF37A417841BDF07C061CD0911E5B1D4BF17D5444D528607C00BBD7F4B01A3D5BF90FFEF755C2A07C0B7B3D8665735D6BFCDCCCCCCCCCC06C07F6A66666666D6BF0A9AA9233D6F06C0B9B3D8665735D6BF84C4544C471306C00EBD7F4B01A3D5BF64F581157EBA05C063CD0911E5B1D4BF67666666666605C0F96CD7D52266D3BF428E3C97701805C04D37F0C767C5D1BFF8DDD423F2D104C086F57E8FAAADCFBF67C6CED31F9404C0E4F00359C345CBBFB2DF1172086004C0A06E66666666C6BFA493AB2A903604C0CD7EAD74EB24C1BFAFD55CA36C1804C0AD19010FB030B7BFD9B6F1DF210604C093D1CC48EA63A7BF00000000000004C04F241D2D7B6830BDFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,8,x'0001FFFFFFFF9A999999999909C07F6A66666666D6BF00000000000004C04D6266666666D63F7C03000000010000003100000000000000000004C04F241D2D7B6830BDD9B6F1DF210604C0EB8FCC48EA63A73FAED55CA36C1804C0C8F8000FB030B73FA493AB2A903604C05E6EAD74EB24C13FB1DF1172086004C0315E66666666C63F67C6CED31F9404C078E00359C345CB3FF8DDD423F2D104C01DE57E8FAAADCF3F428E3C97701805C0182FF0C767C5D13F67666666666605C0C464D7D52266D33F64F581157EBA05C031C50911E5B1D43F83C4544C471306C0DBB47F4B01A3D53F0A9AA9233D6F06C086ABD8665735D63FCDCCCCCCCCCC06C04D6266666666D63F90FFEF755C2A07C088ABD8665735D63F16D5444D528607C0DDB47F4B01A3D53F36A417841BDF07C032C50911E5B1D43F33333333333308C0C664D7D52266D33F580B5D02298108C01C2FF0C767C5D13FA2BBC475A7C708C023E57E8FAAADCF3F33D3CAC5790509C081E00359C345CB3FE8B98727913909C03C5E66666666C63FF605EE6E096309C0656EAD74EB24C13FECC33CF62C8109C0DBF8000FB030B73FC1E2A7B9779309C01990CC48EA63A73F9A999999999909C07F72B0CB095930BDC1E2A7B9779309C051D1CC48EA63A7BFECC33CF62C8109C08219010FB030B7BFF605EE6E096309C0BE7EAD74EB24C1BFE9B98727913909C08C6E66666666C6BF34D3CAC5790509C0D8F00359C345CBBFA2BBC475A7C708C07FF57E8FAAADCFBF580B5D02298108C04937F0C767C5D1BF34333333333308C0F46CD7D52266D3BF37A417841BDF07C061CD0911E5B1D4BF17D5444D528607C00BBD7F4B01A3D5BF90FFEF755C2A07C0B7B3D8665735D6BFCDCCCCCCCCCC06C07F6A66666666D6BF0A9AA9233D6F06C0B9B3D8665735D6BF84C4544C471306C00EBD7F4B01A3D5BF64F581157EBA05C063CD0911E5B1D4BF67666666666605C0F96CD7D52266D3BF428E3C97701805C04D37F0C767C5D1BFF8DDD423F2D104C086F57E8FAAADCFBF67C6CED31F9404C0E4F00359C345CBBFB2DF1172086004C0A06E66666666C6BFA493AB2A903604C0CD7EAD74EB24C1BFAFD55CA36C1804C0AD19010FB030B7BFD9B6F1DF210604C093D1CC48EA63A7BF00000000000004C04F241D2D7B6830BDFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,9,x'0001FFFFFFFFC3F5285C8FC208C08D97C2F5285CCFBFD7A3703D0AD704C02B87C2F5285CCF3F7C0200000002000000C3F5285C8FC208C08D97C2F5285CCFBFD7A3703D0AD704C02B87C2F5285CCF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,10,x'0001FFFFFFFFCDCCCCCCCCCC16C07F6A66666666D6BF01000000000014C04D6266666666D63F7C03000000010000003100000001000000000014C04F241D2D7B6830BD6DDBF8EF100314C0EB8FCC48EA63A73FD86AAE51360C14C0C8F8000FB030B73FD2C95515481B14C05E6EAD74EB24C13FD9EF0839043014C0315E66666666C63F3463E7E90F4A14C078E00359C345CB3FFC6EEA11F96814C01DE57E8FAAADCF3F22479E4B388C14C0182FF0C767C5D13F3433333333B314C0C464D7D52266D33FB2FAC00A3FDD14C031C50911E5B1D43F42622AA6A30915C0DBB47F4B01A3D53F05CDD4919E3715C086ABD8665735D63F67666666666615C04D6266666666D63FC8FFF73A2E9515C088ABD8665735D63F8C6AA22629C315C0DDB47F4B01A3D53F1CD20BC28DEF15C032C50911E5B1D43F9A999999991916C0C664D7D52266D33FAC852E81944016C01C2FF0C767C5D13FD25DE2BAD36316C023E57E8FAAADCF3F9A69E5E2BC8216C081E00359C345CB3FF5DCC393C89C16C03C5E66666666C63FFC0277B784B116C0656EAD74EB24C13FF6611E7B96C016C0DBF8000FB030B73F61F1D3DCBBC916C01990CC48EA63A73FCDCCCCCCCCCC16C07F72B0CB095930BD61F1D3DCBBC916C051D1CC48EA63A7BFF6611E7B96C016C08219010FB030B7BFFC0277B784B116C0BE7EAD74EB24C1BFF5DCC393C89C16C08C6E66666666C6BF9A69E5E2BC8216C0D8F00359C345CBBFD25DE2BAD36316C07FF57E8FAAADCFBFAC852E81944016C04937F0C767C5D1BF9A999999991916C0F46CD7D52266D3BF1CD20BC28DEF15C061CD0911E5B1D4BF8C6AA22629C315C00BBD7F4B01A3D5BFC8FFF73A2E9515C0B7B3D8665735D6BF67666666666615C07F6A66666666D6BF06CDD4919E3715C0B9B3D8665735D6BF42622AA6A30915C00EBD7F4B01A3D5BFB2FAC00A3FDD14C063CD0911E5B1D4BF3433333333B314C0F96CD7D52266D3BF22479E4B388C14C04D37F0C767C5D1BFFD6EEA11F96814C086F57E8FAAADCFBF3463E7E90F4A14C0E4F00359C345CBBFD9EF0839043014C0A06E66666666C6BFD2C95515481B14C0CD7EAD74EB24C1BFD86AAE51360C14C0AD19010FB030B7BF6DDBF8EF100314C093D1CC48EA63A7BF01000000000014C04F241D2D7B6830BDFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,11,x'0001FFFFFFFFCDCCCCCCCCCC16C07F6A66666666D6BF01000000000014C04D6266666666D63F7C03000000010000003100000001000000000014C04F241D2D7B6830BD6DDBF8EF100314C0EB8FCC48EA63A73FD86AAE51360C14C0C8F8000FB030B73FD2C95515481B14C05E6EAD74EB24C13FD9EF0839043014C0315E66666666C63F3463E7E90F4A14C078E00359C345CB3FFC6EEA11F96814C01DE57E8FAAADCF3F22479E4B388C14C0182FF0C767C5D13F3433333333B314C0C464D7D52266D33FB2FAC00A3FDD14C031C50911E5B1D43F42622AA6A30915C0DBB47F4B01A3D53F05CDD4919E3715C086ABD8665735D63F67666666666615C04D6266666666D63FC8FFF73A2E9515C088ABD8665735D63F8C6AA22629C315C0DDB47F4B01A3D53F1CD20BC28DEF15C032C50911E5B1D43F9A999999991916C0C664D7D52266D33FAC852E81944016C01C2FF0C767C5D13FD25DE2BAD36316C023E57E8FAAADCF3F9A69E5E2BC8216C081E00359C345CB3FF5DCC393C89C16C03C5E66666666C63FFC0277B784B116C0656EAD74EB24C13FF6611E7B96C016C0DBF8000FB030B73F61F1D3DCBBC916C01990CC48EA63A73FCDCCCCCCCCCC16C07F72B0CB095930BD61F1D3DCBBC916C051D1CC48EA63A7BFF6611E7B96C016C08219010FB030B7BFFC0277B784B116C0BE7EAD74EB24C1BFF5DCC393C89C16C08C6E66666666C6BF9A69E5E2BC8216C0D8F00359C345CBBFD25DE2BAD36316C07FF57E8FAAADCFBFAC852E81944016C04937F0C767C5D1BF9A999999991916C0F46CD7D52266D3BF1CD20BC28DEF15C061CD0911E5B1D4BF8C6AA22629C315C00BBD7F4B01A3D5BFC8FFF73A2E9515C0B7B3D8665735D6BF67666666666615C07F6A66666666D6BF06CDD4919E3715C0B9B3D8665735D6BF42622AA6A30915C00EBD7F4B01A3D5BFB2FAC00A3FDD14C063CD0911E5B1D4BF3433333333B314C0F96CD7D52266D3BF22479E4B388C14C04D37F0C767C5D1BFFD6EEA11F96814C086F57E8FAAADCFBF3463E7E90F4A14C0E4F00359C345CBBFD9EF0839043014C0A06E66666666C6BFD2C95515481B14C0CD7EAD74EB24C1BFD86AAE51360C14C0AD19010FB030B7BF6DDBF8EF100314C093D1CC48EA63A7BF01000000000014C04F241D2D7B6830BDFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100105,12,x'0001FFFFFFFFFCA9F1D24D6216C0E6D076BE9F1ACFBF068195438B6C14C0D34D0E2DB29DCF3F7C0200000002000000FCA9F1D24D6216C0E6D076BE9F1ACFBF068195438B6C14C0D34D0E2DB29DCF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,1,x'0001FFFFFFFF00000000000014C0666666666666D6BF34333333333311C0666666666666D63F7C03000000010000003100000034333333333311C0A34DE9AD68B598BCA00E2C23443611C0B0B0CC48EA63A73F0B9EE184693F11C02A09010FB030B73F05FD88487B4E11C08F76AD74EB24C13F0C233C6C376311C0626666666666C63F67961A1D437D11C0AAE80359C345CB3F2FA21D452C9C11C04EED7E8FAAADCF3F557AD17E6BBF11C03133F0C767C5D13F6766666666E611C0DC68D7D52266D33FE52DF43D721012C049C90911E5B1D43F75955DD9D63C12C0F4B87F4B01A3D53F380008C5D16A12C09FAFD8665735D63F9A999999999912C0666666666666D63FFB322B6E61C812C0A0AFD8665735D63FBF9DD5595CF612C0F5B87F4B01A3D53F4F053FF5C02213C04BC90911E5B1D43FCDCCCCCCCC4C13C0DF68D7D52266D33FDFB861B4C77313C03533F0C767C5D13F049115EE069713C054ED7E8FAAADCF3FCD9C1816F0B513C0B2E80359C345CB3F2810F7C6FBCF13C06D6666666666C63F2F36AAEAB7E413C09676AD74EB24C13F299551AEC9F313C03D09010FB030B73F94240710EFFC13C0DDB0CC48EA63A73F00000000000014C03AFA6E820E88A23C94240710EFFC13C08DB0CC48EA63A7BF299551AEC9F313C02009010FB030B7BF2F36AAEAB7E413C08D76AD74EB24C1BF2810F7C6FBCF13C05B6666666666C6BFCD9C1816F0B513C0A7E80359C345CBBF059115EE069713C04EED7E8FAAADCFBFE0B861B4C77313C03033F0C767C5D1BFCDCCCCCCCC4C13C0DB68D7D52266D3BF4F053FF5C02213C048C90911E5B1D4BFBF9DD5595CF612C0F3B87F4B01A3D5BFFB322B6E61C812C09FAFD8665735D6BF9A999999999912C0666666666666D6BF390008C5D16A12C0A0AFD8665735D6BF75955DD9D63C12C0F5B87F4B01A3D5BFE52DF43D721012C04BC90911E5B1D4BF6766666666E611C0E168D7D52266D3BF557AD17E6BBF11C03433F0C767C5D1BF30A21D452C9C11C055ED7E8FAAADCFBF67961A1D437D11C0B2E80359C345CBBF0C233C6C376311C06F6666666666C6BF05FD88487B4E11C09C76AD74EB24C1BF0B9EE184693F11C04B09010FB030B7BFA00E2C23443611C0CEB0CC48EA63A7BF34333333333311C0A34DE9AD68B598BCFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,2,x'0001FFFFFFFF00000000000008C0676666666666D6BF0000000000000000676666666666D63F7C03000000010000000500000000000000000008C0676666666666D63F00000000000008C0676666666666D6BF0000000000000000676666666666D6BF0000000000000000676666666666D63F00000000000008C0676666666666D63FFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,3,x'0001FFFFFFFF9A999999999922C0676666666666D6BF33333333333319C0676666666666D63F7C0300000001000000050000009A999999999922C0676666666666D63F9A999999999922C0676666666666D6BF33333333333319C0676666666666D6BF33333333333319C0676666666666D63F9A999999999922C0676666666666D63FFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,4,x'0001FFFFFFFF0AD7A3703D8A22C0022B8716D9CEB7BF105839B4C8B621C07B14AE47E17AD43F7C02000000020000000AD7A3703D8A22C0022B8716D9CEB7BF105839B4C8B621C07B14AE47E17AD43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,5,x'0001FFFFFFFFC976BE9F1AEF21C07B14AE47E17AD4BF8195438B6CA720C07B14AE47E17AD43F7C0200000002000000C976BE9F1AEF21C07B14AE47E17AD4BF8195438B6CA720C07B14AE47E17AD43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,6,x'0001FFFFFFFFAC1C5A643BDF20C07B14AE47E17AD4BFC976BE9F1A2F1FC07B14AE47E17AD43F7C0200000002000000AC1C5A643BDF20C07B14AE47E17AD4BFC976BE9F1A2F1FC07B14AE47E17AD43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,7,x'0001FFFFFFFF3AB4C876BE9F1FC07B14AE47E17AD4BFAAF1D24D62101DC07B14AE47E17AD43F7C02000000020000003AB4C876BE9F1FC07B14AE47E17AD4BFAAF1D24D62101DC07B14AE47E17AD43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,8,x'0001FFFFFFFF1B2FDD2406811DC07B14AE47E17AD4BF8B6CE7FBA9F11AC07B14AE47E17AD43F7C02000000020000001B2FDD2406811DC07B14AE47E17AD4BF8B6CE7FBA9F11AC07B14AE47E17AD43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,9,x'0001FFFFFFFFE17A14AE47611BC07B14AE47E17AD4BF4AB81E85EB5119C0F6285C8FC2F5C83F7C0200000002000000E17A14AE47611BC07B14AE47E17AD4BF4AB81E85EB5119C0F6285C8FC2F5C83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,10,x'0001FFFFFFFF4AA028DF84DC13C089410007D8D3ABBFFE988BE9F16112C07F6AF058B42ED43F7C02000000020000004AA028DF84DC13C089410007D8D3ABBFFE988BE9F16112C07F6AF058B42ED43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,11,x'0001FFFFFFFFB07E099E26CA12C0C976821E0341D4BF7B10FF4C6B5511C0448B2C1F32E1A73F7C0200000002000000B07E099E26CA12C0C976821E0341D4BF7B10FF4C6B5511C0448B2C1F32E1A73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,12,x'0001FFFFFFFF4C277A32EBE407C0C976A227B34ECEBFC70BB900484E03C0CBA137FABF8DD53F7C02000000020000004C277A32EBE407C0C976A227B34ECEBFC70BB900484E03C0CBA137FABF8DD53FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,13,x'0001FFFFFFFFFCE96F5B477404C0CBA137FABF8DD5BF1303C4B9AE21FEBFCBA137FABF8DD53F7C0200000002000000FCE96F5B477404C0CBA137FABF8DD5BF1303C4B9AE21FEBFCBA137FABF8DD53FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,14,x'0001FFFFFFFF8981DE6DCA3400C0CBA137FABF8DD5BF2D32A1DEB4A2F5BFCBA137FABF8DD53F7C02000000020000008981DE6DCA3400C0CBA137FABF8DD5BF2D32A1DEB4A2F5BFCBA137FABF8DD53FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,15,x'0001FFFFFFFF98EE0E94B3EEF7BFCBA137FABF8DD5BF653BE62DA74FEABFCBA137FABF8DD53F7C020000000200000098EE0E94B3EEF7BFCBA137FABF8DD5BF653BE62DA74FEABFCBA137FABF8DD53FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,16,x'0001FFFFFFFF3AB4C198A4E7EEBFCBA137FABF8DD5BFDD24143DC9B3D2BFCBA137FABF8DD53F7C02000000020000003AB4C198A4E7EEBFCBA137FABF8DD5BFDD24143DC9B3D2BFCBA137FABF8DD53FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100106,17,x'0001FFFFFFFFDD24F8C461D3DBBFCBA137FABF8DD5BF3AB4D885CD148BBFDBF9467AEDB3B53F7C0200000002000000DD24F8C461D3DBBFCBA137FABF8DD5BF3AB4D885CD148BBFDBF9467AEDB3B53FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,1,x'0001FFFFFFFF0000000000001AC0000000000000F0BF0000000000001AC0000000000000F03F7C02000000020000000000000000001AC0000000000000F03F0000000000001AC0000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,2,x'0001FFFFFFFF00000000000024C0000000000000F0BF00000000000024C0000000000000F03F7C020000000200000000000000000024C0000000000000F03F00000000000024C0000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,3,x'0001FFFFFFFF0000000000000CC0000000000000F0BF0000000000000CC0000000000000F03F7C02000000020000000000000000000CC0000000000000F03F0000000000000CC0000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,4,x'0001FFFFFFFF0000000000000000000000000000F0BF0000000000000000000000000000F03F7C02000000020000000000000000000000000000000000F03F0000000000000000000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,5,x'0001FFFFFFFFCDCCCCCCCCCC23C0000000000000E0BF6766666666661AC0000000000000E03F7C030000000100000005000000CDCCCCCCCCCC23C0000000000000E03FCDCCCCCCCCCC23C0000000000000E0BF6766666666661AC0000000000000E0BF6766666666661AC0000000000000E03FCDCCCCCCCCCC23C0000000000000E03FFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,6,x'0001FFFFFFFF3333333333330BC0000000000000E0BF9A9999999999B9BF000000000000E03F7C0300000001000000050000003333333333330BC0000000000000E03F3333333333330BC0000000000000E0BF9A9999999999B9BF000000000000E0BF9A9999999999B9BF000000000000E03F3333333333330BC0000000000000E03FFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,7,x'0001FFFFFFFF2F5DFE88C8030BC0BD74FBEA8B71C73F73E8E2F14BAA08C0426059AEAA84DE3F7C02000000020000002F5DFE88C8030BC0BD74FBEA8B71C73F73E8E2F14BAA08C0426059AEAA84DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,8,x'0001FFFFFFFF2F5DFE88C8030BC08D973A29BF32D6BF35DE0B4EDB6C04C0426059AEAA84DE3F7C02000000020000002F5DFE88C8030BC08D973A29BF32D6BF35DE0B4EDB6C04C0426059AEAA84DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,9,x'0001FFFFFFFFFC29CB5595D007C0DF4F59AEAA84DEBFF8D334AA6A2F00C0426059AEAA84DE3F7C0200000002000000FC29CB5595D007C0DF4F59AEAA84DEBFF8D334AA6A2F00C0426059AEAA84DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,10,x'0001FFFFFFFF89C13968189103C0DF4F59AEAA84DEBF0AD74679DBDFF7BF426059AEAA84DE3F7C020000000200000089C13968189103C0DF4F59AEAA84DEBF0AD74679DBDFF7BF426059AEAA84DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,11,x'0001FFFFFFFF986EC5884FA7FEBFDF4F59AEAA84DEBF1F853163F4C9EEBF426059AEAA84DE3F7C0200000002000000986EC5884FA7FEBFDF4F59AEAA84DEBF1F853163F4C9EEBF426059AEAA84DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,12,x'0001FFFFFFFF1D5A17416E2CF6BFDF4F59AEAA84DEBF52B8AAA763A8DBBF426059AEAA84DE3F7C02000000020000001D5A17416E2CF6BFDF4F59AEAA84DEBF52B8AAA763A8DBBF426059AEAA84DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,13,x'0001FFFFFFFF6F12E9CBE85AEBBFDF4F59AEAA84DEBF1D5A34E0EE86BFBF77BE6B316B4FD03F7C02000000020000006F12E9CBE85AEBBFDF4F59AEAA84DEBF1D5A34E0EE86BFBF77BE6B316B4FD03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,14,x'0001FFFFFFFFF2D219794CCAD4BFDF4F59AEAA84DEBF1D5A34E0EE86BFBF75934CED199CD1BF7C0200000002000000F2D219794CCAD4BFDF4F59AEAA84DEBF1D5A34E0EE86BFBF75934CED199CD1BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,15,x'0001FFFFFFFF1924300BD0C223C04E6288217A8BC43F56EE52B5FA1E23C079E96ACC67C0DE3F7C02000000020000001924300BD0C223C04E6288217A8BC43F56EE52B5FA1E23C079E96ACC67C0DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,16,x'0001FFFFFFFF1924300BD0C223C0C520F40DC8A5D7BFC72B5D8C9E0F22C079E96ACC67C0DE3F7C02000000020000001924300BD0C223C0C520F40DC8A5D7BFC72B5D8C9E0F22C079E96ACC67C0DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,17,x'0001FFFFFFFF4280BFCDC5EB22C079E96ACC67C0DEBFAAD1F850BFFF20C079E96ACC67C0DE3F7C02000000020000004280BFCDC5EB22C079E96ACC67C0DEBFAAD1F850BFFF20C079E96ACC67C0DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,18,x'0001FFFFFFFFB2BDC9A469DC21C079E96ACC67C0DEBF351E0650C6E01FC079E96ACC67C0DE3F7C0200000002000000B2BDC9A469DC21C079E96ACC67C0DEBF351E0650C6E01FC079E96ACC67C0DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,19,x'0001FFFFFFFF23FBD37B0DCD20C079E96ACC67C0DEBF17991AFE0DC21DC079E96ACC67C0DE3F7C020000000200000023FBD37B0DCD20C079E96ACC67C0DEBF17991AFE0DC21DC079E96ACC67C0DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,20,x'0001FFFFFFFF0C42DF805C7A1FC079E96ACC67C0DEBFDDE451874FA21BC079E96ACC67C0DE3F7C02000000020000000C42DF805C7A1FC079E96ACC67C0DEBFDDE451874FA21BC079E96ACC67C0DE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,21,x'0001FFFFFFFFEEBCF32EA45B1DC079E96ACC67C0DEBFBFB79FE95F7A1AC0E6D0AA11B9A7CE3F7C0200000002000000EEBCF32EA45B1DC079E96ACC67C0DEBFBFB79FE95F7A1AC0E6D0AA11B9A7CE3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,22,x'0001FFFFFFFFCF3708DDEB3C1BC079E96ACC67C0DEBFBFB79FE95F7A1AC079E9E295A897D2BF7C0200000002000000CF3708DDEB3C1BC079E96ACC67C0DEBFBFB79FE95F7A1AC079E9E295A897D2BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,23,x'0001FFFFFFFF766DB317DAF115C02E7BA7B8ABF4DEBF80BBA877E80312C024A403486EEADF3F7C03000000010000003100000080BBA877E80312C02D1E85EB51B87E3F2A83B508360812C0E683C9442F55B23F2D1EBEE20B1512C06774F0937A3BC13F2378F8CC312A12C0ADB5F7B51605C93F24E231254B4712C04DDCD8C7A732D03FEBBC9075D86B12C02363E923EB9DD33F89C0E2A2399712C0995363945BB5D63F905FEAA9B0C812C07D8D83696E6BD93FFE67ABDF64FF12C0EE39716F43B4DB3F153879A6663A13C0FED907F3D885DD3F1F728987B37813C05479AD9637D8DE3FB3CF159F3AB913C08329373795A5DF3F7B14AE47E1FA13C024A403486EEADF3F435946F0873C14C08429373795A5DF3FD6B6D2070F7D14C05779AD9637D8DE3FE1F0E2E85BBB14C000DA07F3D885DD3FF8C0B0AF5DF614C0F139716F43B4DB3F66C971E5112D15C0828D83696E6BD93F6D6879EC885E15C09D5363945BB5D63F0B6CCB19EA8915C02A63E923EB9DD33FD2462A6A77AE15C054DCD8C7A732D03FD3B063C290CB15C0B7B5F7B51605C93FC90A9EACB6E015C07474F0937A3BC13FCCA5A6868CED15C00584C9442F55B23F766DB317DAF115C0881F85EB51B87E3FCCA5A6868CED15C0ECBFB10E4AFCACBFC90A9EACB6E015C0E84470EAEA9FBEBFD3B063C290CB15C0BF633F979119C7BFD2462A6A77AE15C0A466F970CA79CEBF0B6CCB19EA8915C02B3A8D9428A8D2BF6D6879EC885E15C0A42A070599BFD5BF66C971E5112D15C0866427DAAB75D8BFF9C0B0AF5DF614C0F61015E080BEDABFE1F0E2E85BBB14C007B1AB631690DCBFD7B6D2070F7D14C05E50510775E2DDBF435946F0873C14C08D00DBA7D2AFDEBF7B14AE47E1FA13C02E7BA7B8ABF4DEBFB3CF159F3AB913C08E00DBA7D2AFDEBF20728987B37813C06250510775E2DDBF153879A6663A13C00AB1AB631690DCBFFE67ABDF64FF12C0FE1015E080BEDABF905FEAA9B0C812C08A6427DAAB75D8BF89C0E2A2399712C0A92A070599BFD5BFEBBC9075D86B12C0343A8D9428A8D2BF24E231254B4712C0BF66F970CA79CEBF2378F8CC312A12C0D4633F979119C7BF2D1EBEE20B1512C0254570EAEA9FBEBF2A83B508360812C048C0B10E4AFCACBF80BBA877E80312C02D1E85EB51B87E3FFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,24,x'0001FFFFFFFF1D9E27FE8DAE15C0A8C6F3C4BFD1C5BF06950B35A54413C021B046AFACB5DB3F7C02000000020000001D9E27FE8DAE15C0A8C6F3C4BFD1C5BF06950B35A54413C021B046AFACB5DB3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100107,25,x'0001FFFFFFFF98EAFE92329714C015AEC3FA355FDBBF4622B34C003D12C00E2D02EA3969C43F7C020000000200000098EAFE92329714C015AEC3FA355FDBBF4622B34C003D12C00E2D02EA3969C43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100108,1,x'0001FFFFFFFF713D0AD7A37004C06DE7FBA9F1D2E1BF00000000000000C015AE47E17A14E23F7C0200000003000000713D0AD7A37004C015AE47E17A14E23F00000000000000C00000000000000000713D0AD7A37004C06DE7FBA9F1D2E1BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100108,2,x'0001FFFFFFFF560E2DB29D6F12C0DBF97E6ABC74E3BF00000000000010C0333333333333E33F7C0200000003000000560E2DB29D6F12C0DBF97E6ABC74E3BF00000000000010C0000000000000000067666666666612C0333333333333E33FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100108,3,x'0001FFFFFFFF0700000000001CC0FFFFFFFFFFFFEFBF00000000000018C0FFFFFFFFFFFFEF3F7C02000000210000000700000000001CC0FFFFFFFFFFFFEF3F36590F65A19B1BC02A25D1A38DD8EF3FD6B21C3E3A381BC0B85CF7CF9762EF3F15A6129DBFD61AC0E52DC656419FEE3F6F1595D521781AC0548D32CF6B90ED3FA0907F2C4A1D1AC0C1BD80F1B238EC3FEB32CA9818C719C0B4A10E29669BEA3F48DC5E9B617619C05317156B80BCE83F89183033EC2B19C0DF3B7F669EA0E63F1A5D9DF26FE818C0E71D0925F34CE43FCD2BDE3A93AC18C0D868AE393BC7E13F4BE8CFA1E97818C058F606385D2BDE3F58AE1986F24D18C078A9AEA6E27DD83F453A27D5172C18C0179FD52E0694D23F6A140106AD1318C023A6693CB8F8C83F5CDB854BEE0418C047B429BCA617B93F00000000000018C0065C143326A6913C5BDB854BEE0418C03EB429BCA617B9BF6A140106AD1318C01FA6693CB8F8C8BF453A27D5172C18C0159FD52E0694D2BF58AE1986F24D18C077A9AEA6E27DD8BF4BE8CFA1E97818C05BF606385D2BDEBFCD2BDE3A93AC18C0D868AE393BC7E1BF1A5D9DF26FE818C0E81D0925F34CE4BF89183033EC2B19C0E03B7F669EA0E6BF48DC5E9B617619C05317156B80BCE8BFEA32CA9818C719C0B5A10E29669BEABFA0907F2C4A1D1AC0C1BD80F1B238ECBF6E1595D521781AC0558D32CF6B90EDBF14A6129DBFD61AC0E62DC656419FEEBFD5B21C3E3A381BC0B85CF7CF9762EFBF35590F65A19B1BC02925D1A38DD8EFBF0600000000001CC0FFFFFFFFFFFFEFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100108,4,x'0001FFFFFFFF00000000000018C00000000000000000000000000000000000000000000000007C020000000200000000000000000018C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100109,1,x'0001FFFFFFFF0700000000001CC0FFFFFFFFFFFFEFBF00000000000018C0FFFFFFFFFFFFEF3F7C02000000210000000700000000001CC0FFFFFFFFFFFFEF3F36590F65A19B1BC02A25D1A38DD8EF3FD6B21C3E3A381BC0B85CF7CF9762EF3F15A6129DBFD61AC0E52DC656419FEE3F6F1595D521781AC0548D32CF6B90ED3FA0907F2C4A1D1AC0C1BD80F1B238EC3FEB32CA9818C719C0B4A10E29669BEA3F48DC5E9B617619C05317156B80BCE83F89183033EC2B19C0DF3B7F669EA0E63F1A5D9DF26FE818C0E71D0925F34CE43FCD2BDE3A93AC18C0D868AE393BC7E13F4BE8CFA1E97818C058F606385D2BDE3F58AE1986F24D18C078A9AEA6E27DD83F453A27D5172C18C0179FD52E0694D23F6A140106AD1318C023A6693CB8F8C83F5CDB854BEE0418C047B429BCA617B93F00000000000018C0065C143326A6913C5BDB854BEE0418C03EB429BCA617B9BF6A140106AD1318C01FA6693CB8F8C8BF453A27D5172C18C0159FD52E0694D2BF58AE1986F24D18C077A9AEA6E27DD8BF4BE8CFA1E97818C05BF606385D2BDEBFCD2BDE3A93AC18C0D868AE393BC7E1BF1A5D9DF26FE818C0E81D0925F34CE4BF89183033EC2B19C0E03B7F669EA0E6BF48DC5E9B617619C05317156B80BCE8BFEA32CA9818C719C0B5A10E29669BEABFA0907F2C4A1D1AC0C1BD80F1B238ECBF6E1595D521781AC0558D32CF6B90EDBF14A6129DBFD61AC0E62DC656419FEEBFD5B21C3E3A381BC0B85CF7CF9762EFBF35590F65A19B1BC02925D1A38DD8EFBF0600000000001CC0FFFFFFFFFFFFEFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100109,2,x'0001FFFFFFFF00000000000018C00000000000000000000000000000000000000000000000007C020000000200000000000000000018C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100110,1,x'0001FFFFFFFF00000000000014C0000000000000F0BF00000000000010C0000000000000F03F7C020000000300000000000000000014C0000000000000F03F00000000000010C0000000000000000000000000000014C0000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100110,2,x'0001FFFFFFFFFDFFFFFFFFFF1BC0FFFFFFFFFFFFEFBF00000000000018C0FFFFFFFFFFFFEF3F7C0200000021000000FDFFFFFFFFFF1BC0FFFFFFFFFFFFEF3F2C590F65A19B1BC02225D1A38DD8EF3FCDB21C3E3A381BC0AB5CF7CF9762EF3F0DA6129DBFD61AC0D22DC656419FEE3F681595D521781AC03C8D32CF6B90ED3F9A907F2C4A1D1AC0A6BD80F1B238EC3FE532CA9818C719C098A10E29669BEA3F44DC5E9B617619C03517156B80BCE83F85183033EC2B19C0C13B7F669EA0E63F175D9DF26FE818C0CA1D0925F34CE43FCB2BDE3A93AC18C0BD68AE393BC7E13F4AE8CFA1E97818C027F606385D2BDE3F57AE1986F24D18C053A9AEA6E27DD83F453A27D5172C18C0F89ED52E0694D23F6A140106AD1318C0F4A5693CB8F8C83F5BDB854BEE0418C017B429BCA617B93F00000000000018C0FCD175E6EC2CA7BC5BDB854BEE0418C02EB429BCA617B9BF6A140106AD1318C000A6693CB8F8C8BF453A27D5172C18C0FE9ED52E0694D2BF57AE1986F24D18C059A9AEA6E27DD8BF4AE8CFA1E97818C030F606385D2BDEBFCB2BDE3A93AC18C0C468AE393BC7E1BF175D9DF26FE818C0D01D0925F34CE4BF85183033EC2B19C0C33B7F669EA0E6BF44DC5E9B617619C03917156B80BCE8BFE632CA9818C719C09BA10E29669BEABF9A907F2C4A1D1AC0A8BD80F1B238ECBF681595D521781AC0408D32CF6B90EDBF0DA6129DBFD61AC0D52DC656419FEEBFCDB21C3E3A381BC0AB5CF7CF9762EFBF2D590F65A19B1BC02225D1A38DD8EFBFFDFFFFFFFFFF1BC0FFFFFFFFFFFFEFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100110,3,x'0001FFFFFFFF00000000000018C00000000000000000000000000000000000000000000000007C020000000200000000000000000018C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100111,1,x'0001FFFFFFFF00000000000018C00000000000000000000000000000000000000000000000007C020000000200000000000000000018C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100111,2,x'0001FFFFFFFFFBFFFFFFFFFF1BC0FFFFFFFFFFFFEFBF00000000000018C0FFFFFFFFFFFFEF3F7C0200000021000000FBFFFFFFFFFF1BC0FFFFFFFFFFFFEF3F2B590F65A19B1BC02125D1A38DD8EF3FCCB21C3E3A381BC0A95CF7CF9762EF3F0CA6129DBFD61AC0CF2DC656419FEE3F671595D521781AC0398D32CF6B90ED3F9A907F2C4A1D1AC0A3BD80F1B238EC3FE532CA9818C719C094A10E29669BEA3F43DC5E9B617619C03217156B80BCE83F85183033EC2B19C0BD3B7F669EA0E63F175D9DF26FE818C0C61D0925F34CE43FCB2BDE3A93AC18C0BA68AE393BC7E13F49E8CFA1E97818C023F606385D2BDE3F57AE1986F24D18C04CA9AEA6E27DD83F453A27D5172C18C0F49ED52E0694D23F6A140106AD1318C0F4A5693CB8F8C83F5BDB854BEE0418C007B429BCA617B93F00000000000018C0FCD175E6EC2CA7BC5BDB854BEE0418C01EB429BCA617B9BF6A140106AD1318C000A6693CB8F8C8BF443A27D5172C18C0FA9ED52E0694D2BF57AE1986F24D18C052A9AEA6E27DD8BF49E8CFA1E97818C022F606385D2BDEBFCA2BDE3A93AC18C0BA68AE393BC7E1BF175D9DF26FE818C0C91D0925F34CE4BF85183033EC2B19C0BE3B7F669EA0E6BF43DC5E9B617619C03217156B80BCE8BFE432CA9818C719C094A10E29669BEABF99907F2C4A1D1AC0A3BD80F1B238ECBF661595D521781AC03A8D32CF6B90EDBF0CA6129DBFD61AC0D12DC656419FEEBFCBB21C3E3A381BC0A85CF7CF9762EFBF2B590F65A19B1BC02125D1A38DD8EFBFFBFFFFFFFFFF1BC0FFFFFFFFFFFFEFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100111,3,x'0001FFFFFFFFF7FFFFFFFFFF07C0FFFFFFFFFFFFEFBF00000000000000C0FFFFFFFFFFFFEF3F7C0200000021000000F7FFFFFFFFFF07C0FFFFFFFFFFFFEF3F56B21ECA423707C02125D1A38DD8EF3F9765397C747006C0A95CF7CF9762EF3F184C253A7FAD05C0CF2DC656419FEE3FCD2A2AAB43F004C0398D32CF6B90ED3F3321FF58943A04C0A3BD80F1B238EC3FC9659431318E03C094A10E29669BEA3F87B8BD36C3EC02C03217156B80BCE83F0A316066D85702C0BD3B7F669EA0E63F2EBA3AE5DFD001C0C61D0925F34CE43F9657BC75265901C0BA68AE393BC7E13F93D09F43D3F100C023F606385D2BDE3FAE5C330CE59B00C04CA9AEA6E27DD83F89744EAA2F5800C0F49ED52E0694D23FD428020C5A2700C0F4A5693CB8F8C83FB7B60B97DC0900C007B429BCA617B93F00000000000000C0FCD175E6EC2CA7BCB7B60B97DC0900C01EB429BCA617B9BFD428020C5A2700C000A6693CB8F8C8BF89744EAA2F5800C0FA9ED52E0694D2BFAE5C330CE59B00C052A9AEA6E27DD8BF92D09F43D3F100C022F606385D2BDEBF9557BC75265901C0BA68AE393BC7E1BF2DBA3AE5DFD001C0C91D0925F34CE4BF0A316066D85702C0BE3B7F669EA0E6BF86B8BD36C3EC02C03217156B80BCE8BFC8659431318E03C094A10E29669BEABF3221FF58943A04C0A3BD80F1B238ECBFCC2A2AAB43F004C03A8D32CF6B90EDBF184C253A7FAD05C0D12DC656419FEEBF9765397C747006C0A85CF7CF9762EFBF55B21ECA423707C02125D1A38DD8EFBFF6FFFFFFFFFF07C0FFFFFFFFFFFFEFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100112,1,x'0001FFFFFFFF00000000000010C0000000000000F0BF00000000000008C0000000000000F03F7C020000000400000000000000000010C0000000000000F03F00000000000008C0000000000000F03F00000000000008C0000000000000F0BF00000000000010C0000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100112,2,x'0001FFFFFFFF0000000000001CC0FFFFFFFFFFFFEFBF00000000000018C0FFFFFFFFFFFFEF3F7C02000000210000000000000000001CC0FFFFFFFFFFFFEF3F30590F65A19B1BC02525D1A38DD8EF3FD0B21C3E3A381BC0B05CF7CF9762EF3F10A6129DBFD61AC0D92DC656419FEE3F6A1595D521781AC0468D32CF6B90ED3F9D907F2C4A1D1AC0B1BD80F1B238EC3FE732CA9818C719C0A3A10E29669BEA3F46DC5E9B617619C04117156B80BCE83F87183033EC2B19C0CD3B7F669EA0E63F185D9DF26FE818C0D61D0925F34CE43FCC2BDE3A93AC18C0C868AE393BC7E13F4AE8CFA1E97818C03CF606385D2BDE3F58AE1986F24D18C062A9AEA6E27DD83F453A27D5172C18C0079FD52E0694D23F6A140106AD1318C00BA6693CB8F8C83F5CDB854BEE0418C037B429BCA617B93F00000000000018C0065C143326A6913C5BDB854BEE0418C02EB429BCA617B9BF6A140106AD1318C007A6693CB8F8C8BF453A27D5172C18C0059FD52E0694D2BF57AE1986F24D18C061A9AEA6E27DD8BF4AE8CFA1E97818C038F606385D2BDEBFCC2BDE3A93AC18C0C768AE393BC7E1BF185D9DF26FE818C0D61D0925F34CE4BF86183033EC2B19C0CC3B7F669EA0E6BF45DC5E9B617619C04117156B80BCE8BFE732CA9818C719C0A1A10E29669BEABF9C907F2C4A1D1AC0B0BD80F1B238ECBF6A1595D521781AC0468D32CF6B90EDBF10A6129DBFD61AC0DA2DC656419FEEBFCFB21C3E3A381BC0AF5CF7CF9762EFBF2F590F65A19B1BC02425D1A38DD8EFBF0000000000001CC0FFFFFFFFFFFFEFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100112,3,x'0001FFFFFFFF00000000000018C00000000000000000000000000000000000000000000000007C020000000200000000000000000018C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100113,1,x'0001FFFFFFFF5C8FC2F5285C08C0643BDF4F8D97F0BF00000000000000C0B0726891ED7CEF3F7C0200000003000000C1CAA145B6F307C0B0726891ED7CEF3F00000000000000C000000000000000005C8FC2F5285C08C0643BDF4F8D97F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100113,2,x'0001FFFFFFFF00000000000014C0000000000000F0BF00000000000010C0000000000000F03F7C020000000300000000000000000014C0000000000000F0BF00000000000010C0000000000000000000000000000014C0000000000000F03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100113,3,x'0001FFFFFFFF0700000000001CC0FFFFFFFFFFFFEFBF00000000000018C0FFFFFFFFFFFFEF3F7C02000000210000000700000000001CC0FFFFFFFFFFFFEF3F36590F65A19B1BC02A25D1A38DD8EF3FD6B21C3E3A381BC0B95CF7CF9762EF3F15A6129DBFD61AC0E62DC656419FEE3F6F1595D521781AC0558D32CF6B90ED3FA1907F2C4A1D1AC0C2BD80F1B238EC3FEB32CA9818C719C0B5A10E29669BEA3F48DC5E9B617619C05317156B80BCE83F89183033EC2B19C0DF3B7F669EA0E63F1A5D9DF26FE818C0E71D0925F34CE43FCD2BDE3A93AC18C0D868AE393BC7E13F4BE8CFA1E97818C055F606385D2BDE3F58AE1986F24D18C078A9AEA6E27DD83F453A27D5172C18C0179FD52E0694D23F6A140106AD1318C01BA6693CB8F8C83F5CDB854BEE0418C037B429BCA617B93F00000000000018C0FCD175E6EC2CA7BC5CDB854BEE0418C04EB429BCA617B9BF6A140106AD1318C027A6693CB8F8C8BF453A27D5172C18C01C9FD52E0694D2BF58AE1986F24D18C07EA9AEA6E27DD8BF4BE8CFA1E97818C05BF606385D2BDEBFCD2BDE3A93AC18C0DB68AE393BC7E1BF1A5D9DF26FE818C0E81D0925F34CE4BF89183033EC2B19C0E03B7F669EA0E6BF48DC5E9B617619C05517156B80BCE8BFEA32CA9818C719C0B5A10E29669BEABFA1907F2C4A1D1AC0C3BD80F1B238ECBF6F1595D521781AC0578D32CF6B90EDBF15A6129DBFD61AC0E72DC656419FEEBFD6B21C3E3A381BC0B95CF7CF9762EFBF36590F65A19B1BC02A25D1A38DD8EFBF0700000000001CC0FFFFFFFFFFFFEFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100113,4,x'0001FFFFFFFF00000000000018C00000000000000000000000000000000000000000000000007C020000000200000000000000000018C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100114,1,x'0001FFFFFFFF9A999999999913C0000000000000F0BF3333333333330FC0355EBA490C02EF3F7C02000000030000009A999999999913C0000000000000F0BF3333333333330FC000000000000000000AD7A3703D8A13C0355EBA490C02EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100114,2,x'0001FFFFFFFFFDFFFFFFFFFF1BC0FFFFFFFFFFFFEFBF00000000000018C0FFFFFFFFFFFFEF3F7C0200000021000000FDFFFFFFFFFF1BC0FFFFFFFFFFFFEF3F2D590F65A19B1BC02225D1A38DD8EF3FCDB21C3E3A381BC0AB5CF7CF9762EF3F0DA6129DBFD61AC0D32DC656419FEE3F681595D521781AC03E8D32CF6B90ED3F9B907F2C4A1D1AC0A7BD80F1B238EC3FE632CA9818C719C099A10E29669BEA3F44DC5E9B617619C03717156B80BCE83F86183033EC2B19C0C23B7F669EA0E63F175D9DF26FE818C0CB1D0925F34CE43FCB2BDE3A93AC18C0BE68AE393BC7E13F4AE8CFA1E97818C02AF606385D2BDE3F57AE1986F24D18C053A9AEA6E27DD83F453A27D5172C18C0F89ED52E0694D23F6A140106AD1318C0FCA5693CB8F8C83F5BDB854BEE0418C017B429BCA617B93F00000000000018C0FCD175E6EC2CA7BC5BDB854BEE0418C02EB429BCA617B9BF6A140106AD1318C007A6693CB8F8C8BF453A27D5172C18C0FE9ED52E0694D2BF57AE1986F24D18C059A9AEA6E27DD8BF4AE8CFA1E97818C030F606385D2BDEBFCB2BDE3A93AC18C0C068AE393BC7E1BF175D9DF26FE818C0D01D0925F34CE4BF85183033EC2B19C0C33B7F669EA0E6BF44DC5E9B617619C03717156B80BCE8BFE632CA9818C719C09BA10E29669BEABF9A907F2C4A1D1AC0A8BD80F1B238ECBF671595D521781AC03E8D32CF6B90EDBF0DA6129DBFD61AC0D52DC656419FEEBFCDB21C3E3A381BC0AB5CF7CF9762EFBF2D590F65A19B1BC02225D1A38DD8EFBFFDFFFFFFFFFF1BC0FFFFFFFFFFFFEFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100114,3,x'0001FFFFFFFFFAFFFFFFFFFF07C0FFFFFFFFFFFFEFBF00000000000000C0FFFFFFFFFFFFEF3F7C0200000021000000FAFFFFFFFFFF07C0FFFFFFFFFFFFEF3F59B21ECA423707C02225D1A38DD8EF3F9A65397C747006C0AB5CF7CF9762EF3F1B4C253A7FAD05C0D32DC656419FEE3FD02A2AAB43F004C03E8D32CF6B90ED3F3521FF58943A04C0A7BD80F1B238EC3FCB659431318E03C099A10E29669BEA3F88B8BD36C3EC02C03717156B80BCE83F0B316066D85702C0C23B7F669EA0E63F2EBA3AE5DFD001C0CB1D0925F34CE43F9657BC75265901C0BE68AE393BC7E13F93D09F43D3F100C02AF606385D2BDE3FAE5C330CE59B00C053A9AEA6E27DD83F89744EAA2F5800C0F89ED52E0694D23FD428020C5A2700C0FCA5693CB8F8C83FB7B60B97DC0900C017B429BCA617B93F00000000000000C0FCD175E6EC2CA7BCB7B60B97DC0900C02EB429BCA617B9BFD428020C5A2700C007A6693CB8F8C8BF89744EAA2F5800C0FE9ED52E0694D2BFAE5C330CE59B00C059A9AEA6E27DD8BF93D09F43D3F100C030F606385D2BDEBF9657BC75265901C0C068AE393BC7E1BF2EBA3AE5DFD001C0D01D0925F34CE4BF0B316066D85702C0C33B7F669EA0E6BF88B8BD36C3EC02C03717156B80BCE8BFCB659431318E03C09BA10E29669BEABF3521FF58943A04C0A8BD80F1B238ECBFCF2A2AAB43F004C03E8D32CF6B90EDBF1B4C253A7FAD05C0D52DC656419FEEBF9A65397C747006C0AB5CF7CF9762EFBF59B21ECA423707C02225D1A38DD8EFBFFAFFFFFFFFFF07C0FFFFFFFFFFFFEFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100114,4,x'0001FFFFFFFF00000000000018C00000000000000000000000000000000000000000000000007C020000000200000000000000000018C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100115,1,x'0001FFFFFFFF0000000000001CC0000000000000F0BF000000000000000000000000000000007C02000000060000000000000000001CC0000000000000000000000000000014C0000000000000000000000000000014C0000000000000F0BF00000000000000C0000000000000F0BF00000000000000C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100115,2,x'0001FFFFFFFF00000000000006C0000000000000F0BF00000000000006C000000000000000007C020000000200000000000000000006C0000000000000000000000000000006C0000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100115,3,x'0001FFFFFFFF00000000000011C0000000000000F0BF00000000000011C000000000000000007C020000000200000000000000000011C0000000000000F0BF00000000000011C00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100116,1,x'0001FFFFFFFF0000000000001CC0000000000000F0BF000000000000000000000000000000007C02000000060000000000000000001CC0000000000000000000000000000014C0000000000000000000000000000014C0000000000000F0BF00000000000000C0000000000000F0BF00000000000000C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100116,2,x'0001FFFFFFFF00000000000006C0000000000000F0BF00000000000006C000000000000000007C020000000200000000000000000006C0000000000000000000000000000006C0000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100116,3,x'0001FFFFFFFF0000000000000CC0000000000000F0BF0000000000000CC000000000000000007C02000000020000000000000000000CC0000000000000F0BF0000000000000CC00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100116,4,x'0001FFFFFFFF00000000000011C0000000000000F0BF00000000000011C000000000000000007C020000000200000000000000000011C0000000000000000000000000000011C0000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100117,1,x'0001FFFFFFFF0000000000001CC02DB29DEFA7C6EFBF0000000000000000FA7E6ABC7493983F7C02000000060000000000000000001CC0FA7E6ABC7493983F00000000000014C09CC420B07268913F6BBC7493180414C0DBF97E6ABC74EFBFD578E926310800C02DB29DEFA7C6EFBF00000000000000C079E9263108AC7C3F00000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100117,2,x'0001FFFFFFFF3CDF4F8D976E0EC02FDD24068195EFBF6766666666660EC03AB4C876BE9F8A3F7C02000000020000006766666666660EC03AB4C876BE9F8A3F3CDF4F8D976E0EC02FDD24068195EFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100117,3,x'0001FFFFFFFF6F1283C0CAA109C0D9CEF753E3A5EFBF9A999999999909C0BA490C022B87863F7C02000000020000009A999999999909C0BA490C022B87863F6F1283C0CAA109C0D9CEF753E3A5EFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100117,4,x'0001FFFFFFFFA245B6F3FDD404C083C0CAA145B6EFBFCDCCCCCCCCCC04C03CDF4F8D976E823F7C0200000002000000CDCCCCCCCCCC04C03CDF4F8D976E823FA245B6F3FDD404C083C0CAA145B6EFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100117,5,x'0001FFFFFFFF04560E2DB29D11C085EB51B81E85EFBF9A999999999911C0B81E85EB51B88E3F7C02000000020000009A999999999911C0B81E85EB51B88E3F04560E2DB29D11C085EB51B81E85EFBFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100118,1,x'0001FFFFFFFF0000000000001CC00000000000000000000000000000000000000000000000007C02000000020000000000000000001CC0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100118,2,x'0001FFFFFFFF00000000000014C0FEFFFFFFFFFF473D00000000000000C0FFFFFFFFFFFFF73F7C020000002100000000000000000014C0A227534E9E06483DE536B78E9AF813C08B5D1F0DBDD1C23F4061FE767CE213C0D7464F2D8ABAD23F6C284540DCBD13C0DF77404609DEDB3F467AD936148B13C0340303FD695EE23F5323488DA14A13C0503C05EA85A0E63F0CBEB22723FD12C04AA085D6D8AAEA3F17F4131458A312C05CAF8DB76C73EE3FF2DA37B31D3E12C0E96DDFCC76F8F03F57B5F1966DCE11C046D24F50608DF23F6AB3D01A5B5511C0D9F9CA9E8CF4F33FE1A640BD10D410C0B48E2035862AF53FB55FA03FCD4B10C03DEA65DB502CF63F8C0DC828C17B0FC08DA2140171F7F63F62E7A94551570EC09685F9DBF189F73F5BF4D1D01B2D0DC0E0DBDC3A6AE2F73F0000000000000CC0FFFFFFFFFFFFF73FA60B2E2FE4D20AC0E0DBDC3A6AE2F73F9E1856BAAEA809C09685F9DBF189F73F75F237D73E8408C08DA2140171F7F63F9640BF80656807C03DEA65DB502CF63F3FB27E85DE5706C0B58E2035862AF53F2E995ECA495505C0DBF9CA9E8CF4F33F52951CD2246304C045D24F50608DF23F1C4A9099C48303C0E86DDFCC76F8F03FD217D8D74FB902C05AAF8DB76C73EE3FE8839AB0B90502C048A085D6D8AAEA3F5BB96FE5BC6A01C0503C05EA85A0E63F740B4D92D7E900C0310303FD695EE23F29AF757F478400C0D977404609DEDB3F803D0312073B00C0DA464F2D8ABAD23F369291E2CA0E00C0895D1F0DBDD1C23F00000000000000C0FEFFFFFFFFFF473DFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100119,1,x'0001FFFFFFFF0000000000001CC0000000000000F0BF000000000000000000000000000000007C02000000060000000000000000001CC0000000000000000000000000000014C0000000000000000000000000000014C0000000000000F0BF00000000000000C0000000000000F0BF00000000000000C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100120,1,x'0001FFFFFFFF0000000000000CC00000000000000000020000000000E0BFFFFFFFFFFFFFF73F7C02000000210000000000000000000CC0098A9E4C3979AA3CEE6D6E1D35F10BC027471F0DBDD1C23FC2C2FCEDF8C40BC08A3C4F2D8ABAD23F32518A80B87B0BC0896E404609DEDB3FFAF4B26D28160BC00BFF02FD695EE23F2247901A43950AC0AC3805EA85A0E63F9C7C654F46FA09C02C9D85D6D8AAEA3FB8E82728B04609C0C1AC8DB76C73EE3F6CB66F663B7C08C0D96CDFCC76F8F03F306BE32DDB9C07C071D14F50608DF23F4B67A135B6AA06C039F9CA9E8CF4F33F2C4E817A21A805C0438E2035862AF53FC2BF407F9A9704C0F4E965DB502CF63FD10DC828C17B03C063A2140171F7F63F91E7A945515702C08385F9DBF189F73F73F4D1D01B2D01C0DBDBDC3A6AE2F73FFFFFFFFFFFFFFFBFFFFFFFFFFFFFF73F1B175C5EC8A5FDBFDCDBDC3A6AE2F73FDE30AC745D51FBBF8385F9DBF189F73F5FE46FAE7D08F9BF63A2140171F7F63F7B807E01CBD0F6BFF4E965DB502CF63FA963FD0ABDAFF4BF448E2035862AF53F6B31BD9493AAF2BF3BF9CA9E8CF4F33FA02939A449C6F0BF70D14F50608DF23F4F264166120FEEBFD86CDFCC76F8F03F1F5D605F3FE5EABFBFAC8DB76C73EE3F8B0D6AC2E616E8BF2A9D85D6D8AAEA3F79E3BE95F3AAE5BFAD3805EA85A0E63F172C34495EA7E3BF09FF02FD695EE23F3ABBD6FD1D11E2BF856E404609DEDB3FFAF40C481CECE0BF8D3C4F2D8ABAD23F4A48468A2B3BE0BF25471F0DBDD1C23F020000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100121,1,x'0001FFFFFFFF0000000000001CC0000000000000F0BF000000000000000000000000000000007C02000000060000000000000000001CC0000000000000000000000000000014C0000000000000000000000000000014C0000000000000F0BF00000000000000C0000000000000F0BF00000000000000C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100121,2,x'0001FFFFFFFF0000000000000CC0000000000000F0BF0000000000000CC000000000000000007C02000000020000000000000000000CC000000000000000000000000000000CC0000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100122,1,x'0001FFFFFFFF6666666666662DC0666666666666D6BF0000000000002CC0666666666666D63F7C0300000001000000310000000000000000002CC0A14DE9AD68B598BCB66DFC7788012CC0B0B0CC48EA63A73F6B35D7281B062CC02A09010FB030B73FE9E4AA0AA40D2CC08F76AD74EB24C13FEC77841C02182CC0626666666666C63F99B1F3F407252CC0AAE80359C345CB3F7E37F5887C342CC04EED7E8FAAADCF3F9023CF251C462CC03133F0C767C5D13F9999999999592CC0DC68D7D52266D33F597D60859F6E2CC049C90911E5B1D43F213115D3D1842CC0F4B87F4B01A3D53F8266EA48CF9B2CC09FAFD8665735D63F3333333333B32CC0666666666666D63FE4FF7B1D97CA2CC0A0AFD8665735D63F4535519394E12CC0F5B87F4B01A3D53F0DE905E1C6F72CC04BC90911E5B1D43FCDCCCCCCCC0C2DC0DF68D7D52266D33FD64297404A202DC03533F0C767C5D13FE82E71DDE9312DC054ED7E8FAAADCF3FCCB472715E412DC0B2E80359C345CB3F7AEEE149644E2DC06D6666666666C63F7D81BB5BC2582DC09676AD74EB24C13FFB308F3D4B602DC03D09010FB030B73FB0F869EEDD642DC0DDB0CC48EA63A73F6666666666662DC039FA6E820E88A23CB0F869EEDD642DC08DB0CC48EA63A7BFFB308F3D4B602DC02009010FB030B7BF7D81BB5BC2582DC08D76AD74EB24C1BF7AEEE149644E2DC05B6666666666C6BFCDB472715E412DC0A7E80359C345CBBFE82E71DDE9312DC04EED7E8FAAADCFBFD64297404A202DC03033F0C767C5D1BFCDCCCCCCCC0C2DC0DB68D7D52266D3BF0DE905E1C6F72CC048C90911E5B1D4BF4635519394E12CC0F3B87F4B01A3D5BFE4FF7B1D97CA2CC09FAFD8665735D6BF3333333333B32CC0666666666666D6BF8266EA48CF9B2CC0A0AFD8665735D6BF213115D3D1842CC0F5B87F4B01A3D5BF597D60859F6E2CC04BC90911E5B1D4BF9A99999999592CC0E168D7D52266D3BF9023CF251C462CC03433F0C767C5D1BF7E37F5887C342CC055ED7E8FAAADCFBF9AB1F3F407252CC0B2E80359C345CBBFEC77841C02182CC06F6666666666C6BFE9E4AA0AA40D2CC09C76AD74EB24C1BF6B35D7281B062CC04B09010FB030B7BFB66DFC7788012CC0CEB0CC48EA63A7BF0000000000002CC0A14DE9AD68B598BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100122,2,x'0001FFFFFFFFCDCCCCCCCCCC12C0666666666666D6BF01000000000010C0666666666666D63F7C03000000010000003100000001000000000010C0A14DE9AD68B598BC6DDBF8EF100310C0B0B0CC48EA63A73FD86AAE51360C10C02A09010FB030B73FD2C95515481B10C08F76AD74EB24C13FD9EF0839043010C0626666666666C63F3463E7E90F4A10C0AAE80359C345CB3FFD6EEA11F96810C04EED7E8FAAADCF3F22479E4B388C10C03133F0C767C5D13F3433333333B310C0DC68D7D52266D33FB2FAC00A3FDD10C049C90911E5B1D43F42622AA6A30911C0F4B87F4B01A3D53F05CDD4919E3711C09FAFD8665735D63F67666666666611C0666666666666D63FC8FFF73A2E9511C0A0AFD8665735D63F8C6AA22629C311C0F5B87F4B01A3D53F1CD20BC28DEF11C04BC90911E5B1D43F9A999999991912C0DF68D7D52266D33FAC852E81944012C03533F0C767C5D13FD15DE2BAD36312C054ED7E8FAAADCF3F9A69E5E2BC8212C0B2E80359C345CB3FF5DCC393C89C12C06D6666666666C63FFC0277B784B112C09676AD74EB24C13FF6611E7B96C012C03D09010FB030B73F61F1D3DCBBC912C0DDB0CC48EA63A73FCDCCCCCCCCCC12C039FA6E820E88A23C61F1D3DCBBC912C08DB0CC48EA63A7BFF6611E7B96C012C02009010FB030B7BFFC0277B784B112C08D76AD74EB24C1BFF5DCC393C89C12C05B6666666666C6BF9A69E5E2BC8212C0A7E80359C345CBBFD25DE2BAD36312C04EED7E8FAAADCFBFAC852E81944012C03033F0C767C5D1BF9A999999991912C0DB68D7D52266D3BF1CD20BC28DEF11C048C90911E5B1D4BF8C6AA22629C311C0F3B87F4B01A3D5BFC8FFF73A2E9511C09FAFD8665735D6BF67666666666611C0666666666666D6BF06CDD4919E3711C0A0AFD8665735D6BF42622AA6A30911C0F5B87F4B01A3D5BFB2FAC00A3FDD10C04BC90911E5B1D4BF3433333333B310C0E168D7D52266D3BF22479E4B388C10C03433F0C767C5D1BFFD6EEA11F96810C055ED7E8FAAADCFBF3463E7E90F4A10C0B2E80359C345CBBFD9EF0839043010C06F6666666666C6BFD3C95515481B10C09C76AD74EB24C1BFD86AAE51360C10C04B09010FB030B7BF6DDBF8EF100310C0CEB0CC48EA63A7BF01000000000010C0A14DE9AD68B598BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100122,3,x'0001FFFFFFFFCDCCCCCCCCCC12C0666666666666D6BF01000000000010C0666666666666D63F7C03000000010000003100000001000000000010C0A14DE9AD68B598BC6DDBF8EF100310C0B0B0CC48EA63A73FD86AAE51360C10C02A09010FB030B73FD2C95515481B10C08F76AD74EB24C13FD9EF0839043010C0626666666666C63F3463E7E90F4A10C0AAE80359C345CB3FFD6EEA11F96810C04EED7E8FAAADCF3F22479E4B388C10C03133F0C767C5D13F3433333333B310C0DC68D7D52266D33FB2FAC00A3FDD10C049C90911E5B1D43F42622AA6A30911C0F4B87F4B01A3D53F05CDD4919E3711C09FAFD8665735D63F67666666666611C0666666666666D63FC8FFF73A2E9511C0A0AFD8665735D63F8C6AA22629C311C0F5B87F4B01A3D53F1CD20BC28DEF11C04BC90911E5B1D43F9A999999991912C0DF68D7D52266D33FAC852E81944012C03533F0C767C5D13FD15DE2BAD36312C054ED7E8FAAADCF3F9A69E5E2BC8212C0B2E80359C345CB3FF5DCC393C89C12C06D6666666666C63FFC0277B784B112C09676AD74EB24C13FF6611E7B96C012C03D09010FB030B73F61F1D3DCBBC912C0DDB0CC48EA63A73FCDCCCCCCCCCC12C039FA6E820E88A23C61F1D3DCBBC912C08DB0CC48EA63A7BFF6611E7B96C012C02009010FB030B7BFFC0277B784B112C08D76AD74EB24C1BFF5DCC393C89C12C05B6666666666C6BF9A69E5E2BC8212C0A7E80359C345CBBFD25DE2BAD36312C04EED7E8FAAADCFBFAC852E81944012C03033F0C767C5D1BF9A999999991912C0DB68D7D52266D3BF1CD20BC28DEF11C048C90911E5B1D4BF8C6AA22629C311C0F3B87F4B01A3D5BFC8FFF73A2E9511C09FAFD8665735D6BF67666666666611C0666666666666D6BF06CDD4919E3711C0A0AFD8665735D6BF42622AA6A30911C0F5B87F4B01A3D5BFB2FAC00A3FDD10C04BC90911E5B1D4BF3433333333B310C0E168D7D52266D3BF22479E4B388C10C03433F0C767C5D1BFFD6EEA11F96810C055ED7E8FAAADCFBF3463E7E90F4A10C0B2E80359C345CBBFD9EF0839043010C06F6666666666C6BFD3C95515481B10C09C76AD74EB24C1BFD86AAE51360C10C04B09010FB030B7BF6DDBF8EF100310C0CEB0CC48EA63A7BF01000000000010C0A14DE9AD68B598BCFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100122,4,x'0001FFFFFFFFCDCCCCCCCCCC12C0666666666666D6BF01000000000010C0666666666666D63F7C03000000010000003100000001000000000010C0A14DE9AD68B598BC6DDBF8EF100310C0B0B0CC48EA63A73FD86AAE51360C10C02A09010FB030B73FD2C95515481B10C08F76AD74EB24C13FD9EF0839043010C0626666666666C63F3463E7E90F4A10C0AAE80359C345CB3FFD6EEA11F96810C04EED7E8FAAADCF3F22479E4B388C10C03133F0C767C5D13F3433333333B310C0DC68D7D52266D33FB2FAC00A3FDD10C049C90911E5B1D43F42622AA6A30911C0F4B87F4B01A3D53F05CDD4919E3711C09FAFD8665735D63F67666666666611C0666666666666D63FC8FFF73A2E9511C0A0AFD8665735D63F8C6AA22629C311C0F5B87F4B01A3D53F1CD20BC28DEF11C04BC90911E5B1D43F9A999999991912C0DF68D7D52266D33FAC852E81944012C03533F0C767C5D13FD15DE2BAD36312C054ED7E8FAAADCF3F9A69E5E2BC8212C0B2E80359C345CB3FF5DCC393C89C12C06D6666666666C63FFC0277B784B112C09676AD74EB24C13FF6611E7B96C012C03D09010FB030B73F61F1D3DCBBC912C0DDB0CC48EA63A73FCDCCCCCCCCCC12C039FA6E820E88A23C61F1D3DCBBC912C08DB0CC48EA63A7BFF6611E7B96C012C02009010FB030B7BFFC0277B784B112C08D76AD74EB24C1BFF5DCC393C89C12C05B6666666666C6BF9A69E5E2BC8212C0A7E80359C345CBBFD25DE2BAD36312C04EED7E8FAAADCFBFAC852E81944012C03033F0C767C5D1BF9A999999991912C0DB68D7D52266D3BF1CD20BC28DEF11C048C90911E5B1D4BF8C6AA22629C311C0F3B87F4B01A3D5BFC8FFF73A2E9511C09FAFD8665735D6BF67666666666611C0666666666666D6BF06CDD4919E3711C0A0AFD8665735D6BF42622AA6A30911C0F5B87F4B01A3D5BFB2FAC00A3FDD10C04BC90911E5B1D4BF3433333333B310C0E168D7D52266D3BF22479E4B388C10C03433F0C767C5D1BFFD6EEA11F96810C055ED7E8FAAADCFBF3463E7E90F4A10C0B2E80359C345CBBFD9EF0839043010C06F6666666666C6BFD3C95515481B10C09C76AD74EB24C1BFD86AAE51360C10C04B09010FB030B7BF6DDBF8EF100310C0CEB0CC48EA63A7BF01000000000010C0A14DE9AD68B598BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100122,5,x'0001FFFFFFFFE17A14AE476112C05C8FC2F5285CCFBFEC51B81E856B10C05C8FC2F5285CCF3F7C0200000002000000E17A14AE476112C05C8FC2F5285CCFBFEC51B81E856B10C05C8FC2F5285CCF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100122,6,x'0001FFFFFFFF6666666666662DC0666666666666D6BF0000000000002CC0666666666666D63F7C0300000001000000310000000000000000002CC0A14DE9AD68B598BCB66DFC7788012CC0B0B0CC48EA63A73F6B35D7281B062CC02A09010FB030B73FE9E4AA0AA40D2CC08F76AD74EB24C13FEC77841C02182CC0626666666666C63F99B1F3F407252CC0AAE80359C345CB3F7E37F5887C342CC04EED7E8FAAADCF3F9023CF251C462CC03133F0C767C5D13F9999999999592CC0DC68D7D52266D33F597D60859F6E2CC049C90911E5B1D43F213115D3D1842CC0F4B87F4B01A3D53F8266EA48CF9B2CC09FAFD8665735D63F3333333333B32CC0666666666666D63FE4FF7B1D97CA2CC0A0AFD8665735D63F4535519394E12CC0F5B87F4B01A3D53F0DE905E1C6F72CC04BC90911E5B1D43FCDCCCCCCCC0C2DC0DF68D7D52266D33FD64297404A202DC03533F0C767C5D13FE82E71DDE9312DC054ED7E8FAAADCF3FCCB472715E412DC0B2E80359C345CB3F7AEEE149644E2DC06D6666666666C63F7D81BB5BC2582DC09676AD74EB24C13FFB308F3D4B602DC03D09010FB030B73FB0F869EEDD642DC0DDB0CC48EA63A73F6666666666662DC039FA6E820E88A23CB0F869EEDD642DC08DB0CC48EA63A7BFFB308F3D4B602DC02009010FB030B7BF7D81BB5BC2582DC08D76AD74EB24C1BF7AEEE149644E2DC05B6666666666C6BFCDB472715E412DC0A7E80359C345CBBFE82E71DDE9312DC04EED7E8FAAADCFBFD64297404A202DC03033F0C767C5D1BFCDCCCCCCCC0C2DC0DB68D7D52266D3BF0DE905E1C6F72CC048C90911E5B1D4BF4635519394E12CC0F3B87F4B01A3D5BFE4FF7B1D97CA2CC09FAFD8665735D6BF3333333333B32CC0666666666666D6BF8266EA48CF9B2CC0A0AFD8665735D6BF213115D3D1842CC0F5B87F4B01A3D5BF597D60859F6E2CC04BC90911E5B1D4BF9A99999999592CC0E168D7D52266D3BF9023CF251C462CC03433F0C767C5D1BF7E37F5887C342CC055ED7E8FAAADCFBF9AB1F3F407252CC0B2E80359C345CBBFEC77841C02182CC06F6666666666C6BFE9E4AA0AA40D2CC09C76AD74EB24C1BF6B35D7281B062CC04B09010FB030B7BFB66DFC7788012CC0CEB0CC48EA63A7BF0000000000002CC0A14DE9AD68B598BCFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100122,7,x'0001FFFFFFFF6666666666662DC0666666666666D6BF0000000000002CC0666666666666D63F7C0300000001000000310000000000000000002CC0A14DE9AD68B598BCB66DFC7788012CC0B0B0CC48EA63A73F6B35D7281B062CC02A09010FB030B73FE9E4AA0AA40D2CC08F76AD74EB24C13FEC77841C02182CC0626666666666C63F99B1F3F407252CC0AAE80359C345CB3F7E37F5887C342CC04EED7E8FAAADCF3F9023CF251C462CC03133F0C767C5D13F9999999999592CC0DC68D7D52266D33F597D60859F6E2CC049C90911E5B1D43F213115D3D1842CC0F4B87F4B01A3D53F8266EA48CF9B2CC09FAFD8665735D63F3333333333B32CC0666666666666D63FE4FF7B1D97CA2CC0A0AFD8665735D63F4535519394E12CC0F5B87F4B01A3D53F0DE905E1C6F72CC04BC90911E5B1D43FCDCCCCCCCC0C2DC0DF68D7D52266D33FD64297404A202DC03533F0C767C5D13FE82E71DDE9312DC054ED7E8FAAADCF3FCCB472715E412DC0B2E80359C345CB3F7AEEE149644E2DC06D6666666666C63F7D81BB5BC2582DC09676AD74EB24C13FFB308F3D4B602DC03D09010FB030B73FB0F869EEDD642DC0DDB0CC48EA63A73F6666666666662DC039FA6E820E88A23CB0F869EEDD642DC08DB0CC48EA63A7BFFB308F3D4B602DC02009010FB030B7BF7D81BB5BC2582DC08D76AD74EB24C1BF7AEEE149644E2DC05B6666666666C6BFCDB472715E412DC0A7E80359C345CBBFE82E71DDE9312DC04EED7E8FAAADCFBFD64297404A202DC03033F0C767C5D1BFCDCCCCCCCC0C2DC0DB68D7D52266D3BF0DE905E1C6F72CC048C90911E5B1D4BF4635519394E12CC0F3B87F4B01A3D5BFE4FF7B1D97CA2CC09FAFD8665735D6BF3333333333B32CC0666666666666D6BF8266EA48CF9B2CC0A0AFD8665735D6BF213115D3D1842CC0F5B87F4B01A3D5BF597D60859F6E2CC04BC90911E5B1D4BF9A99999999592CC0E168D7D52266D3BF9023CF251C462CC03433F0C767C5D1BF7E37F5887C342CC055ED7E8FAAADCFBF9AB1F3F407252CC0B2E80359C345CBBFEC77841C02182CC06F6666666666C6BFE9E4AA0AA40D2CC09C76AD74EB24C1BF6B35D7281B062CC04B09010FB030B7BFB66DFC7788012CC0CEB0CC48EA63A7BF0000000000002CC0A14DE9AD68B598BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100122,8,x'0001FFFFFFFF713D0AD7A3302DC05C8FC2F5285CCFBFF6285C8FC2352CC05C8FC2F5285CCF3F7C0200000002000000713D0AD7A3302DC05C8FC2F5285CCFBFF6285C8FC2352CC05C8FC2F5285CCF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100123,1,x'0001FFFFFFFF391491DEF3D621C02DB257D3B38BF83FCBA188F49EB7FEBF2DB257D3B38BF83F7C0200000002000000CBA188F49EB7FEBF2DB257D3B38BF83F391491DEF3D621C02DB257D3B38BF83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100123,2,x'0001FFFFFFFF391491DEF3D621C0D34DA82C4C74F7BFCBA188F49EB7FEBFD34DA82C4C74F7BF7C0200000002000000391491DEF3D621C0D34DA82C4C74F7BFCBA188F49EB7FEBFD34DA82C4C74F7BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100124,1,x'0001FFFFFFFF00000000000020C0000000000000F83F000000000000F0BF000000000000F83F7C020000000200000000000000000020C0000000000000F83F000000000000F0BF000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100124,2,x'0001FFFFFFFF00000000000020C0000000000000F03F000000000000F0BF000000000000F03F7C0200000002000000000000000000F0BF000000000000F03F00000000000020C0000000000000F03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100124,3,x'0001FFFFFFFF00000000000020C0000000000000F0BF000000000000F0BF000000000000F0BF7C020000000200000000000000000020C0000000000000F0BF000000000000F0BF000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100124,4,x'0001FFFFFFFF00000000000020C0000000000000F8BF000000000000F0BF000000000000F8BF7C0200000002000000000000000000F0BF000000000000F8BF00000000000020C0000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100125,1,x'0001FFFFFFFF0000000000001EC0000000000000E8BF000000000000E0BF000000000000E83F7C02000000050000000000000000001EC0000000000000E83F000000000000E0BF000000000000E83F000000000000E0BF000000000000E8BF0000000000001EC0000000000000E8BF0000000000001EC0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,1,x'0001FFFFFFFFBA490C022B0711C0C0CAA145B6F3E7BF15AE47E17A1406C0C0CAA145B6F3E73F7C03000000010000003100000015AE47E17A1406C0D18A565CAB6BAABCB5DD5A2B982106C043578DCACA02B93FD47FE097B64806C0705ADCEF03CCC83F352E5BCD2A8906C055A1335A0255D23F52031179DAE106C0BCCAA145B6F3D73FEF98AF23415107C0237776E07F29DD3F7C45DED676D507C0236D476FC6EFE03FE051A176386C08C0551F023C9D00E33F6DE7FBA9F11209C0CB757CE637BEE43F9AAC6927C8C609C040CA5395F620E63F1D5BB233A8840AC0C2833E6BC722E73F0AB65B1C52490BC03F0C551D41BFE73FC520B07268110CC0C0CAA145B6F3E73F7F8B04C97ED90CC0400C551D41BFE73F6CE6ADB1289E0DC0C3833E6BC722E73FF094F6BD085C0EC042CA5395F620E63F1D5A643BDF0F0FC0CE757CE637BEE43FA9EFBE6E98B60FC0591F023C9D00E33F07FE4007AD2610C0266D476FC6EFE03F4D54D8E0C76810C02D7776E07F29DD3F1C9F27367BA010C0C7CAA145B6F3D73FAB89020CD3CC10C05DA1335A0255D23FDBE0BF260DED10C0845ADCEF03CCC83FEAB1025D9C0011C073578DCACA02B93FBA490C022B0711C01BE84085C0D0B33CEAB1025D9C0011C01E578DCACA02B9BFDBE0BF260DED10C0665ADCEF03CCC8BFAB89020CD3CC10C054A1335A0255D2BF1C9F27367BA010C0B5CAA145B6F3D7BF4E54D8E0C76810C0207776E07F29DDBF07FE4007AD2610C0236D476FC6EFE0BFAAEFBE6E98B60FC0541F023C9D00E3BF1E5A643BDF0F0FC0CA757CE637BEE4BFF194F6BD085C0EC03ECA5395F620E6BF6EE6ADB1289E0DC0C1833E6BC722E7BF808B04C97ED90CC03F0C551D41BFE7BFC520B07268110CC0C0CAA145B6F3E7BF0BB65B1C52490BC0400C551D41BFE7BF1E5BB233A8840AC0C3833E6BC722E7BF9AAC6927C8C609C041CA5395F620E6BF6EE7FBA9F11209C0D0757CE637BEE4BFE051A176386C08C0581F023C9D00E3BF7C45DED676D507C0266D476FC6EFE0BFF098AF23415107C02D7776E07F29DDBF52031179DAE106C0C9CAA145B6F3D7BF352E5BCD2A8906C063A1335A0255D2BFD57FE097B64806C0935ADCEF03CCC8BFB5DD5A2B982106C063578DCACA02B9BF15AE47E17A1406C0D18A565CAB6BAABCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,2,x'0001FFFFFFFF4F8D976E120311C0FBA9F1D24D6270BF7B14AE47E1FA10C0FBA9F1D24D62703F7C0300000001000000310000007B14AE47E1FA10C00A5654B5951232BCD4BA2E40EAFA10C0028A2674BB1B413FB677650205FB10C09581945543F6503F54C61C1931FB10C07984A4D35C14593F543A36C36DFB10C0F8A9F1D24D62603F8867F8F6B9FB10C0A049DE36A9F2633FFED09A6614FC10C01337FF3FA42B673F1CF5FB857BFC10C0F2E54A5321FF693FB0726891EDFC10C0D787B464BF606C3F9D96559568FD10C07688543010466E3F9D77ED76EAFD10C0E177C9EAC5A66F3FB12F47FD70FE10C0F04558D06B3E703FE5D022DBF9FE10C0FBA9F1D24D62703F1972FEB882FF10C0F14558D06B3E703F2D2A583F090011C0E577C9EAC5A66F3F2D0BF0208B0011C07888543010466E3F1A2FDD24060111C0DA87B464BF606C3FAEAC4930780111C0F7E54A5321FF693FCCD0AA4FDF0111C01837FF3FA42B673F423A4DBF390211C0A749DE36A9F2633F76670FF3850211C000AAF1D24D62603F76DB289DC20211C08384A4D35C14593F142AE0B3EE0211C0A281945543F6503FF6E61676090311C0248A2674BB1B413F4F8D976E120311C00F81FE8FE01B3B3CF6E61676090311C0E9892674BB1B41BF142AE0B3EE0211C08D81945543F650BF76DB289DC20211C07784A4D35C1459BF76670FF3850211C0F3A9F1D24D6260BF423A4DBF390211C09E49DE36A9F263BFCCD0AA4FDF0111C01337FF3FA42B67BFAEAC4930780111C0F1E54A5321FF69BF1A2FDD24060111C0D487B464BF606CBF2D0BF0208B0011C07488543010466EBF2D2A583F090011C0E077C9EAC5A66FBF1972FEB882FF10C0F04558D06B3E70BFE5D022DBF9FE10C0FBA9F1D24D6270BFB12F47FD70FE10C0F14558D06B3E70BF9D77ED76EAFD10C0E577C9EAC5A66FBF9D96559568FD10C07788543010466EBFB0726891EDFC10C0DD87B464BF606CBF1CF5FB857BFC10C0F5E54A5321FF69BFFED09A6614FC10C01937FF3FA42B67BF8867F8F6B9FB10C0A749DE36A9F263BF543A36C36DFB10C001AAF1D24D6260BF54C61C1931FB10C08C84A4D35C1459BFB677650205FB10C0AC81945543F650BFD4BA2E40EAFA10C0188A2674BB1B41BF7B14AE47E1FA10C00A5654B5951232BCFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,3,x'0001FFFFFFFF4F8D976E120311C0FBA9F1D24D6270BF7B14AE47E1FA10C0FBA9F1D24D62703F7C0300000001000000310000007B14AE47E1FA10C00A5654B5951232BCD4BA2E40EAFA10C0028A2674BB1B413FB677650205FB10C09581945543F6503F54C61C1931FB10C07984A4D35C14593F543A36C36DFB10C0F8A9F1D24D62603F8867F8F6B9FB10C0A049DE36A9F2633FFED09A6614FC10C01337FF3FA42B673F1CF5FB857BFC10C0F2E54A5321FF693FB0726891EDFC10C0D787B464BF606C3F9D96559568FD10C07688543010466E3F9D77ED76EAFD10C0E177C9EAC5A66F3FB12F47FD70FE10C0F04558D06B3E703FE5D022DBF9FE10C0FBA9F1D24D62703F1972FEB882FF10C0F14558D06B3E703F2D2A583F090011C0E577C9EAC5A66F3F2D0BF0208B0011C07888543010466E3F1A2FDD24060111C0DA87B464BF606C3FAEAC4930780111C0F7E54A5321FF693FCCD0AA4FDF0111C01837FF3FA42B673F423A4DBF390211C0A749DE36A9F2633F76670FF3850211C000AAF1D24D62603F76DB289DC20211C08384A4D35C14593F142AE0B3EE0211C0A281945543F6503FF6E61676090311C0248A2674BB1B413F4F8D976E120311C00F81FE8FE01B3B3CF6E61676090311C0E9892674BB1B41BF142AE0B3EE0211C08D81945543F650BF76DB289DC20211C07784A4D35C1459BF76670FF3850211C0F3A9F1D24D6260BF423A4DBF390211C09E49DE36A9F263BFCCD0AA4FDF0111C01337FF3FA42B67BFAEAC4930780111C0F1E54A5321FF69BF1A2FDD24060111C0D487B464BF606CBF2D0BF0208B0011C07488543010466EBF2D2A583F090011C0E077C9EAC5A66FBF1972FEB882FF10C0F04558D06B3E70BFE5D022DBF9FE10C0FBA9F1D24D6270BFB12F47FD70FE10C0F14558D06B3E70BF9D77ED76EAFD10C0E577C9EAC5A66FBF9D96559568FD10C07788543010466EBFB0726891EDFC10C0DD87B464BF606CBF1CF5FB857BFC10C0F5E54A5321FF69BFFED09A6614FC10C01937FF3FA42B67BF8867F8F6B9FB10C0A749DE36A9F263BF543A36C36DFB10C001AAF1D24D6260BF54C61C1931FB10C08C84A4D35C1459BFB677650205FB10C0AC81945543F650BFD4BA2E40EAFA10C0188A2674BB1B41BF7B14AE47E1FA10C00A5654B5951232BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,4,x'0001FFFFFFFFBA490C022B0711C0C0CAA145B6F3E7BF15AE47E17A1406C0C0CAA145B6F3E73F7C03000000010000003100000015AE47E17A1406C0D18A565CAB6BAABCB5DD5A2B982106C043578DCACA02B93FD47FE097B64806C0705ADCEF03CCC83F352E5BCD2A8906C055A1335A0255D23F52031179DAE106C0BCCAA145B6F3D73FEF98AF23415107C0237776E07F29DD3F7C45DED676D507C0236D476FC6EFE03FE051A176386C08C0551F023C9D00E33F6DE7FBA9F11209C0CB757CE637BEE43F9AAC6927C8C609C040CA5395F620E63F1D5BB233A8840AC0C2833E6BC722E73F0AB65B1C52490BC03F0C551D41BFE73FC520B07268110CC0C0CAA145B6F3E73F7F8B04C97ED90CC0400C551D41BFE73F6CE6ADB1289E0DC0C3833E6BC722E73FF094F6BD085C0EC042CA5395F620E63F1D5A643BDF0F0FC0CE757CE637BEE43FA9EFBE6E98B60FC0591F023C9D00E33F07FE4007AD2610C0266D476FC6EFE03F4D54D8E0C76810C02D7776E07F29DD3F1C9F27367BA010C0C7CAA145B6F3D73FAB89020CD3CC10C05DA1335A0255D23FDBE0BF260DED10C0845ADCEF03CCC83FEAB1025D9C0011C073578DCACA02B93FBA490C022B0711C01BE84085C0D0B33CEAB1025D9C0011C01E578DCACA02B9BFDBE0BF260DED10C0665ADCEF03CCC8BFAB89020CD3CC10C054A1335A0255D2BF1C9F27367BA010C0B5CAA145B6F3D7BF4E54D8E0C76810C0207776E07F29DDBF07FE4007AD2610C0236D476FC6EFE0BFAAEFBE6E98B60FC0541F023C9D00E3BF1E5A643BDF0F0FC0CA757CE637BEE4BFF194F6BD085C0EC03ECA5395F620E6BF6EE6ADB1289E0DC0C1833E6BC722E7BF808B04C97ED90CC03F0C551D41BFE7BFC520B07268110CC0C0CAA145B6F3E7BF0BB65B1C52490BC0400C551D41BFE7BF1E5BB233A8840AC0C3833E6BC722E7BF9AAC6927C8C609C041CA5395F620E6BF6EE7FBA9F11209C0D0757CE637BEE4BFE051A176386C08C0581F023C9D00E3BF7C45DED676D507C0266D476FC6EFE0BFF098AF23415107C02D7776E07F29DDBF52031179DAE106C0C9CAA145B6F3D7BF352E5BCD2A8906C063A1335A0255D2BFD57FE097B64806C0935ADCEF03CCC8BFB5DD5A2B982106C063578DCACA02B9BF15AE47E17A1406C0D18A565CAB6BAABCFE',3,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,5,x'0001FFFFFFFFBA490C022B0711C0C0CAA145B6F3E7BF15AE47E17A1406C0C0CAA145B6F3E73F7C03000000010000003100000015AE47E17A1406C0D18A565CAB6BAABCB5DD5A2B982106C043578DCACA02B93FD47FE097B64806C0705ADCEF03CCC83F352E5BCD2A8906C055A1335A0255D23F52031179DAE106C0BCCAA145B6F3D73FEF98AF23415107C0237776E07F29DD3F7C45DED676D507C0236D476FC6EFE03FE051A176386C08C0551F023C9D00E33F6DE7FBA9F11209C0CB757CE637BEE43F9AAC6927C8C609C040CA5395F620E63F1D5BB233A8840AC0C2833E6BC722E73F0AB65B1C52490BC03F0C551D41BFE73FC520B07268110CC0C0CAA145B6F3E73F7F8B04C97ED90CC0400C551D41BFE73F6CE6ADB1289E0DC0C3833E6BC722E73FF094F6BD085C0EC042CA5395F620E63F1D5A643BDF0F0FC0CE757CE637BEE43FA9EFBE6E98B60FC0591F023C9D00E33F07FE4007AD2610C0266D476FC6EFE03F4D54D8E0C76810C02D7776E07F29DD3F1C9F27367BA010C0C7CAA145B6F3D73FAB89020CD3CC10C05DA1335A0255D23FDBE0BF260DED10C0845ADCEF03CCC83FEAB1025D9C0011C073578DCACA02B93FBA490C022B0711C01BE84085C0D0B33CEAB1025D9C0011C01E578DCACA02B9BFDBE0BF260DED10C0665ADCEF03CCC8BFAB89020CD3CC10C054A1335A0255D2BF1C9F27367BA010C0B5CAA145B6F3D7BF4E54D8E0C76810C0207776E07F29DDBF07FE4007AD2610C0236D476FC6EFE0BFAAEFBE6E98B60FC0541F023C9D00E3BF1E5A643BDF0F0FC0CA757CE637BEE4BFF194F6BD085C0EC03ECA5395F620E6BF6EE6ADB1289E0DC0C1833E6BC722E7BF808B04C97ED90CC03F0C551D41BFE7BFC520B07268110CC0C0CAA145B6F3E7BF0BB65B1C52490BC0400C551D41BFE7BF1E5BB233A8840AC0C3833E6BC722E7BF9AAC6927C8C609C041CA5395F620E6BF6EE7FBA9F11209C0D0757CE637BEE4BFE051A176386C08C0581F023C9D00E3BF7C45DED676D507C0266D476FC6EFE0BFF098AF23415107C02D7776E07F29DDBF52031179DAE106C0C9CAA145B6F3D7BF352E5BCD2A8906C063A1335A0255D2BFD57FE097B64806C0935ADCEF03CCC8BFB5DD5A2B982106C063578DCACA02B9BF15AE47E17A1406C0D18A565CAB6BAABCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,6,x'0001FFFFFFFF022B8716D94E10C060E5D022DBF9DE3F0AD7A3703D0A10C09A9999999999E13F7C0200000002000000022B8716D94E10C060E5D022DBF9DE3F0AD7A3703D0A10C09A9999999999E13FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,7,x'0001FFFFFFFFEC51B81E85EB10C046B6F3FDD478C9BFE6D022DBF97E0AC060E5D022DBF9E63F7C0200000002000000EC51B81E85EB10C046B6F3FDD478C9BFE6D022DBF97E0AC060E5D022DBF9E63FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,8,x'0001FFFFFFFF39B4C876BE1F10C0CBA145B6F3FDE0BF022B8716D9CE07C0F853E3A59BC4E03F7C020000000200000039B4C876BE1F10C0CBA145B6F3FDE0BF022B8716D9CE07C0F853E3A59BC4E03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,9,x'0001FFFFFFFFF0A7C64B37890DC0B4C876BE9F1AE7BF7D3F355EBA4906C05A643BDF4F8DC73F7C0200000002000000F0A7C64B37890DC0B4C876BE9F1AE7BF7D3F355EBA4906C05A643BDF4F8DC73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,10,x'0001FFFFFFFF0000000000001CC00000000000000000BA490C022B0711C000000000000000007C02000000020000000000000000001CC00000000000000000BA490C022B0711C00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100126,11,x'0001FFFFFFFF15AE47E17A1406C00000000000000000000000000000000000000000000000007C020000000200000015AE47E17A1406C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100127,1,x'0001FFFFFFFF0000000000000CC0CBA145B6F3FDF7BF000000000000E0BF355EBA490C02F83F7C030000000100000031000000000000000000E0BFFCA9F1D24D62403F18639D232069E0BFE265F7E40120C93F60E11215B4A2E1BFAD0246C9EDE0D83F182C34495EA7E3BF74BB77908262E23F008D7BA3476EE6BF69BC74931804E83F2449FD2E46EBE9BF485AD4728E3CED3F4C264166120FEEBF0ECB991683FAF03F10315010C563F1BFA2B93B32690CF33FFFFFFFFFFFFFF3BFB597FC77E8CAF43F7A807E01CBD0F6BF294820255D2EF63F88DD68D7D0C9F9BF84ED303FB230F73F78711B0D0CDEFCBFA9ACEB377CCDF73F00000000000000C0355EBA490C02F83F434772F9F99001C0AAACEB377CCDF73F3A914B94171B03C085ED303FB230F73FC2BF407F9A9704C0294820255D2EF63FFFFFFFFFFFFF05C0B597FC77E8CAF43F76E7D7771D4E07C0A4B93B32690CF33F6CB66F663B7C08C00FCB991683FAF03FB6AD40742E8509C04C5AD4728E3CED3FC01C21176E640AC06EBC74931804E83FFAF4B26D28160BC076BB77908262E23FA847BBFA52970BC0B50246C9EDE0D83F3AA718F7B7E50BC0F865F7E40120C93F0000000000000CC09AB0F1D24D62403F3AA718F7B7E50BC0688251493DFFC8BFA847BBFA52970BC0F910737B8BD0D8BFFAF4B26D28160BC09F428E69515AE2BFC11C21176E640AC08E438B6CE7FBE7BFB8AD40742E8509C070E1EA4B5D34EDBF6DB66F663B7C08C0A40E25836AF6F0BF78E7D7771D4E07C037FDC69E5008F3BF02000000000006C049DB87E4CFC6F4BFC4BF407F9A9704C0BE8BAB91442AF6BF3E914B94171B03C01931BCAB992CF7BF444772F9F99001C03FF076A463C9F7BF01000000000000C0CBA145B6F3FDF7BF7B711B0D0CDEFCBF40F076A463C9F7BF8DDD68D7D0C9F9BF1B31BCAB992CF7BF7A807E01CBD0F6BFBF8BAB91442AF6BF040000000000F4BF4DDB87E4CFC6F4BF11315010C563F1BF39FDC69E5008F3BF50264166120FEEBFA50E25836AF6F0BF2849FD2E46EBE9BF78E1EA4B5D34EDBF048D7BA3476EE6BF9C438B6CE7FBE7BF1A2C34495EA7E3BFA8428E69515AE2BF64E11215B4A2E1BF1911737B8BD0D8BF18639D232069E0BF948251493DFFC8BF000000000000E0BFFCA9F1D24D62403FFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100127,2,x'0001FFFFFFFF15AE47E17A1406C05A643BDF4F8DE7BFAC1C5A643BDFFBBFD122DBF97E6AF03F7C020000000300000015AE47E17A1406C05A643BDF4F8DE7BFAC1C5A643BDFFBBFD122DBF97E6AF03F105839B4C87600C0B0726891ED7CE73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100127,3,x'0001FFFFFFFFAAF1D24D621002C0D122DBF97E6AF0BFD7A3703D0AD7F3BF5A643BDF4F8DE73F7C0200000003000000AAF1D24D621002C0D122DBF97E6AF0BFD7A3703D0AD7F3BF5A643BDF4F8DE73F4C37894160E5F8BFD122DBF97E6ADC3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100127,4,x'0001FFFFFFFF3108AC1C5A64FDBF3108AC1C5A64E33FAC1C5A643BDFFBBFD122DBF97E6AF03F7C02000000020000003108AC1C5A64FDBF3108AC1C5A64E33FAC1C5A643BDFFBBFD122DBF97E6AF03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100127,5,x'0001FFFFFFFF5C8FC2F5285CF5BFD34D62105839D43FD7A3703D0AD7F3BF5A643BDF4F8DE73F7C02000000020000005C8FC2F5285CF5BFD34D62105839D43FD7A3703D0AD7F3BF5A643BDF4F8DE73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100128,1,x'0001FFFFFFFFE3A59BC420301DC06991ED7C3F35FABF355EBA490C02D3BF6991ED7C3F35FABF7C0200000002000000355EBA490C02D3BF6991ED7C3F35FABFE3A59BC420301DC06991ED7C3F35FABFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100128,2,x'0001FFFFFFFFE3A59BC420301DC0986E1283C0CAF53F355EBA490C02D3BF986E1283C0CAF53F7C0200000002000000355EBA490C02D3BF986E1283C0CAF53FE3A59BC420301DC0986E1283C0CAF53FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100128,3,x'0001FFFFFFFFD89EBA2D87961BC06D7288FFC876CEBFB7CC418B41600EC080B050507916D73F7C0200000011000000D89EBA2D87961BC06D7288FFC876CEBFDEB54AE253EE1AC0C688DA3EF798BBBF6720FD79683B1AC0E037FFB86D51803F76769331107F19C030A0C8A7FEC4BB3FC55DD0B8A7BA18C0C041BBA2ECB3C83FDEC4EFAC9AEF17C070D5DED7ABB2D03F06597CF7601F17C00E367B4254F3D33F007660167C4B16C054EC170DEA15D63FF1F43A52747515C080B050507916D73F231521E8D59E14C0FC5BD31227F3D63F6F000E2C2EC913C05809B4B834ACD53F49FB4DA908F612C038D75D8AFF43D33F440C3746EC2612C088D800A8F87DCF3FA0C97A70585D11C0508C294B5E47C63F85104D57C29A10C0701DFD0A7DEAB53F329C037124C10FC0004BBE718A1B93BFB7CC418B41600EC0A857AECEFBA9C1BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100128,4,x'0001FFFFFFFF8FCC2C8741600EC0F29DDE9B3A60E4BFBB63E5DBD24DE6BFD95C423DBB74A3BF7C0200000011000000BB63E5DBD24DE6BFD95C423DBB74A3BFFFAB64376D8FEBBF89C86B2F7C87C5BF20ACE83C6493F0BFAC813455872CD2BF32548F5EC584F3BF32B15E913B9BD8BF4EB79B416796F6BF082BCA38F203DEBF501B1E719BC2F9BF29B0A5DF532EE1BF18CBEB468203FDBFB2E0F314A8CEE2BFCEABADE58A2900C0E93B42FAF2DFE3BF22AEF86D9AD501C0F29DDE9B3A60E4BFF46D2C42D78203C07CF31F7D914EE4BF919752BA262E05C0D049105018ABE3BF0EA2D2BF71D406C04830E5B8FD76E2BF47800086AA7208C02E7AB61D7CB4E0BFB6057931D2050AC0C04C010DABCDDCBF0E78D463FE8A0BC03CCC2B2A9B24D7BF00FD6AA15EFF0CC0449E50404378D0BF8FCC2C8741600EC008AA2A00FCA9C1BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100129,1,x'0001FFFFFFFFEAF13DD2CCCC18C06D7288FFC876CEBFDB7248D4CCCC08C080B050507916D73F7C0200000011000000EAF13DD2CCCC18C06D7288FFC876CEBFF008CE86992418C0C688DA3EF798BBBF7973801EAE7117C0E037FFB86D51803F88C916D655B516C030A0C8A7FEC4BB3FD7B0535DEDF015C0C041BBA2ECB3C83FF0177351E02515C070D5DED7ABB2D03F18ACFF9BA65514C00E367B4254F3D33F12C9E3BAC18113C054EC170DEA15D63F0348BEF6B9AB12C080B050507916D73F3568A48C1BD511C0FC5BD31227F3D63F815391D073FF10C05809B4B834ACD53F5B4ED14D4E2C10C038D75D8AFF43D33FACBE74D563BA0EC088D800A8F87DCF3F6339FC293C270DC0508C294B5E47C63F2EC7A0F70FA20BC0701DFD0A7DEAB53F56420ABAAF2D0AC0004BBE718A1B93BFDB7248D4CCCC08C0A857AECEFBA9C1BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100129,2,x'0001FFFFFFFFB47233D0CCCC08C0F29DDE9B3A60E4BF6C27D298AB9B3D3DD95C423DBB74A3BF7C02000000110000006C27D298AB9B3D3DD95C423DBB74A3BF4312FD6D6906C5BF89C86B2F7C87C5BFA5E1D73BEBB1D5BFAC813455872CD2BFF64039E1B7BBE0BF32B15E913B9BD8BF2E0752A7FBDEE6BF082BCA38F203DEBF33CF56066437EDBF29B0A5DF532EE1BF6217F9D898DCF1BFB2E0F314A8CEE2BFE5A3685D2C2CF5BFE93B42FAF2DFE3BF8DA8FE6D4B84F8BFF29DDE9B3A60E4BF31286616C5DEFBBF7CF31F7D914EE4BF6B7BB2066435FFBFD049105018ABE3BF3248D908FD4001C04830E5B8FD76E2BF6C2607CF35DF02C02E7AB61D7CB4E0BFDBAB7F7A5D7204C0C04C010DABCDDCBF321EDBAC89F705C03CCC2B2A9B24D7BF25A371EAE96B07C0449E50404378D0BFB47233D0CCCC08C008AA2A00FCA9C1BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100130,1,x'0001FFFFFFFF0000000000000CC0CBA145B6F3FDF7BF000000000000E0BF355EBA490C02F83F7C030000000100000031000000000000000000E0BFFCA9F1D24D62403F18639D232069E0BFE265F7E40120C93F60E11215B4A2E1BFAD0246C9EDE0D83F182C34495EA7E3BF74BB77908262E23F008D7BA3476EE6BF69BC74931804E83F2449FD2E46EBE9BF485AD4728E3CED3F4C264166120FEEBF0ECB991683FAF03F10315010C563F1BFA2B93B32690CF33FFFFFFFFFFFFFF3BFB597FC77E8CAF43F7A807E01CBD0F6BF294820255D2EF63F88DD68D7D0C9F9BF84ED303FB230F73F78711B0D0CDEFCBFA9ACEB377CCDF73F00000000000000C0355EBA490C02F83F434772F9F99001C0AAACEB377CCDF73F3A914B94171B03C085ED303FB230F73FC2BF407F9A9704C0294820255D2EF63FFFFFFFFFFFFF05C0B597FC77E8CAF43F76E7D7771D4E07C0A4B93B32690CF33F6CB66F663B7C08C00FCB991683FAF03FB6AD40742E8509C04C5AD4728E3CED3FC01C21176E640AC06EBC74931804E83FFAF4B26D28160BC076BB77908262E23FA847BBFA52970BC0B50246C9EDE0D83F3AA718F7B7E50BC0F865F7E40120C93F0000000000000CC09AB0F1D24D62403F3AA718F7B7E50BC0688251493DFFC8BFA847BBFA52970BC0F910737B8BD0D8BFFAF4B26D28160BC09F428E69515AE2BFC11C21176E640AC08E438B6CE7FBE7BFB8AD40742E8509C070E1EA4B5D34EDBF6DB66F663B7C08C0A40E25836AF6F0BF78E7D7771D4E07C037FDC69E5008F3BF02000000000006C049DB87E4CFC6F4BFC4BF407F9A9704C0BE8BAB91442AF6BF3E914B94171B03C01931BCAB992CF7BF444772F9F99001C03FF076A463C9F7BF01000000000000C0CBA145B6F3FDF7BF7B711B0D0CDEFCBF40F076A463C9F7BF8DDD68D7D0C9F9BF1B31BCAB992CF7BF7A807E01CBD0F6BFBF8BAB91442AF6BF040000000000F4BF4DDB87E4CFC6F4BF11315010C563F1BF39FDC69E5008F3BF50264166120FEEBFA50E25836AF6F0BF2849FD2E46EBE9BF78E1EA4B5D34EDBF048D7BA3476EE6BF9C438B6CE7FBE7BF1A2C34495EA7E3BFA8428E69515AE2BF64E11215B4A2E1BF1911737B8BD0D8BF18639D232069E0BF948251493DFFC8BF000000000000E0BFFCA9F1D24D62403FFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100130,2,x'0001FFFFFFFF0000000000000CC00000000000000040000000000000E0BF00000000000000407C02000000020000000000000000000CC00000000000000040000000000000E0BF0000000000000040FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100130,3,x'0001FFFFFFFF0000000000000CC000000000000000C0000000000000E0BF00000000000000C07C02000000020000000000000000000CC000000000000000C0000000000000E0BF00000000000000C0FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100130,4,x'0001FFFFFFFF15AE47E17A1406C05A643BDF4F8DE7BFAC1C5A643BDFFBBFD122DBF97E6AF03F7C020000000300000015AE47E17A1406C05A643BDF4F8DE7BFAC1C5A643BDFFBBFD122DBF97E6AF03F105839B4C87600C0B0726891ED7CE73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100130,5,x'0001FFFFFFFFAAF1D24D621002C0D122DBF97E6AF0BFD7A3703D0AD7F3BF5A643BDF4F8DE73F7C0200000003000000AAF1D24D621002C0D122DBF97E6AF0BFD7A3703D0AD7F3BF5A643BDF4F8DE73F4C37894160E5F8BFD122DBF97E6ADC3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100130,6,x'0001FFFFFFFF3108AC1C5A64FDBF3108AC1C5A64E33FAC1C5A643BDFFBBFD122DBF97E6AF03F7C02000000020000003108AC1C5A64FDBF3108AC1C5A64E33FAC1C5A643BDFFBBFD122DBF97E6AF03FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100130,7,x'0001FFFFFFFF5C8FC2F5285CF5BFD34D62105839D43FD7A3703D0AD7F3BF5A643BDF4F8DE73F7C02000000020000005C8FC2F5285CF5BFD34D62105839D43FD7A3703D0AD7F3BF5A643BDF4F8DE73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100131,1,x'0001FFFFFFFFF87C26D2CCCC18C0681FED389A99C9BF62A42D2C3FE10FC0AC281F00FF98D93F7C0200000009000000F87C26D2CCCC18C0681FED389A99C9BFC184BC3D56DC17C0D8760AE678F294BF5D1781C597D716C04260E2FF7999C03FD9A5448851C215C0C89F6350FDC6CF3F19B0348380A014C082978CBB2B59D53FF5B356E24F7613C0D84F2DA8A999D83FC1A3F4A6094812C0AC281F00FF98D93F528280DC061A11C0A448ED907F53D83F62A42D2C3FE10FC08842A9E9D9CDD43FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100131,2,x'0001FFFFFFFF54561F785AB801C0DAD74A0EE632E3BF084422342A1A3E3D1CB403576C8C203D7C0200000009000000084422342A1A3E3D1CB403576C8C203DC4FB3E8DD20ECEBF33CC2B1C4BFBC6BF285656CA5053DFBF2ABD671C8A19D5BF39B80E4FDA53E8BF0C5CA8C44BB0DCBF9A33C73B31B1F0BF2C91016CFC12E1BF9C243FBFF359F5BF7EEC51623BB3E2BFD265C7AC0C13FABFDAD74A0EE632E3BFE6EB97D617CBFEBFA0E6B1562690E2BF54561F785AB801C02EE20F8353CDE0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100132,1,x'0001FFFFFFFF0000000000001EC0000000000000F83F000000000000E0BF000000000000F83F7C0200000002000000000000000000E0BF000000000000F83F0000000000001EC0000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100132,2,x'0001FFFFFFFF0000000000001CC00000000000000000000000000000F0BF000000000000F03F7C02000000050000000000000000001CC0000000000000000000000000000018C0000000000000000000000000000018C0000000000000F03F00000000000010C00000000000000000000000000000F0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100132,3,x'0001FFFFFFFF00000000000000C0000000000000E8BF000000000000F0BF000000000000E83F7C020000000300000000000000000000C0000000000000E83F000000000000F0BF000000000000000000000000000000C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100132,4,x'0001FFFFFFFF0000000000001EC0000000000000F8BF000000000000E0BF000000000000F8BF7C0200000002000000000000000000E0BF000000000000F8BF0000000000001EC0000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100133,1,x'0001FFFFFFFF00000000000018C000000000000000000000000000000000000000000000F03F7C020000000500000000000000000018C0000000000000000000000000000014C0000000000000000000000000000014C0000000000000F03F00000000000008C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100133,2,x'0001FFFFFFFF000000000000F0BF000000000000E8BF0000000000000000000000000000E83F7C0200000003000000000000000000F0BF000000000000E83F00000000000000000000000000000000000000000000F0BF000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100133,3,x'0001FFFFFFFF00000000000000C0000000000000E8BF000000000000F0BF000000000000E83F7C020000000300000000000000000000C0000000000000E8BF000000000000F0BF000000000000000000000000000000C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100134,1,x'0001FFFFFFFF0000000000001EC0000000000000F83F000000000000E0BF000000000000F83F7C0200000002000000000000000000E0BF000000000000F83F0000000000001EC0000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100134,2,x'0001FFFFFFFF0000000000001CC00000000000000000000000000000F0BF000000000000F03F7C02000000050000000000000000001CC0000000000000000000000000000018C0000000000000000000000000000018C0000000000000F03F00000000000010C00000000000000000000000000000F0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100134,3,x'0001FFFFFFFF00000000000000C0000000000000E8BF000000000000F0BF000000000000E83F7C020000000300000000000000000000C0000000000000E83F000000000000F0BF000000000000000000000000000000C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100134,4,x'0001FFFFFFFF00000000000008C0000000000000E8BF00000000000000C0000000000000E83F7C020000000300000000000000000008C0000000000000E8BF00000000000000C0000000000000000000000000000008C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100134,5,x'0001FFFFFFFF0000000000001EC0000000000000F8BF000000000000E0BF000000000000F8BF7C0200000002000000000000000000E0BF000000000000F8BF0000000000001EC0000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100135,1,x'0001FFFFFFFF00000000000018C000000000000000000000000000000000000000000000F03F7C020000000500000000000000000018C0000000000000000000000000000014C0000000000000000000000000000014C0000000000000F03F00000000000008C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100136,1,x'0001FFFFFFFF00000000000018C000000000000000000000000000000000000000000000F03F7C020000000500000000000000000018C0000000000000000000000000000014C0000000000000000000000000000014C0000000000000F03F00000000000008C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100136,2,x'0001FFFFFFFF000000000000F0BF000000000000E8BF0000000000000000000000000000E83F7C0200000003000000000000000000F0BF000000000000E83F00000000000000000000000000000000000000000000F0BF000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100136,3,x'0001FFFFFFFF00000000000000C0000000000000E8BF000000000000F0BF000000000000E83F7C020000000300000000000000000000C0000000000000E8BF000000000000F0BF000000000000000000000000000000C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100136,4,x'0001FFFFFFFF00000000000008C0000000000000E8BF00000000000000C0000000000000E83F7C020000000300000000000000000008C0000000000000E83F00000000000000C0000000000000000000000000000008C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100137,1,x'0001FFFFFFFF0000000000001EC0000000000000F83F000000000000E0BF000000000000F83F7C0200000002000000000000000000E0BF000000000000F83F0000000000001EC0000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100137,2,x'0001FFFFFFFF0000000000001CC00000000000000000000000000000F0BF000000000000F03F7C02000000050000000000000000001CC0000000000000000000000000000018C0000000000000000000000000000018C0000000000000F03F00000000000010C00000000000000000000000000000F0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100137,3,x'0001FFFFFFFF00000000000000C0000000000000E8BF000000000000F0BF000000000000E83F7C020000000300000000000000000000C0000000000000E83F000000000000F0BF000000000000000000000000000000C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100137,4,x'0001FFFFFFFF00000000000008C0000000000000E8BF00000000000000C0000000000000E83F7C020000000300000000000000000008C0000000000000E8BF00000000000000C0000000000000000000000000000008C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100137,5,x'0001FFFFFFFF00000000000010C0000000000000E8BF00000000000008C0000000000000E83F7C020000000300000000000000000010C0000000000000E83F00000000000008C0000000000000000000000000000010C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100137,6,x'0001FFFFFFFF0000000000001EC0000000000000F8BF000000000000E0BF000000000000F8BF7C0200000002000000000000000000E0BF000000000000F8BF0000000000001EC0000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100138,1,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C02000000020000000000000000001EC00000000000000000000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100138,2,x'0001FFFFFFFF0000000000001AC0000000000000F0BF000000000000F8BF000000000000F0BF7C0200000002000000000000000000F8BF000000000000F0BF0000000000001AC0000000000000F0BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100138,3,x'0001FFFFFFFF00000000000014C000000000000000C000000000000008C000000000000000C07C020000000200000000000000000014C000000000000000C000000000000008C000000000000000C0FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100139,1,x'0001FFFFFFFF0000000000001CC00000000000000000000000000000F0BF000000000000F03F7C02000000050000000000000000001CC0000000000000000000000000000018C0000000000000000000000000000018C0000000000000F03F00000000000010C00000000000000000000000000000F0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100139,2,x'0001FFFFFFFFCDCCCCCCCCCC1EC0000000000000F83F676666666666E6BF000000000000F83F7C0200000002000000676666666666E6BF000000000000F83FCDCCCCCCCCCC1EC0000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100139,3,x'0001FFFFFFFFCDCCCCCCCCCC1EC0000000000000F8BF676666666666E6BF000000000000F8BF7C0200000002000000CDCCCCCCCCCC1EC0000000000000F8BF676666666666E6BF000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100140,1,x'0001FFFFFFFF00000000000018C000000000000000000000000000000000000000000000F03F7C020000000500000000000000000018C0000000000000000000000000000014C0000000000000000000000000000014C0000000000000F03F00000000000008C0000000000000000000000000000000000000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100140,2,x'0001FFFFFFFF000000000000F0BF000000000000E8BF0000000000000000000000000000E83F7C0200000003000000000000000000F0BF000000000000E83F00000000000000000000000000000000000000000000F0BF000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100141,1,x'0001FFFFFFFF0000000000001EC0000000000000E8BF00000000000016C0000000000000E83F7C020000000300000000000000000016C0000000000000E8BF0000000000001EC0000000000000000000000000000016C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100141,2,x'0001FFFFFFFF00000000000010C0000000000000E8BF00000000000010C0000000000000E83F7C020000000200000000000000000010C0000000000000E83F00000000000010C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100141,3,x'0001FFFFFFFF00000000000004C0000000000000E8BF000000000000E0BF000000000000E83F7C020000000300000000000000000004C0000000000000E8BF000000000000E0BF000000000000000000000000000004C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100141,4,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C0200000002000000000000000000E0BF00000000000000000000000000001EC00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100142,1,x'0001FFFFFFFF0000000000001EC0000000000000F83F000000000000E0BF000000000000F83F7C02000000020000000000000000001EC0000000000000F83F000000000000E0BF000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100142,2,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C0200000002000000000000000000E0BF00000000000000000000000000001EC00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100142,3,x'0001FFFFFFFF0000000000001EC0000000000000F8BF000000000000E0BF000000000000F8BF7C02000000020000000000000000001EC0000000000000F8BF000000000000E0BF000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100142,4,x'0001FFFFFFFF00000000000004C0000000000000E8BF000000000000E0BF000000000000E83F7C020000000300000000000000000004C0000000000000E8BF000000000000E0BF000000000000000000000000000004C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100142,5,x'0001FFFFFFFF00000000000010C0000000000000E8BF00000000000010C0000000000000E83F7C020000000200000000000000000010C0000000000000E83F00000000000010C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100142,6,x'0001FFFFFFFF0000000000001EC0000000000000E8BF00000000000016C0000000000000E83F7C020000000300000000000000000016C0000000000000E8BF0000000000001EC0000000000000000000000000000016C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100143,1,x'0001FFFFFFFF0000000000001EC0000000000000F83F000000000000E0BF000000000000F83F7C02000000020000000000000000001EC0000000000000F83F000000000000E0BF000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100143,2,x'0001FFFFFFFF0000000000001EC0000000000000F8BF000000000000E0BF000000000000F8BF7C02000000020000000000000000001EC0000000000000F8BF000000000000E0BF000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100144,1,x'0001FFFFFFFF0000000000001EC0000000000000E8BF00000000000016C0000000000000E83F7C020000000300000000000000000016C0000000000000E83F0000000000001EC0000000000000000000000000000016C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100144,2,x'0001FFFFFFFF00000000000012C0000000000000E8BF00000000000012C0000000000000E83F7C020000000200000000000000000012C0000000000000E8BF00000000000012C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100144,3,x'0001FFFFFFFF0000000000000CC0000000000000E8BF0000000000000CC0000000000000E83F7C02000000020000000000000000000CC0000000000000E83F0000000000000CC0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100144,4,x'0001FFFFFFFF00000000000004C0000000000000E8BF000000000000E0BF000000000000E83F7C020000000300000000000000000004C0000000000000E8BF000000000000E0BF000000000000000000000000000004C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100144,5,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C0200000002000000000000000000E0BF00000000000000000000000000001EC00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100145,1,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C02000000020000000000000000001EC00000000000000000000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100145,2,x'0001FFFFFFFF00000000000010C0000000000000E8BF00000000000010C0000000000000E83F7C020000000200000000000000000010C0000000000000E83F00000000000010C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100146,1,x'0001FFFFFFFF0000000000001EC0000000000000F83F000000000000E0BF000000000000F83F7C02000000020000000000000000001EC0000000000000F83F000000000000E0BF000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100146,2,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C0200000002000000000000000000E0BF00000000000000000000000000001EC00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100146,3,x'0001FFFFFFFF0000000000001EC0000000000000F8BF000000000000E0BF000000000000F8BF7C02000000020000000000000000001EC0000000000000F8BF000000000000E0BF000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100146,4,x'0001FFFFFFFF00000000000004C0000000000000E8BF000000000000E0BF000000000000E83F7C020000000300000000000000000004C0000000000000E8BF000000000000E0BF000000000000000000000000000004C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100146,5,x'0001FFFFFFFF0000000000000CC0000000000000E8BF0000000000000CC0000000000000E83F7C02000000020000000000000000000CC0000000000000E83F0000000000000CC0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100146,6,x'0001FFFFFFFF00000000000012C0000000000000E8BF00000000000012C0000000000000E83F7C020000000200000000000000000012C0000000000000E8BF00000000000012C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100146,7,x'0001FFFFFFFF0000000000001EC0000000000000E8BF00000000000016C0000000000000E83F7C020000000300000000000000000016C0000000000000E83F0000000000001EC0000000000000000000000000000016C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100147,1,x'0001FFFFFFFF00000000000010C0D578E9263108E8BF00000000000010C02B8716D9CEF7E73F7C020000000200000000000000000010C0D578E9263108E8BF00000000000010C02B8716D9CEF7E73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100147,2,x'0001FFFFFFFF4FCC3C9010D81DC0B216AFF84260E7BFA30611D2FFFF17C0B216AFF84260E73F7C030000000100000031000000A30611D2FFFF17C08AC34DAE05C9A9BC654B3C19660618C02BA62EB3D268B83F5CDEB4E67C1918C0266B480E5D33C83F9EBF279DF03818C0DBABBAD127E4D13F4E6E3878376418C0AE16AFF84260D73F377AF4E7939A18C05C35EFACF975DC3FB52127CF17DB18C01C3EFE0F8387E03F23F65796A82419C00D7A9349A28BE23F0EF89B01047619C056D973C7853EE43FBB3E0BB4C5CD19C0D44EF99FBC98E53F1FA6B4486D2A1AC0E85890535A94E63FE02E5AE6648A1AC09FF054BF102DE73F79E9263108EC1AC0B216AFF84260E73F12A4F37BAB4D1BC09FF054BF102DE73FD22C9919A3AD1BC0EA5890535A94E63F379442AE4A0A1CC0D64EF99FBC98E53FE4DAB1600C621CC058D973C7853EE43FCFDCF5CB67B31CC0117A9349A28BE23F3DB12693F8FC1CC01F3EFE0F8387E03FBB58597A7C3D1DC06635EFACF975DC3FA46415EAD8731DC0B916AFF84260D73F541326C51F9F1DC0E2ABBAD127E4D13F96F4987B93BE1DC0396B480E5D33C83F8D871149AAD11DC05BA62EB3D268B83F4FCC3C9010D81DC0A752BA42C456B33C8D871149AAD11DC007A62EB3D268B8BF96F4987B93BE1DC01B6B480E5D33C8BF541326C51F9F1DC0D9ABBAD127E4D1BFA46415EAD8731DC0A716AFF84260D7BFBB58597A7C3D1DC05935EFACF975DCBF3DB12693F8FC1CC01C3EFE0F8387E0BFCFDCF5CB67B31CC00C7A9349A28BE2BFE4DAB1600C621CC054D973C7853EE4BF379442AE4A0A1CC0D34EF99FBC98E5BFD32C9919A3AD1BC0E85890535A94E6BF12A4F37BAB4D1BC09FF054BF102DE7BF79E9263108EC1AC0B216AFF84260E7BFE02E5AE6648A1AC09FF054BF102DE7BF20A6B4486D2A1AC0EA5890535A94E6BFBB3E0BB4C5CD19C0D64EF99FBC98E5BF0EF89B01047619C05BD973C7853EE4BF23F65796A82419C00F7A9349A28BE2BFB52127CF17DB18C0203EFE0F8387E0BF377AF4E7939A18C06635EFACF975DCBF4E6E3878376418C0BB16AFF84260D7BF9EBF279DF03818C0E9ABBAD127E4D1BF5CDEB4E67C1918C0486B480E5D33C8BF654B3C19660618C04BA62EB3D268B8BFA30611D2FFFF17C08AC34DAE05C9A9BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100147,3,x'0001FFFFFFFF4CE1E559000000C0485E665F55E3E7BFA2C8CAA85639E0BF485E665F55E3E73F7C030000000100000031000000A2C8CAA85639E0BF825248539A59AABCF77928F2A76DE0BF4F719686B0F1B83FF03991A4B609E1BF1EA9CD200FBBC83FE550BD2ED70AE2BFC80D023F7948D23F14A0FC49A36CE3BF445E665F55E3D73F101F903F0D29E5BF174C0FED8E15DD3F38A4C46C7A38E7BFB0826C9B31E4E03FDB80A991E491E9BFD707A1C89EF3E23FC5F77D58012BECBFD38634BE08B0E43F0220B0686FF8EEBF03D673D9D411E63F4FDEFE1FF4F6F0BFFAEC9F63F512E73F5E2CAFFB3A7FF2BFF3AC081604AFE73F74931804560EF4BF485E665F55E3E73F89FA810C719DF5BFF4AC081604AFE73F974832E8B725F7BFFBEC9F63F512E73FE716D95374A0F8BF05D673D9D411E63F052BF25B2B07FABFD68634BE08B0E43F7A665CBFB953FBBFDB07A1C89EF3E23FCDD4CED16E80FCBFB2826C9B31E4E03F601769682588FDBF214C0FED8E15DD3FDFD632635A66FEBF4F5E665F55E3D73F777ED2704017FFBFCF0D023F7948D23FF289E8B5D097FFBF31A9CD200FBBC83FEEE91C0FD8E5FFBF80719686B0F1B83F4CE1E559000000C0E23D76BE33C3B33CEFE91C0FD8E5FFBF2A719686B0F1B8BFF289E8B5D097FFBF13A9CD200FBBC8BF787ED2704017FFBFC60D023F7948D2BFE0D632635A66FEBF3D5E665F55E3D7BF631769682588FDBF144C0FED8E15DDBFCFD4CED16E80FCBFB0826C9B31E4E0BF7D665CBFB953FBBFD607A1C89EF3E2BF092BF25B2B07FABFD28634BE08B0E4BFEB16D95374A0F8BF02D673D9D411E6BF9D4832E8B725F7BFF9EC9F63F512E7BF8CFA810C719DF5BFF3AC081604AFE7BF77931804560EF4BF485E665F55E3E7BF612CAFFB3A7FF2BFF4AC081604AFE7BF53DEFE1FF4F6F0BFFBEC9F63F512E7BF0520B0686FF8EEBF05D673D9D411E6BFCBF77D58012BECBFD88634BE08B0E4BFDE80A991E491E9BFDA07A1C89EF3E2BF3BA4C46C7A38E7BFB3826C9B31E4E0BF141F903F0D29E5BF214C0FED8E15DDBF18A0FC49A36CE3BF515E665F55E3D7BFE850BD2ED70AE2BFD60D023F7948D2BFF13991A4B609E1BF40A9CD200FBBC8BFF77928F2A76DE0BF6F719686B0F1B8BFA2C8CAA85639E0BF825248539A59AABCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100147,4,x'0001FFFFFFFF00000000000018C0000000000000000000000000000000C000000000000000007C020000000200000000000000000018C0000000000000000000000000000000C00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100148,1,x'0001FFFFFFFF00000000000010C0D578E9263108E8BF00000000000010C02B8716D9CEF7E73F7C020000000200000000000000000010C0D578E9263108E8BF00000000000010C02B8716D9CEF7E73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100148,2,x'0001FFFFFFFF4FCC3C9010D81DC0B216AFF84260E7BFA30611D2FFFF17C0B216AFF84260E73F7C030000000100000031000000A30611D2FFFF17C08AC34DAE05C9A9BC654B3C19660618C02BA62EB3D268B83F5CDEB4E67C1918C0266B480E5D33C83F9EBF279DF03818C0DBABBAD127E4D13F4E6E3878376418C0AE16AFF84260D73F377AF4E7939A18C05C35EFACF975DC3FB52127CF17DB18C01C3EFE0F8387E03F23F65796A82419C00D7A9349A28BE23F0EF89B01047619C056D973C7853EE43FBB3E0BB4C5CD19C0D44EF99FBC98E53F1FA6B4486D2A1AC0E85890535A94E63FE02E5AE6648A1AC09FF054BF102DE73F79E9263108EC1AC0B216AFF84260E73F12A4F37BAB4D1BC09FF054BF102DE73FD22C9919A3AD1BC0EA5890535A94E63F379442AE4A0A1CC0D64EF99FBC98E53FE4DAB1600C621CC058D973C7853EE43FCFDCF5CB67B31CC0117A9349A28BE23F3DB12693F8FC1CC01F3EFE0F8387E03FBB58597A7C3D1DC06635EFACF975DC3FA46415EAD8731DC0B916AFF84260D73F541326C51F9F1DC0E2ABBAD127E4D13F96F4987B93BE1DC0396B480E5D33C83F8D871149AAD11DC05BA62EB3D268B83F4FCC3C9010D81DC0A752BA42C456B33C8D871149AAD11DC007A62EB3D268B8BF96F4987B93BE1DC01B6B480E5D33C8BF541326C51F9F1DC0D9ABBAD127E4D1BFA46415EAD8731DC0A716AFF84260D7BFBB58597A7C3D1DC05935EFACF975DCBF3DB12693F8FC1CC01C3EFE0F8387E0BFCFDCF5CB67B31CC00C7A9349A28BE2BFE4DAB1600C621CC054D973C7853EE4BF379442AE4A0A1CC0D34EF99FBC98E5BFD32C9919A3AD1BC0E85890535A94E6BF12A4F37BAB4D1BC09FF054BF102DE7BF79E9263108EC1AC0B216AFF84260E7BFE02E5AE6648A1AC09FF054BF102DE7BF20A6B4486D2A1AC0EA5890535A94E6BFBB3E0BB4C5CD19C0D64EF99FBC98E5BF0EF89B01047619C05BD973C7853EE4BF23F65796A82419C00F7A9349A28BE2BFB52127CF17DB18C0203EFE0F8387E0BF377AF4E7939A18C06635EFACF975DCBF4E6E3878376418C0BB16AFF84260D7BF9EBF279DF03818C0E9ABBAD127E4D1BF5CDEB4E67C1918C0486B480E5D33C8BF654B3C19660618C04BA62EB3D268B8BFA30611D2FFFF17C08AC34DAE05C9A9BCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100148,3,x'0001FFFFFFFF4CE1E559000000C0485E665F55E3E7BFA2C8CAA85639E0BF485E665F55E3E73F7C030000000100000031000000A2C8CAA85639E0BF825248539A59AABCF77928F2A76DE0BF4F719686B0F1B83FF03991A4B609E1BF1EA9CD200FBBC83FE550BD2ED70AE2BFC80D023F7948D23F14A0FC49A36CE3BF445E665F55E3D73F101F903F0D29E5BF174C0FED8E15DD3F38A4C46C7A38E7BFB0826C9B31E4E03FDB80A991E491E9BFD707A1C89EF3E23FC5F77D58012BECBFD38634BE08B0E43F0220B0686FF8EEBF03D673D9D411E63F4FDEFE1FF4F6F0BFFAEC9F63F512E73F5E2CAFFB3A7FF2BFF3AC081604AFE73F74931804560EF4BF485E665F55E3E73F89FA810C719DF5BFF4AC081604AFE73F974832E8B725F7BFFBEC9F63F512E73FE716D95374A0F8BF05D673D9D411E63F052BF25B2B07FABFD68634BE08B0E43F7A665CBFB953FBBFDB07A1C89EF3E23FCDD4CED16E80FCBFB2826C9B31E4E03F601769682588FDBF214C0FED8E15DD3FDFD632635A66FEBF4F5E665F55E3D73F777ED2704017FFBFCF0D023F7948D23FF289E8B5D097FFBF31A9CD200FBBC83FEEE91C0FD8E5FFBF80719686B0F1B83F4CE1E559000000C0E23D76BE33C3B33CEFE91C0FD8E5FFBF2A719686B0F1B8BFF289E8B5D097FFBF13A9CD200FBBC8BF787ED2704017FFBFC60D023F7948D2BFE0D632635A66FEBF3D5E665F55E3D7BF631769682588FDBF144C0FED8E15DDBFCFD4CED16E80FCBFB0826C9B31E4E0BF7D665CBFB953FBBFD607A1C89EF3E2BF092BF25B2B07FABFD28634BE08B0E4BFEB16D95374A0F8BF02D673D9D411E6BF9D4832E8B725F7BFF9EC9F63F512E7BF8CFA810C719DF5BFF3AC081604AFE7BF77931804560EF4BF485E665F55E3E7BF612CAFFB3A7FF2BFF4AC081604AFE7BF53DEFE1FF4F6F0BFFBEC9F63F512E7BF0520B0686FF8EEBF05D673D9D411E6BFCBF77D58012BECBFD88634BE08B0E4BFDE80A991E491E9BFDA07A1C89EF3E2BF3BA4C46C7A38E7BFB3826C9B31E4E0BF141F903F0D29E5BF214C0FED8E15DDBF18A0FC49A36CE3BF515E665F55E3D7BFE850BD2ED70AE2BFD60D023F7948D2BFF13991A4B609E1BF40A9CD200FBBC8BFF77928F2A76DE0BF6F719686B0F1B8BFA2C8CAA85639E0BF825248539A59AABCFE',3,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100148,4,x'0001FFFFFFFF00000000000018C0000000000000000000000000000000C000000000000000007C020000000200000000000000000018C0000000000000000000000000000000C00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100148,5,x'0001FFFFFFFF0000000000001EC096438B6CE7FBF73F000000000000E0BF96438B6CE7FBF73F7C02000000020000000000000000001EC096438B6CE7FBF73F000000000000E0BF96438B6CE7FBF73FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100148,6,x'0001FFFFFFFF0000000000001EC06BBC74931804F8BF000000000000E0BF6BBC74931804F8BF7C02000000020000000000000000001EC06BBC74931804F8BF000000000000E0BF6BBC74931804F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100149,1,x'0001FFFFFFFF00000000000008C0000000000000E8BF00000000000008C0000000000000E83F7C020000000200000000000000000008C0000000000000E83F00000000000008C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100149,2,x'0001FFFFFFFF00000000000010C0000000000000E8BF00000000000010C0000000000000E83F7C020000000200000000000000000010C0000000000000E8BF00000000000010C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100149,3,x'0001FFFFFFFF00000000000014C0000000000000E8BF00000000000014C0000000000000E83F7C020000000200000000000000000014C0000000000000E83F00000000000014C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100149,4,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C02000000020000000000000000001EC00000000000000000000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100150,1,x'0001FFFFFFFF0000000000001EC0000000000000F83F000000000000E0BF000000000000F83F7C0200000002000000000000000000E0BF000000000000F83F0000000000001EC0000000000000F83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100150,2,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C02000000020000000000000000001EC00000000000000000000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100150,3,x'0001FFFFFFFF0000000000001EC0000000000000F8BF000000000000E0BF000000000000F8BF7C0200000002000000000000000000E0BF000000000000F8BF0000000000001EC0000000000000F8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100150,4,x'0001FFFFFFFF00000000000014C0000000000000E8BF00000000000014C0000000000000E83F7C020000000200000000000000000014C0000000000000E8BF00000000000014C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100150,5,x'0001FFFFFFFF00000000000010C0000000000000E8BF00000000000010C0000000000000E83F7C020000000200000000000000000010C0000000000000E83F00000000000010C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100150,6,x'0001FFFFFFFF00000000000008C0000000000000E8BF00000000000008C0000000000000E83F7C020000000200000000000000000008C0000000000000E8BF00000000000008C0000000000000E83FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100151,1,x'0001FFFFFFFF0000000000001EC0000000000000000000000000000016C0000000000000F03F7C02000000210000000000000000001EC0075C143326A6A13CA5247AB411FB1DC035B429BCA617B93F96EBFEF952EC1DC00EA6693CB8F8C83FBBC5D82AE8D31DC0079FD52E0694D23FA951E6790DB21DC065A9AEA6E27DD83FB617305E16871DC03DF606385D2BDE3F34D421C56C531DC0C968AE393BC7E13FE8A2620D90171DC0D71D0925F34CE43F7AE7CFCC13D41CC0CD3B7F669EA0E63FBB23A1649E891CC04217156B80BCE83F19CD3567E7381CC0A4A10E29669BEA3F646F80D3B5E21BC0B1BD80F1B238EC3F96EA6A2ADE871BC0468D32CF6B90ED3FF059ED6240291BC0DB2DC656419FEE3F304DE3C1C5C71AC0B05CF7CF9762EF3FD1A6F09A5E641AC02525D1A38DD8EF3F0000000000001AC0000000000000F03F2F590F65A19B19C02625D1A38DD8EF3FD0B21C3E3A3819C0B05CF7CF9762EF3F10A6129DBFD618C0DB2DC656419FEE3F6A1595D5217818C0468D32CF6B90ED3F9C907F2C4A1D18C0B0BD80F1B238EC3FE732CA9818C717C0A4A10E29669BEA3F45DC5E9B617617C04117156B80BCE83F86183033EC2B17C0CC3B7F669EA0E63F185D9DF26FE816C0D51D0925F34CE43FCC2BDE3A93AC16C0C768AE393BC7E13F4AE8CFA1E97816C03DF606385D2BDE3F57AE1986F24D16C063A9AEA6E27DD83F453A27D5172C16C0049FD52E0694D23F6A140106AD1316C013A6693CB8F8C83F5BDB854BEE0416C033B429BCA617B93F00000000000016C00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100151,2,x'0001FFFFFFFF0000000000001EC0000000000000000000000000000016C000000000000000007C020000000200000000000000000016C000000000000000000000000000001EC00000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100151,3,x'0001FFFFFFFF4A0C022B87961DC0000000000000000039B4C876BE9F19C083C0CAA145B6EF3F7C02000000020000004A0C022B87961DC0000000000000000039B4C876BE9F19C083C0CAA145B6EF3FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100151,4,x'0001FFFFFFFFC3F5285C8FC21AC000000000000000002FDD2406819517C09CC420B07268E93F7C0200000002000000C3F5285C8FC21AC000000000000000002FDD2406819517C09CC420B07268E93FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100151,5,x'0001FFFFFFFF3CDF4F8D97EE17C000000000000000000C022B87165916C0F2D24D621058D93F7C02000000020000003CDF4F8D97EE17C000000000000000000C022B87165916C0F2D24D621058D93FFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100151,6,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C02000000020000000000000000001EC00000000000000000000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100151,7,x'0001FFFFFFFF00000000000004C00000000000000000000000000000E0BF000000000000E83F7C020000000200000000000000000004C0000000000000E83F000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100151,8,x'0001FFFFFFFF00000000000004C0000000000000E8BF000000000000E0BF00000000000000007C020000000200000000000000000004C0000000000000E8BF000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100152,1,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C02000000020000000000000000001EC00000000000000000000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100152,2,x'0001FFFFFFFF00000000000004C0000000000000E8BF000000000000E0BF000000000000E83F7C020000000300000000000000000004C0000000000000E83F000000000000E0BF000000000000000000000000000004C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100153,1,x'0001FFFFFFFFA584100000001EC000000018115755BE5FDE1800000016C027DD985A0C73EE3F7C0200000021000000A584100000001EC000000018115755BE0D213CA78BF61DC0AA0DFAD1873EB83F54822787EDE31DC08C0EEB0FCC13C83FD011CEAB50C81DC02A2DF0F1F9E0D13F7F276CEDF4A31DC0036982DB5C87D73FBFC3E05C2E771DC0A981AA82FEEFDC3FB0244E8164421DC0CDB85DB72E07E13F78A2BA6811061DC0CC4D51ED516BE33FAF48DB8DC0C21CC08ED71689E19EE53FF6AE94950D791CC0FFC18581C69CE73FA1B91BE7A2291CC0767535E36560E93F3056F62138D51BC022AA6576ABE5EA3F432E6B75907C1BC096F3602D1329EC3F5DF835DD78201BC0F81A8B45B127ED3FB5DC9347C6C11AC097924F0839DFED3F8CC6EFA853611AC0DA77521C024EEE3F1BF7A00100001AC027DD985A0C73EE3F94634E5AAC9E19C059C7CB1E024EEE3FE0099FBB393E19C048793C0D39DFED3F3F45EA2587DF18C07835E04CB127ED3F1D2C9B8D6F8318C0C14D0D371329EC3F8722EFE0C72A18C045E65282ABE5EA3F092BA21B5DD617C00D0048F16560E93FC64AFB6CF28617C06E119D91C69CE73F69D980743F3D17C061B70D9BE19EE53F24336899EEF916C0BD34FE00526BE33F147496809BBD16C0CD2893CC2E07E13FB637C1A4D18816C07660C4AFFEEFDC3F3770EF130B5C16C0E0FEE20A5D87D73F79FE4355AF3716C006EF2923FAE0D13FDA8C9E79121C16C008482D75CC13C83F16233C59740916C00CAC47A0883EB83F5FDE1800000016C00000002D61B75E3EFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100153,2,x'0001FFFFFFFF0000000000001EC00000000000000000000000000000E0BF00000000000000007C02000000020000000000000000001EC00000000000000000000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100153,3,x'0001FFFFFFFF00000000000004C00000000000000000000000000000E0BF000000000000E83F7C020000000200000000000000000004C0000000000000E83F000000000000E0BF0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100153,4,x'0001FFFFFFFF00000000000004C0000000000000E8BF000000000000E0BF00000000000000007C0200000002000000000000000000E0BF000000000000000000000000000004C0000000000000E8BFFE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100154,1,x'0001FFFFFFFF6B7335964931E8BF6B7335964931E8BF6B7335964931E83F6B7335964931E83F7C0300000001000000310000006B7335964931E83F3FDD594D97AFAABC8BE16D924DFCE73F1D40ADFE1643B93FBBAF9B9C415EE73F5A103D52C30BC93F397BB7FCD959E63FFC4536122384D23F110DD4548BF3E43F677335964931D83F34D3E11C7731E33F147DA5127874DD3FA46B0CC8501BE13FA26B0CC8501BE13F1D7DA5127874DD3F31D3E11C7731E33F707335964931D83F0E0DD4548BF3E43F034636122384D23F377BB7FCD959E63F6C103D52C30BC93FBAAF9B9C415EE73F3F40ADFE1643B93F8BE16D924DFCE73F472A5890BEADB03C6B7335964931E83F1340ADFE1643B9BF8CE16D924DFCE73F50103D52C30BC9BFBCAF9B9C415EE73FFB4536122384D2BF397BB7FCD959E63F657335964931D8BF110DD4548BF3E43F107DA5127874DDBF35D3E11C7731E33FA26B0CC8501BE1BFA46B0CC8501BE13F31D3E11C7731E3BF1E7DA5127874DD3F0E0DD4548BF3E4BF737335964931D83F377BB7FCD959E6BF044636122384D23FBAAF9B9C415EE7BF6D103D52C30BC93F8BE16D924DFCE7BF4E40ADFE1643B93F6B7335964931E8BFEF65037AB103B43C8CE16D924DFCE7BFF83FADFE1643B9BFBCAF9B9C415EE7BF4F103D52C30BC9BF3A7BB7FCD959E6BFFB4536122384D2BF130DD4548BF3E4BF607335964931D8BF35D3E11C7731E3BF107DA5127874DDBFA56B0CC8501BE1BFA26B0CC8501BE1BF1E7DA5127874DDBF30D3E11C7731E3BF747335964931D8BF0D0DD4548BF3E4BF0A4636122384D2BF357BB7FCD959E6BF7B103D52C30BC9BFBAAF9B9C415EE7BF3B40ADFE1643B9BF8BE16D924DFCE7BF97A1AE63A459B7BC6B7335964931E8BF0D40ADFE1643B93F8CE16D924DFCE7BF4D103D52C30BC93FBCAF9B9C415EE7BFFF4536122384D23F387BB7FCD959E6BF5F7335964931D83F130DD4548BF3E4BF147DA5127874DD3F34D3E11C7731E3BFA16B0CC8501BE13FA56B0CC8501BE1BF30D3E11C7731E33F1E7DA5127874DDBF0D0DD4548BF3E43F747335964931D8BF357BB7FCD959E63F0A4636122384D2BFBAAF9B9C415EE73F7C103D52C30BC9BF8BE16D924DFCE73F3E40ADFE1643B9BF6B7335964931E83F3FDD594D97AFAABCFE',2,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100154,2,x'0001FFFFFFFF9A9999999999A9BF00000000000000009A9999999999A93F00000000000000007C02000000020000009A9999999999A9BF00000000000000009A9999999999A93F0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100155,1,x'0001FFFFFFFF6B7335964931E8BF6B7335964931E8BF6B7335964931E83F6B7335964931E83F7C0300000001000000310000006B7335964931E83F3FDD594D97AFAABC8BE16D924DFCE73F1D40ADFE1643B93FBBAF9B9C415EE73F5A103D52C30BC93F397BB7FCD959E63FFC4536122384D23F110DD4548BF3E43F677335964931D83F34D3E11C7731E33F147DA5127874DD3FA46B0CC8501BE13FA26B0CC8501BE13F1D7DA5127874DD3F31D3E11C7731E33F707335964931D83F0E0DD4548BF3E43F034636122384D23F377BB7FCD959E63F6C103D52C30BC93FBAAF9B9C415EE73F3F40ADFE1643B93F8BE16D924DFCE73F472A5890BEADB03C6B7335964931E83F1340ADFE1643B9BF8CE16D924DFCE73F50103D52C30BC9BFBCAF9B9C415EE73FFB4536122384D2BF397BB7FCD959E63F657335964931D8BF110DD4548BF3E43F107DA5127874DDBF35D3E11C7731E33FA26B0CC8501BE1BFA46B0CC8501BE13F31D3E11C7731E3BF1E7DA5127874DD3F0E0DD4548BF3E4BF737335964931D83F377BB7FCD959E6BF044636122384D23FBAAF9B9C415EE7BF6D103D52C30BC93F8BE16D924DFCE7BF4E40ADFE1643B93F6B7335964931E8BFEF65037AB103B43C8CE16D924DFCE7BFF83FADFE1643B9BFBCAF9B9C415EE7BF4F103D52C30BC9BF3A7BB7FCD959E6BFFB4536122384D2BF130DD4548BF3E4BF607335964931D8BF35D3E11C7731E3BF107DA5127874DDBFA56B0CC8501BE1BFA26B0CC8501BE1BF1E7DA5127874DDBF30D3E11C7731E3BF747335964931D8BF0D0DD4548BF3E4BF0A4636122384D2BF357BB7FCD959E6BF7B103D52C30BC9BFBAAF9B9C415EE7BF3B40ADFE1643B9BF8BE16D924DFCE7BF97A1AE63A459B7BC6B7335964931E8BF0D40ADFE1643B93F8CE16D924DFCE7BF4D103D52C30BC93FBCAF9B9C415EE7BFFF4536122384D23F387BB7FCD959E6BF5F7335964931D83F130DD4548BF3E4BF147DA5127874DD3F34D3E11C7731E3BFA16B0CC8501BE13FA56B0CC8501BE1BF30D3E11C7731E33F1E7DA5127874DDBF0D0DD4548BF3E43F747335964931D8BF357BB7FCD959E63F0A4636122384D2BFBAAF9B9C415EE73F7C103D52C30BC9BF8BE16D924DFCE73F3E40ADFE1643B9BF6B7335964931E83F3FDD594D97AFAABCFE',2,NULL,x'1000');
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100155,2,x'0001FFFFFFFF9A9999999999A9BF00000000000000009A9999999999A93F00000000000000007C02000000020000009A9999999999A9BF00000000000000009A9999999999A93F0000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100155,3,x'0001FFFFFFFF000000000000E83F0000000000000000000000000000174000000000000000007C0200000002000000000000000000E83F000000000000000000000000000017400000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100155,4,x'0001FFFFFFFF3333333333331C400000000000000000CDCCCCCCCCCC1D4000000000000000007C02000000020000003333333333331C400000000000000000CDCCCCCCCCCC1D400000000000000000FE',2,NULL,NULL);
insert into GI_Linestyles_Symbols_Geom (SymbolID , CompID, Geometry, GeomType, CompValue, GI_Style) values(100155,5,x'0001FFFFFFFF000000000080214000000000000000000000000000802B4000000000000000007C0200000002000000000000000080214000000000000000000000000000802B400000000000000000FE',2,NULL,NULL);

-- znak q=mezera navestidla
INSERT INTO gi_font_m_241 VALUES (81, NULL, 1);
INSERT INTO gi_font_m_241 VALUES (113, NULL, 1);

DROP VIEW IF EXISTS GI_Linestyles_View;
CREATE VIEW GI_Linestyles_View AS SELECT GI_Linestyles_Comp.PKID, LinestyleID, GI_Linestyles.Linestyle, GI_Linestyles.Unit, LineID, SortOrder, OffsetX, OffsetY, LineOffsetY, CompType, CompValue, CompJustify, CompPlacement, GI_Style FROM GI_Linestyles_Comp JOIN GI_Linestyles USING (LinestyleID) ORDER BY LinestyleID, LineID, SortOrder;

DROP VIEW IF EXISTS GI_Linestyles_Symbols_Geom_View;

CREATE VIEW GI_Linestyles_Symbols_Geom_View AS SELECT GI_Linestyles_Symbols_Geom.PKID, SymbolID, GI_Linestyles_Symbols.Symbol, CompID, geometry, GeomType, CompValue, GI_Style FROM GI_Linestyles_Symbols_Geom JOIN GI_Linestyles_Symbols USING(SymbolID);

DROP VIEW IF EXISTS GI_Linestyles_Symbols_View;

CREATE VIEW GI_Linestyles_Symbols_View AS SELECT GI_Linestyles_Symbols.Symbol, CastToGeometryCollection(ST_Collect(geometry)) AS geometry FROM GI_Linestyles_Symbols_Geom JOIN GI_Linestyles_Symbols USING(SymbolID) GROUP BY SymbolID;

-- End Linestyles.sql

COMMIT;
